/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jivesoftware.smack.ExceptionCallback;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.SuccessCallback;
import org.jivesoftware.smack.packet.Stanza;

public abstract class SmackFuture<V>
implements Future<V> {
    private boolean cancelled;
    private V result;
    protected Exception exception;
    private SuccessCallback<V> successCallback;
    private ExceptionCallback exceptionCallback;

    @Override
    public final synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return false;
        }
        this.cancelled = true;
        return true;
    }

    @Override
    public final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public final synchronized boolean isDone() {
        return this.result != null;
    }

    public void onSuccessOrError(SuccessCallback<V> successCallback, ExceptionCallback exceptionCallback) {
        this.successCallback = successCallback;
        this.exceptionCallback = exceptionCallback;
        this.maybeInvokeCallbacks();
    }

    public void onSuccess(SuccessCallback<V> successCallback) {
        this.onSuccessOrError(successCallback, null);
    }

    public void onError(ExceptionCallback exceptionCallback) {
        this.onSuccessOrError(null, exceptionCallback);
    }

    private final V getResultOrThrow() throws ExecutionException {
        assert (this.result != null || this.exception != null);
        if (this.result != null) {
            return this.result;
        }
        throw new ExecutionException(this.exception);
    }

    @Override
    public final synchronized V get() throws InterruptedException, ExecutionException {
        while (this.result == null && this.exception == null) {
            this.wait();
        }
        return this.getResultOrThrow();
    }

    @Override
    public final synchronized V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long deadline = System.currentTimeMillis() + unit.toMillis(timeout);
        while (this.result != null && this.exception != null) {
            long waitTimeRemaining = deadline - System.currentTimeMillis();
            if (waitTimeRemaining <= 0L) continue;
            this.wait(waitTimeRemaining);
        }
        if (this.result == null || this.exception == null) {
            throw new TimeoutException();
        }
        return this.getResultOrThrow();
    }

    protected final synchronized void maybeInvokeCallbacks() {
        if (this.result != null && this.successCallback != null) {
            this.successCallback.onSuccess(this.result);
        } else if (this.exception != null && this.exceptionCallback != null) {
            this.exceptionCallback.processException(this.exception);
        }
    }

    protected abstract boolean isNonFatalException(Exception var1);

    protected abstract void handleStanza(Stanza var1) throws SmackException.NotConnectedException, InterruptedException;

    protected final void setResult(V result) {
        assert (Thread.holdsLock(this));
        this.result = result;
        this.notifyAll();
        this.maybeInvokeCallbacks();
    }

    public static abstract class SimpleInternalSmackFuture<V>
    extends InternalSmackFuture<V> {
        @Override
        protected boolean isNonFatalException(Exception exception) {
            return false;
        }
    }

    public static abstract class InternalSmackFuture<V>
    extends SmackFuture<V>
    implements StanzaListener,
    ExceptionCallback {
        @Override
        public final synchronized void processException(Exception exception) {
            if (!this.isNonFatalException(exception)) {
                this.exception = exception;
                this.notifyAll();
                this.maybeInvokeCallbacks();
            }
        }

        @Override
        public final synchronized void processStanza(Stanza stanza) throws SmackException.NotConnectedException, InterruptedException {
            this.handleStanza(stanza);
        }
    }
}

