/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.bytestreams.BytestreamListener;
import org.jivesoftware.smackx.bytestreams.BytestreamManager;
import org.jivesoftware.smackx.bytestreams.socks5.InitiationListener;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamSession;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Client;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5ClientForInitiator;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Proxy;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jxmpp.jid.Jid;

public final class Socks5BytestreamManager
extends Manager
implements BytestreamManager {
    private static final String SESSION_ID_PREFIX = "js5_";
    private static final Random randomGenerator;
    private static final Map<XMPPConnection, Socks5BytestreamManager> managers;
    private final Map<Jid, BytestreamListener> userListeners = new ConcurrentHashMap<Jid, BytestreamListener>();
    private final List<BytestreamListener> allRequestListeners = Collections.synchronizedList(new LinkedList());
    private final InitiationListener initiationListener;
    private int targetResponseTimeout = 10000;
    private int proxyConnectionTimeout = 10000;
    private final Set<Jid> proxyBlacklist = Collections.synchronizedSet(new HashSet());
    private Jid lastWorkingProxy;
    private boolean proxyPrioritizationEnabled = true;
    private final List<String> ignoredBytestreamRequests = Collections.synchronizedList(new LinkedList());

    public static synchronized Socks5BytestreamManager getBytestreamManager(XMPPConnection connection) {
        if (connection == null) {
            return null;
        }
        Socks5BytestreamManager manager = managers.get(connection);
        if (manager == null) {
            manager = new Socks5BytestreamManager(connection);
            managers.put(connection, manager);
        }
        return manager;
    }

    private Socks5BytestreamManager(XMPPConnection connection) {
        super(connection);
        this.initiationListener = new InitiationListener(this);
        this.activate();
    }

    @Override
    public void addIncomingBytestreamListener(BytestreamListener listener) {
        this.allRequestListeners.add(listener);
    }

    @Override
    public void removeIncomingBytestreamListener(BytestreamListener listener) {
        this.allRequestListeners.remove(listener);
    }

    @Override
    public void addIncomingBytestreamListener(BytestreamListener listener, Jid initiatorJID) {
        this.userListeners.put(initiatorJID, listener);
    }

    @Override
    public void removeIncomingBytestreamListener(String initiatorJID) {
        this.userListeners.remove(initiatorJID);
    }

    public void ignoreBytestreamRequestOnce(String sessionID) {
        this.ignoredBytestreamRequests.add(sessionID);
    }

    public synchronized void disableService() {
        ServiceDiscoveryManager serviceDiscoveryManager;
        XMPPConnection connection = this.connection();
        connection.unregisterIQRequestHandler((IQRequestHandler)this.initiationListener);
        this.initiationListener.shutdown();
        this.allRequestListeners.clear();
        this.userListeners.clear();
        this.lastWorkingProxy = null;
        this.proxyBlacklist.clear();
        this.ignoredBytestreamRequests.clear();
        managers.remove(connection);
        if (managers.size() == 0) {
            Socks5Proxy.getSocks5Proxy().stop();
        }
        if ((serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(connection)) != null) {
            serviceDiscoveryManager.removeFeature("http://jabber.org/protocol/bytestreams");
        }
    }

    public int getTargetResponseTimeout() {
        if (this.targetResponseTimeout <= 0) {
            this.targetResponseTimeout = 10000;
        }
        return this.targetResponseTimeout;
    }

    public void setTargetResponseTimeout(int targetResponseTimeout) {
        this.targetResponseTimeout = targetResponseTimeout;
    }

    public int getProxyConnectionTimeout() {
        if (this.proxyConnectionTimeout <= 0) {
            this.proxyConnectionTimeout = 10000;
        }
        return this.proxyConnectionTimeout;
    }

    public void setProxyConnectionTimeout(int proxyConnectionTimeout) {
        this.proxyConnectionTimeout = proxyConnectionTimeout;
    }

    public boolean isProxyPrioritizationEnabled() {
        return this.proxyPrioritizationEnabled;
    }

    public void setProxyPrioritizationEnabled(boolean proxyPrioritizationEnabled) {
        this.proxyPrioritizationEnabled = proxyPrioritizationEnabled;
    }

    @Override
    public Socks5BytestreamSession establishSession(Jid targetJID) throws XMPPException, IOException, InterruptedException, SmackException {
        String sessionID = Socks5BytestreamManager.getNextSessionID();
        return this.establishSession(targetJID, sessionID);
    }

    @Override
    public Socks5BytestreamSession establishSession(Jid targetJID, String sessionID) throws IOException, InterruptedException, SmackException, XMPPException {
        XMPPConnection connection = this.connection();
        XMPPException.XMPPErrorException discoveryException = null;
        if (!this.supportsSocks5(targetJID)) {
            throw new SmackException.FeatureNotSupportedException("SOCKS5 Bytestream", targetJID);
        }
        ArrayList<Jid> proxies = new ArrayList<Jid>();
        try {
            proxies.addAll(this.determineProxies());
        }
        catch (XMPPException.XMPPErrorException e) {
            discoveryException = e;
        }
        List<Bytestream.StreamHost> streamHosts = this.determineStreamHostInfos(proxies);
        if (streamHosts.isEmpty()) {
            if (discoveryException != null) {
                throw discoveryException;
            }
            throw new SmackException("no SOCKS5 proxies available");
        }
        String digest = Socks5Utils.createDigest(sessionID, (Jid)connection.getUser(), targetJID);
        if (this.proxyPrioritizationEnabled && this.lastWorkingProxy != null) {
            Bytestream.StreamHost selectedStreamHost = null;
            for (Bytestream.StreamHost streamHost : streamHosts) {
                if (!streamHost.getJID().equals((CharSequence)this.lastWorkingProxy)) continue;
                selectedStreamHost = streamHost;
                break;
            }
            if (selectedStreamHost != null) {
                streamHosts.remove(selectedStreamHost);
                streamHosts.add(0, selectedStreamHost);
            }
        }
        Socks5Proxy socks5Proxy = Socks5Proxy.getSocks5Proxy();
        try {
            socks5Proxy.addTransfer(digest);
            Bytestream initiation = Socks5BytestreamManager.createBytestreamInitiation(sessionID, targetJID, streamHosts);
            Stanza response = connection.createStanzaCollectorAndSend((IQ)initiation).nextResultOrThrow((long)this.getTargetResponseTimeout());
            Bytestream.StreamHostUsed streamHostUsed = ((Bytestream)response).getUsedHost();
            Bytestream.StreamHost usedStreamHost = initiation.getStreamHost(streamHostUsed.getJID());
            if (usedStreamHost == null) {
                throw new SmackException("Remote user responded with unknown host");
            }
            Socks5ClientForInitiator socks5Client = new Socks5ClientForInitiator(usedStreamHost, digest, connection, sessionID, targetJID);
            Socket socket = ((Socks5Client)socks5Client).getSocket(this.getProxyConnectionTimeout());
            this.lastWorkingProxy = usedStreamHost.getJID();
            Socks5BytestreamSession socks5BytestreamSession = new Socks5BytestreamSession(socket, usedStreamHost.getJID().equals((CharSequence)connection.getUser()));
            return socks5BytestreamSession;
        }
        catch (TimeoutException e) {
            throw new IOException("Timeout while connecting to SOCKS5 proxy");
        }
        finally {
            socks5Proxy.removeTransfer(digest);
        }
    }

    private boolean supportsSocks5(Jid targetJID) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(targetJID, "http://jabber.org/protocol/bytestreams");
    }

    private List<Jid> determineProxies() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        XMPPConnection connection = this.connection();
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(connection);
        ArrayList<Jid> proxies = new ArrayList<Jid>();
        DiscoverItems discoverItems = serviceDiscoveryManager.discoverItems((Jid)connection.getXMPPServiceDomain());
        for (DiscoverItems.Item item : discoverItems.getItems()) {
            DiscoverInfo proxyInfo;
            if (this.proxyBlacklist.contains(item.getEntityID())) continue;
            try {
                proxyInfo = serviceDiscoveryManager.discoverInfo(item.getEntityID());
            }
            catch (SmackException.NoResponseException | XMPPException.XMPPErrorException e) {
                this.proxyBlacklist.add(item.getEntityID());
                continue;
            }
            if (proxyInfo.hasIdentity("proxy", "bytestreams")) {
                proxies.add(item.getEntityID());
                continue;
            }
            this.proxyBlacklist.add(item.getEntityID());
        }
        return proxies;
    }

    private List<Bytestream.StreamHost> determineStreamHostInfos(List<Jid> proxies) {
        XMPPConnection connection = this.connection();
        ArrayList<Bytestream.StreamHost> streamHosts = new ArrayList<Bytestream.StreamHost>();
        List<Bytestream.StreamHost> localProxies = this.getLocalStreamHost();
        if (localProxies != null) {
            streamHosts.addAll(localProxies);
        }
        for (Jid proxy : proxies) {
            Bytestream streamHostRequest = Socks5BytestreamManager.createStreamHostRequest(proxy);
            try {
                Bytestream response = (Bytestream)connection.createStanzaCollectorAndSend((IQ)streamHostRequest).nextResultOrThrow();
                streamHosts.addAll(response.getStreamHosts());
            }
            catch (Exception e) {
                this.proxyBlacklist.add(proxy);
            }
        }
        return streamHosts;
    }

    private static Bytestream createStreamHostRequest(Jid proxy) {
        Bytestream request = new Bytestream();
        request.setType(IQ.Type.get);
        request.setTo(proxy);
        return request;
    }

    private List<Bytestream.StreamHost> getLocalStreamHost() {
        XMPPConnection connection = this.connection();
        Socks5Proxy socks5Server = Socks5Proxy.getSocks5Proxy();
        if (!socks5Server.isRunning()) {
            return null;
        }
        List<String> addresses = socks5Server.getLocalAddresses();
        if (addresses.isEmpty()) {
            return null;
        }
        int port = socks5Server.getPort();
        ArrayList<Bytestream.StreamHost> streamHosts = new ArrayList<Bytestream.StreamHost>();
        block0: for (String address : addresses) {
            String[] loopbackAddresses;
            for (String loopbackAddress : loopbackAddresses = new String[]{"127.0.0.1", "0:0:0:0:0:0:0:1", "::1"}) {
                if (address.startsWith(loopbackAddress)) continue block0;
            }
            streamHosts.add(new Bytestream.StreamHost((Jid)connection.getUser(), address, port));
        }
        return streamHosts;
    }

    private static Bytestream createBytestreamInitiation(String sessionID, Jid targetJID, List<Bytestream.StreamHost> streamHosts) {
        Bytestream initiation = new Bytestream(sessionID);
        for (Bytestream.StreamHost streamHost : streamHosts) {
            initiation.addStreamHost(streamHost);
        }
        initiation.setType(IQ.Type.set);
        initiation.setTo(targetJID);
        return initiation;
    }

    protected void replyRejectPacket(IQ packet) throws SmackException.NotConnectedException, InterruptedException {
        XMPPError.Builder xmppError = XMPPError.getBuilder((XMPPError.Condition)XMPPError.Condition.not_acceptable);
        ErrorIQ errorIQ = IQ.createErrorResponse((IQ)packet, (XMPPError.Builder)xmppError);
        this.connection().sendStanza((Stanza)errorIQ);
    }

    private void activate() {
        this.connection().registerIQRequestHandler((IQRequestHandler)this.initiationListener);
        this.enableService();
    }

    private void enableService() {
        ServiceDiscoveryManager manager = ServiceDiscoveryManager.getInstanceFor(this.connection());
        manager.addFeature("http://jabber.org/protocol/bytestreams");
    }

    private static String getNextSessionID() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(SESSION_ID_PREFIX);
        buffer.append(Math.abs(randomGenerator.nextLong()));
        return buffer.toString();
    }

    protected XMPPConnection getConnection() {
        return this.connection();
    }

    protected BytestreamListener getUserListener(Jid initiator) {
        return this.userListeners.get(initiator);
    }

    protected List<BytestreamListener> getAllRequestListeners() {
        return this.allRequestListeners;
    }

    protected List<String> getIgnoredBytestreamRequests() {
        return this.ignoredBytestreamRequests;
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                Socks5BytestreamManager.getBytestreamManager(connection);
            }
        });
        randomGenerator = new Random();
        managers = new WeakHashMap<XMPPConnection, Socks5BytestreamManager>();
    }
}

