/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.geoloc.packet;

import java.io.Serializable;
import java.net.URI;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public final class GeoLocation
implements Serializable,
ExtensionElement {
    private static final long serialVersionUID = 1L;
    public static final String NAMESPACE = "http://jabber.org/protocol/geoloc";
    public static final String ELEMENT = "geoloc";
    private static final Logger LOGGER = Logger.getLogger(GeoLocation.class.getName());
    private final Double accuracy;
    private final Double alt;
    private final String area;
    private final Double bearing;
    private final String building;
    private final String country;
    private final String countryCode;
    private final String datum;
    private final String description;
    private final Double error;
    private final String floor;
    private final Double lat;
    private final String locality;
    private final Double lon;
    private final String postalcode;
    private final String region;
    private final String room;
    private final Double speed;
    private final String street;
    private final String text;
    private final Date timestamp;
    private final String tzo;
    private final URI uri;

    private GeoLocation(Double accuracy, Double alt, String area, Double bearing, String building, String country, String countryCode, String datum, String description, Double error, String floor, Double lat, String locality, Double lon, String postalcode, String region, String room, Double speed, String street, String text, Date timestamp, String tzo, URI uri) {
        this.accuracy = accuracy;
        this.alt = alt;
        this.area = area;
        this.bearing = bearing;
        this.building = building;
        this.country = country;
        this.countryCode = countryCode;
        if (StringUtils.isNullOrEmpty((CharSequence)datum)) {
            datum = "WGS84";
        }
        this.datum = datum;
        this.description = description;
        if (accuracy != null) {
            error = null;
            LOGGER.log(Level.WARNING, "Error and accuracy set. Ignoring error as it is deprecated in favor of accuracy");
        }
        this.error = error;
        this.floor = floor;
        this.lat = lat;
        this.locality = locality;
        this.lon = lon;
        this.postalcode = postalcode;
        this.region = region;
        this.room = room;
        this.speed = speed;
        this.street = street;
        this.text = text;
        this.timestamp = timestamp;
        this.tzo = tzo;
        this.uri = uri;
    }

    public Double getAccuracy() {
        return this.accuracy;
    }

    public Double getAlt() {
        return this.alt;
    }

    public String getArea() {
        return this.area;
    }

    public Double getBearing() {
        return this.bearing;
    }

    public String getBuilding() {
        return this.building;
    }

    public String getCountry() {
        return this.country;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getDatum() {
        return this.datum;
    }

    public String getDescription() {
        return this.description;
    }

    public Double getError() {
        return this.error;
    }

    public String getFloor() {
        return this.floor;
    }

    public Double getLat() {
        return this.lat;
    }

    public String getLocality() {
        return this.locality;
    }

    public Double getLon() {
        return this.lon;
    }

    public String getPostalcode() {
        return this.postalcode;
    }

    public String getRegion() {
        return this.region;
    }

    public String getRoom() {
        return this.room;
    }

    public Double getSpeed() {
        return this.speed;
    }

    public String getStreet() {
        return this.street;
    }

    public String getText() {
        return this.text;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getTzo() {
        return this.tzo;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getElementName() {
        return ELEMENT;
    }

    public CharSequence toXML() {
        XmlStringBuilder xml = new XmlStringBuilder((ExtensionElement)this);
        xml.rightAngleBracket();
        xml.optElement("accuracy", (Object)this.accuracy);
        xml.optElement("alt", (Object)this.alt);
        xml.optElement("area", this.area);
        xml.optElement("bearing", (Object)this.bearing);
        xml.optElement("building", this.building);
        xml.optElement("country", this.country);
        xml.optElement("countrycode", this.countryCode);
        xml.optElement("datum", this.datum);
        xml.optElement("description", this.description);
        xml.optElement("error", (Object)this.error);
        xml.optElement("floor", this.floor);
        xml.optElement("lat", (Object)this.lat);
        xml.optElement("locality", this.locality);
        xml.optElement("lon", (Object)this.lon);
        xml.optElement("postalcode", this.postalcode);
        xml.optElement("region", this.region);
        xml.optElement("room", this.room);
        xml.optElement("speed", (Object)this.speed);
        xml.optElement("street", this.street);
        xml.optElement("text", this.text);
        xml.optElement("timestamp", this.timestamp);
        xml.optElement("tzo", this.tzo);
        xml.optElement("uri", (Object)this.uri);
        xml.closeElement((NamedElement)this);
        return xml;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static GeoLocation from(Message message) {
        return (GeoLocation)message.getExtension(ELEMENT, NAMESPACE);
    }

    public static class Builder {
        private Double accuracy;
        private Double alt;
        private String area;
        private Double bearing;
        private String building;
        private String country;
        private String countryCode;
        private String datum;
        private String description;
        private Double error;
        private String floor;
        private Double lat;
        private String locality;
        private Double lon;
        private String postalcode;
        private String region;
        private String room;
        private Double speed;
        private String street;
        private String text;
        private Date timestamp;
        private String tzo;
        private URI uri;

        public Builder setAccuracy(Double accuracy) {
            this.accuracy = accuracy;
            return this;
        }

        public Builder setAlt(Double alt) {
            this.alt = alt;
            return this;
        }

        public Builder setArea(String area) {
            this.area = area;
            return this;
        }

        public Builder setBearing(Double bearing) {
            this.bearing = bearing;
            return this;
        }

        public Builder setBuilding(String building) {
            this.building = building;
            return this;
        }

        public Builder setCountry(String country) {
            this.country = country;
            return this;
        }

        public Builder setCountryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public Builder setDatum(String datum) {
            this.datum = datum;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setError(Double error) {
            this.error = error;
            return this;
        }

        public Builder setFloor(String floor) {
            this.floor = floor;
            return this;
        }

        public Builder setLat(Double lat) {
            this.lat = lat;
            return this;
        }

        public Builder setLocality(String locality) {
            this.locality = locality;
            return this;
        }

        public Builder setLon(Double lon) {
            this.lon = lon;
            return this;
        }

        public Builder setPostalcode(String postalcode) {
            this.postalcode = postalcode;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setRoom(String room) {
            this.room = room;
            return this;
        }

        public Builder setSpeed(Double speed) {
            this.speed = speed;
            return this;
        }

        public Builder setStreet(String street) {
            this.street = street;
            return this;
        }

        public Builder setText(String text) {
            this.text = text;
            return this;
        }

        public Builder setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder setTzo(String tzo) {
            this.tzo = tzo;
            return this;
        }

        public Builder setUri(URI uri) {
            this.uri = uri;
            return this;
        }

        public GeoLocation build() {
            return new GeoLocation(this.accuracy, this.alt, this.area, this.bearing, this.building, this.country, this.countryCode, this.datum, this.description, this.error, this.floor, this.lat, this.locality, this.lon, this.postalcode, this.region, this.room, this.speed, this.street, this.text, this.timestamp, this.tzo, this.uri);
        }
    }
}

