/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.util;

import java.io.Reader;
import java.io.StringReader;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jxmpp.jid.impl.JidCreate;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;

public final class IQUtils {
    private static XmlPullParserFactory xmlPullParserFactory;

    public static IQ convert(org.jivesoftware.smack.packet.IQ smackIQ) throws Exception {
        XmlStringBuilder xml = smackIQ.toXML();
        SAXReader saxReader = new SAXReader();
        Document document = saxReader.read((Reader)new StringReader(xml.toString()));
        Element element = document.getRootElement();
        IQ iq = new IQ(element);
        iq.setID(smackIQ.getStanzaId());
        iq.setType(IQUtils.convert(smackIQ.getType()));
        return iq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static org.jivesoftware.smack.packet.IQ convert(IQ iq) throws Exception {
        Element element = iq.getChildElement();
        IQProvider iqProvider = null;
        if (element != null) {
            iqProvider = ProviderManager.getIQProvider((String)element.getName(), (String)element.getNamespaceURI());
        }
        IQ.Type type = iq.getType();
        org.jivesoftware.smack.packet.IQ smackIQ = null;
        XMPPError.Builder smackError = null;
        if (iqProvider != null || iq.getError() != null) {
            Class<IQUtils> clazz = IQUtils.class;
            // MONITORENTER : org.jitsi.xmpp.util.IQUtils.class
            if (xmlPullParserFactory == null) {
                xmlPullParserFactory = XmlPullParserFactory.newInstance();
                xmlPullParserFactory.setNamespaceAware(true);
            }
            XmlPullParserFactory xmlPullParserFactory = IQUtils.xmlPullParserFactory;
            // MONITOREXIT : clazz
            XmlPullParser parser = xmlPullParserFactory.newPullParser();
            parser.setInput((Reader)new StringReader(iq.toXML()));
            int eventType = parser.next();
            if (2 != eventType) {
                throw new IllegalStateException(Integer.toString(eventType) + " != XmlPullParser.START_TAG");
            }
            String name = parser.getName();
            if (!"iq".equals(name)) {
                throw new IllegalStateException(name + " != iq");
            }
            while (true) {
                eventType = parser.next();
                name = parser.getName();
                if (2 == eventType) {
                    if (IQ.Type.error.equals((Object)type) && "error".equals(name)) {
                        smackError = PacketParserUtils.parseError((XmlPullParser)parser);
                        continue;
                    }
                    if (smackIQ != null || iqProvider == null) continue;
                    smackIQ = (org.jivesoftware.smack.packet.IQ)iqProvider.parse(parser);
                    continue;
                }
                if (3 == eventType && "iq".equals(name) || smackIQ != null && smackError != null || 1 == eventType) break;
            }
            eventType = parser.getEventType();
            if (3 != eventType) {
                throw new IllegalStateException(Integer.toString(eventType) + " != XmlPullParser.END_TAG");
            }
        }
        if (smackIQ == null && (IQ.Type.error.equals((Object)type) || IQ.Type.result.equals((Object)type))) {
            smackIQ = new org.jivesoftware.smack.packet.IQ(null){

                protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
                    return xml;
                }
            };
        }
        if (smackIQ == null) return smackIQ;
        JID fromJID = iq.getFrom();
        if (fromJID != null) {
            smackIQ.setFrom(JidCreate.from((String)fromJID.toString()));
        }
        smackIQ.setStanzaId(iq.getID());
        JID toJID = iq.getTo();
        if (toJID != null) {
            smackIQ.setTo(JidCreate.from((String)toJID.toString()));
        }
        smackIQ.setType(IQUtils.convert(type));
        if (smackError == null) return smackIQ;
        smackIQ.setError(smackError);
        return smackIQ;
    }

    public static IQ.Type convert(IQ.Type smackType) {
        return IQ.Type.valueOf((String)smackType.toString());
    }

    public static IQ.Type convert(IQ.Type type) {
        return IQ.Type.fromString((String)type.name());
    }

    public static org.jivesoftware.smack.packet.IQ createError(org.jivesoftware.smack.packet.IQ request, XMPPError.Condition errorCondition) {
        return IQUtils.createError(request, errorCondition, null);
    }

    public static org.jivesoftware.smack.packet.IQ createError(org.jivesoftware.smack.packet.IQ request, XMPPError.Condition errorCondition, String errorMessage) {
        XMPPError.Builder error = XMPPError.getBuilder((XMPPError.Condition)errorCondition);
        if (errorMessage != null) {
            error.setDescriptiveEnText(errorMessage);
        }
        return org.jivesoftware.smack.packet.IQ.createErrorResponse((org.jivesoftware.smack.packet.IQ)request, (XMPPError.Builder)error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends org.jivesoftware.smack.packet.IQ> T parse(String iqStr, IQProvider<T> iqProvider) throws Exception {
        org.jivesoftware.smack.packet.IQ smackIQ = null;
        if (iqProvider == null) return (T)smackIQ;
        Class<IQUtils> clazz = IQUtils.class;
        synchronized (IQUtils.class) {
            if (xmlPullParserFactory == null) {
                xmlPullParserFactory = XmlPullParserFactory.newInstance();
                xmlPullParserFactory.setNamespaceAware(true);
            }
            XmlPullParserFactory xmlPullParserFactory = IQUtils.xmlPullParserFactory;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            XmlPullParser parser = xmlPullParserFactory.newPullParser();
            parser.setInput((Reader)new StringReader(iqStr));
            int eventType = parser.next();
            if (2 != eventType) throw new IllegalStateException(Integer.toString(eventType) + " != XmlPullParser.START_TAG");
            String name = parser.getName();
            if (!"iq".equals(name)) throw new IllegalStateException(name + " != iq");
            String packetId = parser.getAttributeValue("", "id");
            String from = parser.getAttributeValue("", "from");
            String to = parser.getAttributeValue("", "to");
            String type = parser.getAttributeValue("", "type");
            eventType = parser.next();
            if (2 != eventType) throw new IllegalStateException(Integer.toString(eventType) + " != XmlPullParser.START_TAG");
            smackIQ = (org.jivesoftware.smack.packet.IQ)iqProvider.parse(parser);
            if (smackIQ == null) return (T)smackIQ;
            eventType = parser.getEventType();
            if (3 != eventType) {
                throw new IllegalStateException(Integer.toString(eventType) + " != XmlPullParser.END_TAG");
            }
            smackIQ.setType(IQ.Type.fromString((String)type));
            smackIQ.setStanzaId(packetId);
            smackIQ.setFrom(JidCreate.from((String)from));
            smackIQ.setTo(JidCreate.from((String)to));
            return (T)smackIQ;
        }
    }

    public static String responseToXML(Stanza response) {
        return response != null ? response.toXML().toString() : "(timeout)";
    }

    private IQUtils() {
    }
}

