/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.jabber.AbstractContactGroupJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ContactJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ServerStoredContactListJabberImpl;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smack.roster.RosterGroup;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class ContactGroupJabberImpl
extends AbstractContactGroupJabberImpl {
    private Map<Jid, Contact> buddies = new Hashtable<Jid, Contact>();
    private boolean isResolved = false;
    private String id = null;
    private String nameCopy = null;
    private String tempId = null;
    private final ServerStoredContactListJabberImpl ssclCallback;

    ContactGroupJabberImpl(RosterGroup rosterGroup, Iterator<RosterEntry> groupMembers, ServerStoredContactListJabberImpl ssclCallback, boolean isResolved) {
        if (rosterGroup != null) {
            this.id = rosterGroup.getName();
        }
        this.isResolved = isResolved;
        this.ssclCallback = ssclCallback;
        if (rosterGroup != null) {
            this.nameCopy = rosterGroup.getName();
        }
        while (groupMembers.hasNext()) {
            RosterEntry rEntry = groupMembers.next();
            if (!ServerStoredContactListJabberImpl.isEntryDisplayable(rEntry) || ssclCallback.findContactById((Jid)rEntry.getJid()) != null) continue;
            this.addContact(new ContactJabberImpl(rEntry, ssclCallback, true, true));
        }
    }

    ContactGroupJabberImpl(String id, ServerStoredContactListJabberImpl ssclCallback) {
        this.tempId = id;
        this.isResolved = false;
        this.ssclCallback = ssclCallback;
    }

    public int countContacts() {
        return this.buddies.size();
    }

    public ContactGroup getParentContactGroup() {
        return this.ssclCallback.getRootGroup();
    }

    @Override
    public void addContact(ContactJabberImpl contact) {
        this.buddies.put(contact.getAddressAsJid(), (Contact)contact);
    }

    void removeContact(ContactJabberImpl contact) {
        this.buddies.remove(contact.getAddressAsJid());
    }

    public Iterator<Contact> contacts() {
        return this.buddies.values().iterator();
    }

    public Contact getContact(String id) {
        try {
            return this.findContact(JidCreate.from((String)id));
        }
        catch (XmppStringprepException e) {
            return null;
        }
    }

    public String getGroupName() {
        if (this.isResolved) {
            return this.id;
        }
        return this.tempId;
    }

    public boolean canContainSubgroups() {
        return false;
    }

    public ContactGroup getGroup(int index) {
        return null;
    }

    public ContactGroup getGroup(String groupName) {
        return null;
    }

    public Iterator<ContactGroup> subgroups() {
        return Collections.emptyListIterator();
    }

    public int countSubgroups() {
        return 0;
    }

    public int hashCode() {
        return this.getGroupName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ContactGroupJabberImpl)) {
            return false;
        }
        if (!((ContactGroup)obj).getGroupName().equals(this.getGroupName())) {
            return false;
        }
        return this.getProtocolProvider() == ((ContactGroup)obj).getProtocolProvider();
    }

    public ProtocolProviderService getProtocolProvider() {
        return this.ssclCallback.getParentProvider();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("JabberGroup.");
        buff.append(this.getGroupName()).append(", childContacts=").append(this.countContacts()).append(":[");
        Iterator<Contact> contacts = this.contacts();
        while (contacts.hasNext()) {
            Contact contact = contacts.next();
            buff.append(contact.toString());
            if (!contacts.hasNext()) continue;
            buff.append(", ");
        }
        return buff.append("]").toString();
    }

    ContactJabberImpl findContact(Jid id) {
        if (id == null) {
            return null;
        }
        return (ContactJabberImpl)this.buddies.get(id);
    }

    void setNameCopy(String newName) {
        this.nameCopy = newName;
    }

    String getNameCopy() {
        return this.nameCopy;
    }

    public boolean isPersistent() {
        return true;
    }

    public String getPersistentData() {
        return null;
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    void setResolved(RosterGroup source) {
        if (this.isResolved) {
            return;
        }
        this.isResolved = true;
        this.id = source.getName();
        for (RosterEntry item : source.getEntries()) {
            ContactJabberImpl contact = this.ssclCallback.findContactById((Jid)item.getJid());
            if (!ServerStoredContactListJabberImpl.isEntryDisplayable(item)) {
                if (contact == null) continue;
                this.removeContact(contact);
                this.ssclCallback.fireContactRemoved(this, contact);
                continue;
            }
            if (contact != null) {
                contact.setResolved(item);
                this.ssclCallback.fireContactResolved(this, contact);
                continue;
            }
            ContactJabberImpl newContact = new ContactJabberImpl(item, this.ssclCallback, true, true);
            this.addContact(newContact);
            this.ssclCallback.fireContactAdded(this, newContact);
        }
    }

    public String getUID() {
        return this.getGroupName();
    }

    RosterGroup getSourceGroup() {
        return this.ssclCallback.getRosterGroup(this.id);
    }

    void setSourceGroup(RosterGroup newGroup) {
        this.id = newGroup.getName();
    }
}

