/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.ArrayList;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.service.protocol.OperationSetUserSearch;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.service.protocol.event.UserSearchProviderEvent;
import net.java.sip.communicator.service.protocol.event.UserSearchProviderListener;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.search.ReportedData;
import org.jivesoftware.smackx.search.UserSearchManager;
import org.jivesoftware.smackx.xdata.Form;
import org.jivesoftware.smackx.xdata.FormField;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class OperationSetUserSearchJabberImpl
implements OperationSetUserSearch,
RegistrationStateChangeListener {
    private static final Logger logger = Logger.getLogger(OperationSetUserSearchJabberImpl.class);
    private UserSearchManager searchManager = null;
    private ProtocolProviderServiceJabberImpl provider;
    private DomainBareJid serviceName = null;
    private Boolean userSearchEnabled = false;
    private final List<UserSearchProviderListener> listeners = new ArrayList<UserSearchProviderListener>();
    private static final String USER_SEARCH_SERVICE_NAME = "USER_SEARCH_SERVICE_NAME";

    protected OperationSetUserSearchJabberImpl(ProtocolProviderServiceJabberImpl provider) {
        this.provider = provider;
        String accountServiceName = provider.getAccountID().getAccountPropertyString((Object)USER_SEARCH_SERVICE_NAME);
        if (accountServiceName == null) {
            provider.addRegistrationStateChangeListener(this);
        } else {
            try {
                this.serviceName = JidCreate.domainBareFrom((String)accountServiceName);
                this.setUserSearchEnabled(true);
            }
            catch (XmppStringprepException e) {
                logger.error((Object)"USER_SEARCH_SERVICE_NAME is not a valid JID", (Throwable)e);
                provider.addRegistrationStateChangeListener(this);
            }
        }
    }

    private void setUserSearchEnabled(boolean isEnabled) {
        this.userSearchEnabled = isEnabled;
        int type = isEnabled ? UserSearchProviderEvent.PROVIDER_ADDED : UserSearchProviderEvent.PROVIDER_REMOVED;
        this.fireUserSearchProviderEvent(new UserSearchProviderEvent((ProtocolProviderService)this.provider, type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireUserSearchProviderEvent(UserSearchProviderEvent event) {
        ArrayList<UserSearchProviderListener> tmpListeners;
        List<UserSearchProviderListener> list = this.listeners;
        synchronized (list) {
            tmpListeners = new ArrayList<UserSearchProviderListener>(this.listeners);
        }
        for (UserSearchProviderListener l : tmpListeners) {
            l.onUserSearchProviderEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        if (evt.getNewState().equals((Object)RegistrationState.REGISTERED)) {
            this.discoverSearchService();
        } else if (evt.getNewState() == RegistrationState.UNREGISTERED || evt.getNewState() == RegistrationState.AUTHENTICATION_FAILED || evt.getNewState() == RegistrationState.CONNECTION_FAILED) {
            Boolean bl = this.userSearchEnabled;
            synchronized (bl) {
                this.setUserSearchEnabled(false);
            }
        }
    }

    private void discoverSearchService() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Boolean bl = OperationSetUserSearchJabberImpl.this.userSearchEnabled;
                synchronized (bl) {
                    List serviceNames = null;
                    try {
                        UserSearchManager usm = new UserSearchManager(OperationSetUserSearchJabberImpl.this.provider.getConnection());
                        serviceNames = usm.getSearchServices();
                    }
                    catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
                        logger.error((Object)"Failed to search for service names", e);
                    }
                    if (serviceNames != null && !serviceNames.isEmpty()) {
                        OperationSetUserSearchJabberImpl.this.serviceName = (DomainBareJid)serviceNames.get(0);
                        OperationSetUserSearchJabberImpl.this.setUserSearchEnabled(true);
                    } else {
                        OperationSetUserSearchJabberImpl.this.setUserSearchEnabled(false);
                    }
                }
            }
        }.start();
    }

    public void createSearchManager() {
        if (this.searchManager == null) {
            this.searchManager = new UserSearchManager(this.provider.getConnection());
        }
    }

    public void removeSearchManager() {
        this.searchManager = null;
    }

    public List<String> search(String searchedString) {
        ReportedData data = null;
        try {
            Form form = this.searchManager.getSearchForm(this.serviceName);
            data = this.searchManager.getSearchResults(form, this.serviceName);
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException e) {
            logger.error((Object)e);
            return null;
        }
        if (data == null) {
            logger.error((Object)"No data have been received from server.");
            return null;
        }
        List columns = data.getColumns();
        List rows = data.getRows();
        if (columns == null || rows == null) {
            logger.error((Object)"The received data is corrupted.");
            return null;
        }
        ReportedData.Column jidColumn = null;
        for (ReportedData.Column tmpCollumn : columns) {
            if (!tmpCollumn.getType().equals((Object)FormField.Type.jid_single)) continue;
            jidColumn = tmpCollumn;
            break;
        }
        if (jidColumn == null) {
            logger.error((Object)"No jid collumn provided by the server.");
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (ReportedData.Row row : rows) {
            result.add((String)row.getValues(jidColumn.getVariable()).get(0));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserSearchProviderListener(UserSearchProviderListener l) {
        List<UserSearchProviderListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserSearchProviderListener(UserSearchProviderListener l) {
        List<UserSearchProviderListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    public boolean isEnabled() {
        return this.userSearchEnabled;
    }
}

