/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.Iterator;
import net.java.sip.communicator.impl.protocol.jabber.CallJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationNotSupportedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetTelephonyConferencing;
import net.java.sip.communicator.service.protocol.OperationSetVideoBridge;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallConference;
import org.jitsi.xmpp.extensions.colibri.ColibriConferenceIQ;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jxmpp.jid.Jid;

public class OperationSetVideoBridgeImpl
extends AbstractIqRequestHandler
implements OperationSetVideoBridge,
RegistrationStateChangeListener {
    private final ProtocolProviderServiceJabberImpl protocolProvider;

    public OperationSetVideoBridgeImpl(ProtocolProviderServiceJabberImpl protocolProvider) {
        super("conference", "http://jitsi.org/protocol/colibri", IQ.Type.set, IQRequestHandler.Mode.async);
        this.protocolProvider = protocolProvider;
        this.protocolProvider.addRegistrationStateChangeListener(this);
    }

    public Call createConfCall(String[] callees) throws OperationFailedException, OperationNotSupportedException {
        return ((OperationSetTelephonyConferencing)this.protocolProvider.getOperationSet(OperationSetTelephonyConferencing.class)).createConfCall(callees, (CallConference)new MediaAwareCallConference(true));
    }

    public CallPeer inviteCalleeToCall(String uri, Call call) throws OperationFailedException, OperationNotSupportedException {
        return ((OperationSetTelephonyConferencing)this.protocolProvider.getOperationSet(OperationSetTelephonyConferencing.class)).inviteCalleeToCall(uri, call);
    }

    public boolean isActive() {
        Jid jitsiVideobridge = this.protocolProvider.getJitsiVideobridge();
        return jitsiVideobridge != null && jitsiVideobridge.length() > 0;
    }

    private void processColibriConferenceIQ(ColibriConferenceIQ conferenceIQ) {
        block1: {
            CallJabberImpl callJabberImpl;
            MediaAwareCallConference conference;
            Call call;
            OperationSetBasicTelephony basicTelephony;
            if (!IQ.Type.set.equals((Object)conferenceIQ.getType()) || conferenceIQ.getID() == null || (basicTelephony = (OperationSetBasicTelephony)this.protocolProvider.getOperationSet(OperationSetBasicTelephony.class)) == null) break block1;
            Iterator i = basicTelephony.getActiveCalls();
            while (!(!i.hasNext() || (call = (Call)i.next()) instanceof CallJabberImpl && (conference = (callJabberImpl = (CallJabberImpl)call).getConference()) != null && conference.isJitsiVideobridge() && callJabberImpl.processColibriConferenceIQ(conferenceIQ))) {
            }
        }
    }

    public IQ handleIQRequest(IQ iqRequest) {
        ColibriConferenceIQ conferenceIQ = (ColibriConferenceIQ)iqRequest;
        this.processColibriConferenceIQ(conferenceIQ);
        return IQ.createResultIQ((IQ)iqRequest);
    }

    public void registrationStateChanged(RegistrationStateChangeEvent ev) {
        XMPPConnection connection;
        RegistrationState registrationState = ev.getNewState();
        if (RegistrationState.REGISTERED.equals((Object)registrationState)) {
            this.protocolProvider.getConnection().registerIQRequestHandler((IQRequestHandler)this);
        } else if (RegistrationState.UNREGISTERED.equals((Object)registrationState) && (connection = this.protocolProvider.getConnection()) != null) {
            connection.unregisterIQRequestHandler((IQRequestHandler)this);
        }
    }
}

