/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.CallPeerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.TransportInfoSender;
import net.java.sip.communicator.impl.protocol.jabber.TransportManagerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.jinglesdp.JingleUtils;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.utils.MediaType;
import org.jitsi.xmpp.extensions.colibri.ColibriConferenceIQ;
import org.jitsi.xmpp.extensions.jingle.CandidatePacketExtension;
import org.jitsi.xmpp.extensions.jingle.CandidateType;
import org.jitsi.xmpp.extensions.jingle.ContentPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.RawUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.RtpDescriptionPacketExtension;
import org.jivesoftware.smack.packet.ExtensionElement;

public class RawUdpTransportManager
extends TransportManagerJabberImpl {
    private List<ContentPacketExtension> local;
    private final List<Iterable<ContentPacketExtension>> remotes = new LinkedList<Iterable<ContentPacketExtension>>();

    public RawUdpTransportManager(CallPeerJabberImpl callPeer) {
        super(callPeer);
    }

    @Override
    protected ExtensionElement createTransport(String media) throws OperationFailedException {
        MediaType mediaType = MediaType.parseString((String)media);
        return this.createTransport(mediaType, this.getStreamConnector(mediaType));
    }

    private RawUdpTransportPacketExtension createTransport(MediaType mediaType, StreamConnector connector) {
        RawUdpTransportPacketExtension ourTransport = new RawUdpTransportPacketExtension();
        int generation = this.getCurrentGeneration();
        CandidatePacketExtension rtpCand = new CandidatePacketExtension();
        rtpCand.setComponent(1);
        rtpCand.setGeneration(generation);
        rtpCand.setID(this.getNextID());
        rtpCand.setType(CandidateType.host);
        DatagramSocket dataSocket = connector.getDataSocket();
        rtpCand.setIP(dataSocket.getLocalAddress().getHostAddress());
        rtpCand.setPort(dataSocket.getLocalPort());
        ourTransport.addCandidate(rtpCand);
        CandidatePacketExtension rtcpCand = new CandidatePacketExtension();
        rtcpCand.setComponent(2);
        rtcpCand.setGeneration(generation);
        rtcpCand.setID(this.getNextID());
        rtcpCand.setType(CandidateType.host);
        DatagramSocket controlSocket = connector.getControlSocket();
        rtcpCand.setIP(controlSocket.getLocalAddress().getHostAddress());
        rtcpCand.setPort(controlSocket.getLocalPort());
        ourTransport.addCandidate(rtcpCand);
        return ourTransport;
    }

    @Override
    protected ExtensionElement createTransportPacketExtension() {
        return new RawUdpTransportPacketExtension();
    }

    @Override
    public MediaStreamTarget getStreamTarget(MediaType mediaType) {
        ColibriConferenceIQ.Channel channel = this.getColibriChannel(mediaType, true);
        MediaStreamTarget streamTarget = null;
        if (channel == null) {
            String media = mediaType.toString();
            block0: for (Iterable<ContentPacketExtension> remote : this.remotes) {
                for (ContentPacketExtension content : remote) {
                    RtpDescriptionPacketExtension rtpDescription = (RtpDescriptionPacketExtension)content.getFirstChildOfType(RtpDescriptionPacketExtension.class);
                    if (!media.equals(rtpDescription.getMedia())) continue;
                    streamTarget = JingleUtils.extractDefaultTarget(content);
                    continue block0;
                }
            }
        } else {
            String host;
            IceUdpTransportPacketExtension transport = channel.getTransport();
            if (transport != null) {
                streamTarget = JingleUtils.extractDefaultTarget(transport);
            }
            if (streamTarget == null && (host = channel.getHost()) != null) {
                int rtpPort = channel.getRTPPort();
                int rtcpPort = channel.getRTCPPort();
                streamTarget = new MediaStreamTarget(new InetSocketAddress(host, rtpPort), new InetSocketAddress(host, rtcpPort));
            }
        }
        return streamTarget;
    }

    @Override
    public String getXmlNamespace() {
        return "urn:xmpp:jingle:transports:raw-udp:1";
    }

    @Override
    public void removeContent(String name) {
        if (this.local != null) {
            this.removeContent(this.local, name);
        }
        this.removeRemoteContent(name);
    }

    private void removeRemoteContent(String name) {
        Iterator<Iterable<ContentPacketExtension>> remoteIter = this.remotes.iterator();
        while (remoteIter.hasNext()) {
            Iterable<ContentPacketExtension> remote = remoteIter.next();
            if (this.removeContent(remote, name) == null || remote.iterator().hasNext()) continue;
            remoteIter.remove();
        }
    }

    @Override
    protected ExtensionElement startCandidateHarvest(ContentPacketExtension theirContent, ContentPacketExtension ourContent, TransportInfoSender transportInfoSender, String media) throws OperationFailedException {
        return this.createTransportForStartCandidateHarvest(media);
    }

    @Override
    public void startCandidateHarvest(List<ContentPacketExtension> theirOffer, List<ContentPacketExtension> ourAnswer, TransportInfoSender transportInfoSender) throws OperationFailedException {
        this.local = ourAnswer;
        super.startCandidateHarvest(theirOffer, ourAnswer, transportInfoSender);
    }

    @Override
    public boolean startConnectivityEstablishment(Iterable<ContentPacketExtension> remote) throws OperationFailedException {
        if (remote != null && !this.remotes.contains(remote)) {
            for (ContentPacketExtension content : remote) {
                this.removeRemoteContent(content.getName());
            }
            this.remotes.add(remote);
        }
        return super.startConnectivityEstablishment(remote);
    }

    @Override
    public List<ContentPacketExtension> wrapupCandidateHarvest() {
        return this.local;
    }

    public String getICECandidateExtendedType(String streamName) {
        return null;
    }

    public String getICEState() {
        return null;
    }

    public InetSocketAddress getICELocalHostAddress(String streamName) {
        return null;
    }

    public InetSocketAddress getICERemoteHostAddress(String streamName) {
        return null;
    }

    public InetSocketAddress getICELocalReflexiveAddress(String streamName) {
        return null;
    }

    public InetSocketAddress getICERemoteReflexiveAddress(String streamName) {
        return null;
    }

    public InetSocketAddress getICELocalRelayedAddress(String streamName) {
        return null;
    }

    public InetSocketAddress getICERemoteRelayedAddress(String streamName) {
        return null;
    }

    public long getTotalHarvestingTime() {
        return 0L;
    }

    public long getHarvestingTime(String harvesterName) {
        return 0L;
    }

    public int getNbHarvesting() {
        return 0;
    }

    public int getNbHarvesting(String harvesterName) {
        return 0;
    }

    @Override
    public void setRtcpmux(boolean rtcpmux) {
        if (rtcpmux) {
            throw new IllegalArgumentException("rtcp mux not supported by " + ((Object)((Object)this)).getClass().getSimpleName());
        }
    }
}

