/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.configuration;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.jitsi.impl.configuration.ChangeEventDispatcher;
import org.jitsi.impl.configuration.ConfigurationStore;
import org.jitsi.impl.configuration.PropertyConfigurationStore;
import org.jitsi.impl.configuration.xml.XMLConfigurationStore;
import org.jitsi.service.configuration.ConfigPropertyVetoException;
import org.jitsi.service.configuration.ConfigVetoableChangeListener;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.fileaccess.FailSafeTransaction;
import org.jitsi.service.fileaccess.FileAccessService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.util.OSUtils;
import org.jitsi.util.PasswordUtil;
import org.jitsi.util.xml.XMLException;
import org.jitsi.utils.StringUtils;
import org.jitsi.utils.logging.Logger;

public class ConfigurationServiceImpl
implements ConfigurationService {
    private final Logger logger = Logger.getLogger(ConfigurationServiceImpl.class);
    private static final String DEFAULT_CONFIGURATION_STORE_CLASS_NAME = "net.java.sip.communicator.impl.configuration.SQLiteConfigurationStore";
    private static final String SYS_PROPS_FILE_NAME_PROPERTY = "net.java.sip.communicator.SYS_PROPS_FILE_NAME";
    private static final String DEFAULT_PROPS_FILE_NAME = "jitsi-defaults.properties";
    private static final String DEFAULT_OVERRIDES_PROPS_FILE_NAME = "jitsi-default-overrides.properties";
    public static String PASSWORD_CMD_LINE_ARGS;
    public static String PASSWORD_SYS_PROPS;
    private File configurationFile = null;
    private Map<String, String> immutableDefaultProperties = new HashMap<String, String>();
    private Map<String, String> defaultProperties = new HashMap<String, String>();
    private final ChangeEventDispatcher changeEventDispatcher = new ChangeEventDispatcher(this);
    private FileAccessService faService;
    private boolean faServiceIsAssigned = false;
    private ConfigurationStore store;

    public ConfigurationServiceImpl() {
        try {
            this.debugPrintSystemProperties();
            this.preloadSystemPropertyFiles();
            this.loadDefaultProperties();
            this.reloadConfiguration();
        }
        catch (IOException ex) {
            this.logger.error((Object)"Failed to load the configuration file", (Throwable)ex);
        }
    }

    @Override
    public void setProperty(String propertyName, Object property) throws ConfigPropertyVetoException {
        this.setProperty(propertyName, property, false);
    }

    @Override
    public void setProperty(String propertyName, Object property, boolean isSystem) throws ConfigPropertyVetoException {
        Object oldValue = this.getProperty(propertyName);
        if (this.changeEventDispatcher.hasVetoableChangeListeners(propertyName)) {
            this.changeEventDispatcher.fireVetoableChange(propertyName, oldValue, property);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(propertyName + "( oldValue=" + oldValue + ", newValue=" + property + "."));
        }
        this.doSetProperty(propertyName, property, isSystem);
        try {
            this.storeConfiguration();
        }
        catch (IOException ex) {
            this.logger.error((Object)"Failed to store configuration after a property change");
        }
        if (this.changeEventDispatcher.hasPropertyChangeListeners(propertyName)) {
            this.changeEventDispatcher.firePropertyChange(propertyName, oldValue, property);
        }
    }

    @Override
    public void setProperties(Map<String, Object> properties) throws ConfigPropertyVetoException {
        String propertyName;
        HashMap<String, Object> oldValues = new HashMap<String, Object>(properties.size());
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            propertyName = property.getKey();
            Object oldValue = this.getProperty(propertyName);
            oldValues.put(propertyName, oldValue);
            if (!this.changeEventDispatcher.hasVetoableChangeListeners(propertyName)) continue;
            this.changeEventDispatcher.fireVetoableChange(propertyName, oldValue, property.getValue());
        }
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            this.doSetProperty(property.getKey(), property.getValue(), false);
        }
        try {
            this.storeConfiguration();
        }
        catch (IOException ex) {
            this.logger.error((Object)"Failed to store configuration after property changes");
        }
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            propertyName = property.getKey();
            if (!this.changeEventDispatcher.hasPropertyChangeListeners(propertyName)) continue;
            this.changeEventDispatcher.firePropertyChange(propertyName, oldValues.get(propertyName), property.getValue());
        }
    }

    private void doSetProperty(String propertyName, Object property, boolean isSystem) {
        if (this.isSystemProperty(propertyName)) {
            isSystem = true;
        }
        if (this.immutableDefaultProperties.containsKey(propertyName)) {
            return;
        }
        if (property == null) {
            this.store.removeProperty(propertyName);
            if (isSystem) {
                System.setProperty(propertyName, "");
            }
        } else if (isSystem) {
            System.setProperty(propertyName, property.toString());
            this.store.setSystemProperty(propertyName);
        } else {
            this.store.setNonSystemProperty(propertyName, property);
        }
    }

    @Override
    public void removeProperty(String propertyName) {
        List<String> childPropertyNames = this.getPropertyNamesByPrefix(propertyName, false);
        for (String pName : childPropertyNames) {
            this.removePropertyInternal(pName);
        }
        try {
            this.storeConfiguration();
        }
        catch (IOException ex) {
            this.logger.error((Object)"Failed to store configuration after a property change");
        }
    }

    private void removePropertyInternal(String propertyName) {
        Object oldValue = this.getProperty(propertyName);
        if (this.changeEventDispatcher.hasVetoableChangeListeners(propertyName)) {
            this.changeEventDispatcher.fireVetoableChange(propertyName, oldValue, null);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Will remove prop: " + propertyName + "."));
        }
        this.store.removeProperty(propertyName);
        if (this.changeEventDispatcher.hasPropertyChangeListeners(propertyName)) {
            this.changeEventDispatcher.firePropertyChange(propertyName, oldValue, null);
        }
    }

    @Override
    public Object getProperty(String propertyName) {
        Object result = this.immutableDefaultProperties.get(propertyName);
        if (result != null) {
            return result;
        }
        result = this.store.getProperty(propertyName);
        if (result != null) {
            return result;
        }
        return this.defaultProperties.get(propertyName);
    }

    @Override
    public List<String> getAllPropertyNames() {
        return Collections.unmodifiableList(Arrays.asList(this.store.getPropertyNames()));
    }

    @Override
    public List<String> getPropertyNamesByPrefix(String prefix, boolean exactPrefixMatch) {
        String[] namesArray;
        Set<String> propertyNameSet;
        HashSet<String> resultKeySet = new HashSet<String>();
        if (this.immutableDefaultProperties.size() > 0) {
            propertyNameSet = this.immutableDefaultProperties.keySet();
            namesArray = propertyNameSet.toArray(new String[propertyNameSet.size()]);
            this.getPropertyNamesByPrefix(prefix, exactPrefixMatch, namesArray, resultKeySet);
        }
        this.getPropertyNamesByPrefix(prefix, exactPrefixMatch, this.store.getPropertyNames(), resultKeySet);
        if (this.defaultProperties.size() > 0) {
            propertyNameSet = this.defaultProperties.keySet();
            namesArray = propertyNameSet.toArray(new String[propertyNameSet.size()]);
            this.getPropertyNamesByPrefix(prefix, exactPrefixMatch, namesArray, resultKeySet);
        }
        return new ArrayList<String>(resultKeySet);
    }

    private Set<String> getPropertyNamesByPrefix(String prefix, boolean exactPrefixMatch, String[] names, Set<String> resultSet) {
        for (String key : names) {
            if (exactPrefixMatch) {
                String keyPrefix;
                int ix = key.lastIndexOf(46);
                if (ix == -1 || !prefix.equals(keyPrefix = key.substring(0, ix))) continue;
                resultSet.add(key);
                continue;
            }
            if (!key.startsWith(prefix)) continue;
            resultSet.add(key);
        }
        return resultSet;
    }

    @Override
    public List<String> getPropertyNamesBySuffix(String suffix) {
        LinkedList<String> resultKeySet = new LinkedList<String>();
        for (String key : this.store.getPropertyNames()) {
            int ix = key.lastIndexOf(46);
            if (ix == -1 || !suffix.equals(key.substring(ix + 1))) continue;
            resultKeySet.add(key);
        }
        return resultKeySet;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeEventDispatcher.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeEventDispatcher.removePropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeEventDispatcher.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeEventDispatcher.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public void addVetoableChangeListener(ConfigVetoableChangeListener listener) {
        this.changeEventDispatcher.addVetoableChangeListener(listener);
    }

    @Override
    public void removeVetoableChangeListener(ConfigVetoableChangeListener listener) {
        this.changeEventDispatcher.removeVetoableChangeListener(listener);
    }

    @Override
    public void addVetoableChangeListener(String propertyName, ConfigVetoableChangeListener listener) {
        this.changeEventDispatcher.addVetoableChangeListener(propertyName, listener);
    }

    @Override
    public void removeVetoableChangeListener(String propertyName, ConfigVetoableChangeListener listener) {
        this.changeEventDispatcher.removeVetoableChangeListener(propertyName, listener);
    }

    @Override
    public void reloadConfiguration() throws IOException {
        FileAccessService faService;
        this.configurationFile = null;
        File file = this.getConfigurationFile();
        if (file != null && (faService = this.getFileAccessService()) != null) {
            FailSafeTransaction trans = faService.createFailSafeTransaction(file);
            try {
                trans.restoreFile();
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to restore configuration file " + file), (Throwable)e);
            }
        }
        try {
            this.store.reloadConfiguration(file);
        }
        catch (XMLException xmle) {
            throw new IOException(xmle);
        }
    }

    @Override
    public synchronized void storeConfiguration() throws IOException {
        this.storeConfiguration(this.getConfigurationFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeConfiguration(File file) throws IOException {
        FileAccessService faService;
        String readOnly = System.getProperty("net.java.sip.communicator.CONFIGURATION_FILE_IS_READ_ONLY");
        if (readOnly != null && Boolean.parseBoolean(readOnly)) {
            return;
        }
        FailSafeTransaction trans = null;
        if (file != null && (faService = this.getFileAccessService()) != null) {
            trans = faService.createFailSafeTransaction(file);
        }
        Exception exception = null;
        try {
            if (trans != null) {
                trans.beginTransaction();
            }
            try (FileOutputStream stream = file == null ? null : new FileOutputStream(file);){
                this.store.storeConfiguration(stream);
            }
            if (trans != null) {
                trans.commit();
            }
        }
        catch (IOException | IllegalStateException e) {
            exception = e;
        }
        if (exception != null) {
            this.logger.error((Object)"can't write data in the configuration file", (Throwable)exception);
            if (trans != null) {
                trans.rollback();
            }
        }
    }

    @Override
    public String getConfigurationFilename() {
        try {
            File file = this.getConfigurationFile();
            if (file != null) {
                return file.getName();
            }
        }
        catch (IOException ex) {
            this.logger.error((Object)"Error loading configuration file", (Throwable)ex);
        }
        return null;
    }

    private File getConfigurationFile() throws IOException {
        if (this.configurationFile == null) {
            this.createConfigurationFile();
            this.getScHomeDirLocation();
            this.getScHomeDirName();
        }
        return this.configurationFile;
    }

    private void createConfigurationFile() throws IOException {
        File configurationFile = this.getConfigurationFile("xml", false);
        if (configurationFile == null) {
            this.setConfigurationStore(XMLConfigurationStore.class);
        } else {
            String extension;
            String name = configurationFile.getName();
            int extensionBeginIndex = name.lastIndexOf(46);
            String string = extension = extensionBeginIndex > -1 ? name.substring(extensionBeginIndex) : null;
            if (".properties".equalsIgnoreCase(extension)) {
                this.configurationFile = configurationFile;
                if (!(this.store instanceof PropertyConfigurationStore)) {
                    this.store = new PropertyConfigurationStore();
                }
            } else {
                File newConfigurationFile = new File(configurationFile.getParentFile(), (extensionBeginIndex > -1 ? name.substring(0, extensionBeginIndex) : name) + ".properties");
                if (newConfigurationFile.exists()) {
                    this.configurationFile = newConfigurationFile;
                    if (!(this.store instanceof PropertyConfigurationStore)) {
                        this.store = new PropertyConfigurationStore();
                    }
                } else if (ConfigurationServiceImpl.getSystemProperty("net.java.sip.communicator.CONFIGURATION_FILE_NAME") == null) {
                    Class<? extends ConfigurationStore> defaultConfigurationStoreClass = ConfigurationServiceImpl.getDefaultConfigurationStoreClass();
                    if (configurationFile.exists()) {
                        XMLConfigurationStore xmlStore = new XMLConfigurationStore();
                        try {
                            xmlStore.reloadConfiguration(configurationFile);
                        }
                        catch (XMLException xmlex) {
                            throw new IOException(xmlex);
                        }
                        this.setConfigurationStore(defaultConfigurationStoreClass);
                        if (this.store != null) {
                            ConfigurationServiceImpl.copy(xmlStore, this.store);
                        }
                        Exception exception = null;
                        try {
                            this.storeConfiguration(this.configurationFile);
                        }
                        catch (IOException | IllegalStateException e) {
                            exception = e;
                        }
                        if (exception == null) {
                            configurationFile.delete();
                        } else {
                            this.configurationFile = configurationFile;
                            this.store = xmlStore;
                        }
                    } else {
                        this.setConfigurationStore(defaultConfigurationStoreClass);
                    }
                } else {
                    File file = this.configurationFile = configurationFile.exists() ? configurationFile : this.getConfigurationFile("xml", true);
                    if (!(this.store instanceof XMLConfigurationStore)) {
                        this.store = new XMLConfigurationStore();
                    }
                }
            }
        }
    }

    @Override
    public String getScHomeDirLocation() {
        String scHomeDirLocation = null;
        if (this.store != null) {
            scHomeDirLocation = this.getString("net.java.sip.communicator.SC_HOME_DIR_LOCATION");
        }
        if (scHomeDirLocation == null) {
            scHomeDirLocation = ConfigurationServiceImpl.getSystemProperty("net.java.sip.communicator.SC_HOME_DIR_LOCATION");
            if (scHomeDirLocation == null) {
                scHomeDirLocation = ConfigurationServiceImpl.getSystemProperty("user.home");
            }
            if (this.store != null) {
                this.store.setNonSystemProperty("net.java.sip.communicator.SC_HOME_DIR_LOCATION", scHomeDirLocation);
            }
        }
        return scHomeDirLocation;
    }

    @Override
    public String getScHomeDirName() {
        String scHomeDirName = null;
        if (this.store != null) {
            scHomeDirName = this.getString("net.java.sip.communicator.SC_HOME_DIR_NAME");
        }
        if (scHomeDirName == null) {
            scHomeDirName = ConfigurationServiceImpl.getSystemProperty("net.java.sip.communicator.SC_HOME_DIR_NAME");
            if (scHomeDirName == null) {
                scHomeDirName = ".sip-communicator";
            }
            if (this.store != null) {
                this.store.setNonSystemProperty("net.java.sip.communicator.SC_HOME_DIR_NAME", scHomeDirName);
            }
        }
        return scHomeDirName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getConfigurationFile(String extension, boolean create) throws IOException {
        File configFileInCurrentDir;
        String pFileName = ConfigurationServiceImpl.getSystemProperty("net.java.sip.communicator.CONFIGURATION_FILE_NAME");
        if (pFileName == null) {
            pFileName = "sip-communicator." + extension;
        }
        if ((configFileInCurrentDir = new File(pFileName)).exists()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using config file in current dir: " + configFileInCurrentDir.getAbsolutePath()));
            }
            return configFileInCurrentDir;
        }
        File configDir = new File(this.getScHomeDirLocation() + File.separator + this.getScHomeDirName());
        File configFileInUserHomeDir = new File(configDir, pFileName);
        if (configFileInUserHomeDir.exists()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using config file in $HOME/.sip-communicator: " + configFileInUserHomeDir.getAbsolutePath()));
            }
            return configFileInUserHomeDir;
        }
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(pFileName);
        if (in == null) {
            if (create) {
                configDir.mkdirs();
                configFileInUserHomeDir.createNewFile();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Created an empty file in $HOME: " + configFileInUserHomeDir.getAbsolutePath()));
            }
            return configFileInUserHomeDir;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Copying config file from JAR into " + configFileInUserHomeDir.getAbsolutePath()));
        }
        configDir.mkdirs();
        try {
            ConfigurationServiceImpl.copy(in, configFileInUserHomeDir);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return configFileInUserHomeDir;
    }

    private static Class<? extends ConfigurationStore> getDefaultConfigurationStoreClass() {
        Class defaultConfigurationStoreClass = null;
        if (DEFAULT_CONFIGURATION_STORE_CLASS_NAME != null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(DEFAULT_CONFIGURATION_STORE_CLASS_NAME);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz != null && ConfigurationStore.class.isAssignableFrom(clazz)) {
                defaultConfigurationStoreClass = clazz;
            }
        }
        if (defaultConfigurationStoreClass == null) {
            defaultConfigurationStoreClass = PropertyConfigurationStore.class;
        }
        return defaultConfigurationStoreClass;
    }

    private static void copy(ConfigurationStore src, ConfigurationStore dest) {
        for (String name : src.getPropertyNames()) {
            if (src.isSystemProperty(name)) {
                dest.setSystemProperty(name);
                continue;
            }
            dest.setNonSystemProperty(name, src.getProperty(name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(InputStream inputStream, File outputFile) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
            int bytesRead;
            byte[] bytes = new byte[4096];
            while ((bytesRead = inputStream.read(bytes)) != -1) {
                ((OutputStream)outputStream).write(bytes, 0, bytesRead);
            }
        }
    }

    private static String getSystemProperty(String propertyName) {
        String retval = System.getProperty(propertyName);
        if (retval != null && retval.trim().length() == 0) {
            retval = null;
        }
        return retval;
    }

    @Override
    public String getString(String propertyName) {
        Object propValue = this.getProperty(propertyName);
        if (propValue == null) {
            return null;
        }
        String propStrValue = propValue.toString().trim();
        return propStrValue.length() > 0 ? propStrValue : null;
    }

    @Override
    public String getString(String propertyName, String defaultValue) {
        String value = this.getString(propertyName);
        return value != null ? value : defaultValue;
    }

    @Override
    public boolean getBoolean(String propertyName, boolean defaultValue) {
        String stringValue = this.getString(propertyName);
        return stringValue == null ? defaultValue : Boolean.parseBoolean(stringValue);
    }

    private synchronized FileAccessService getFileAccessService() {
        if (this.faService == null && !this.faServiceIsAssigned) {
            this.faService = LibJitsi.getFileAccessService();
            this.faServiceIsAssigned = true;
        }
        return this.faService;
    }

    @Override
    public int getInt(String propertyName, int defaultValue) {
        String stringValue = this.getString(propertyName);
        int intValue = defaultValue;
        if (stringValue != null && stringValue.length() > 0) {
            try {
                intValue = Integer.parseInt(stringValue);
            }
            catch (NumberFormatException ex) {
                this.logger.error((Object)(propertyName + " does not appear to be an integer. Defaulting to " + defaultValue + "."), (Throwable)ex);
            }
        }
        return intValue;
    }

    @Override
    public double getDouble(String propertyName, double defaultValue) {
        String stringValue = this.getString(propertyName);
        double doubleValue = defaultValue;
        if (stringValue != null && stringValue.length() > 0) {
            try {
                doubleValue = Double.parseDouble(stringValue);
            }
            catch (NumberFormatException ex) {
                this.logger.error((Object)(propertyName + " does not appear to be a double. Defaulting to " + defaultValue + "."), (Throwable)ex);
            }
        }
        return doubleValue;
    }

    @Override
    public long getLong(String propertyName, long defaultValue) {
        String stringValue = this.getString(propertyName);
        long longValue = defaultValue;
        if (stringValue != null && stringValue.length() > 0) {
            try {
                longValue = Long.parseLong(stringValue);
            }
            catch (NumberFormatException ex) {
                this.logger.error((Object)(propertyName + " does not appear to be a long integer. Defaulting to " + defaultValue + "."), (Throwable)ex);
            }
        }
        return longValue;
    }

    private boolean isSystemProperty(String propertyName) {
        return this.store.isSystemProperty(propertyName);
    }

    @Override
    public void purgeStoredConfiguration() {
        if (this.configurationFile != null) {
            this.configurationFile.delete();
            this.configurationFile = null;
        }
        if (this.store != null) {
            for (String name : this.store.getPropertyNames()) {
                this.store.removeProperty(name);
            }
        }
    }

    private void debugPrintSystemProperties() {
        if (!this.logger.isInfoEnabled()) {
            return;
        }
        try {
            Pattern exclusion = null;
            if (PASSWORD_SYS_PROPS != null) {
                exclusion = Pattern.compile(PASSWORD_SYS_PROPS, 2);
            }
            String[] passwordArgs = null;
            if (PASSWORD_CMD_LINE_ARGS != null) {
                passwordArgs = PASSWORD_CMD_LINE_ARGS.split(",");
            }
            for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
                String key = String.valueOf(e.getKey());
                String value = String.valueOf(e.getValue());
                if (exclusion != null && exclusion.matcher(key).find()) {
                    value = "**********";
                }
                if (passwordArgs != null && "sun.java.command".equals(key)) {
                    value = PasswordUtil.replacePasswords(value, passwordArgs);
                }
                this.logger.info((Object)(key + "=" + value));
            }
        }
        catch (RuntimeException e) {
            this.logger.warn((Object)"An exception occurred while writing debug info", (Throwable)e);
        }
    }

    @Override
    public void logConfigurationProperties(String excludePattern) {
        if (!this.logger.isInfoEnabled()) {
            return;
        }
        Pattern exclusion = null;
        if (!StringUtils.isNullOrEmpty((String)excludePattern)) {
            exclusion = Pattern.compile(excludePattern, 2);
        }
        for (String p : this.getAllPropertyNames()) {
            Object v = this.getProperty(p);
            if (v == null) continue;
            if (exclusion != null && exclusion.matcher(p).find()) {
                v = "**********";
            }
            this.logger.info((Object)(p + "=" + v));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preloadSystemPropertyFiles() {
        String propertyFilesListStr = System.getProperty(SYS_PROPS_FILE_NAME_PROPERTY);
        if (propertyFilesListStr == null || propertyFilesListStr.trim().length() == 0) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(propertyFilesListStr, ";,", false);
        while (tokenizer.hasMoreTokens()) {
            String fileName = tokenizer.nextToken();
            try {
                fileName = fileName.trim();
                Properties fileProps = new Properties();
                try (InputStream stream = null;){
                    stream = ClassLoader.getSystemResourceAsStream(fileName);
                    fileProps.load(stream);
                }
                for (Map.Entry<Object, Object> entry : fileProps.entrySet()) {
                    System.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            catch (Exception ex) {
                this.logger.error((Object)("Failed to load property file: " + fileName), (Throwable)ex);
            }
        }
    }

    private void setConfigurationStore(Class<? extends ConfigurationStore> clazz) throws IOException {
        String extension = null;
        if (PropertyConfigurationStore.class.isAssignableFrom(clazz)) {
            extension = "properties";
        } else if (XMLConfigurationStore.class.isAssignableFrom(clazz)) {
            extension = "xml";
        }
        File file = this.configurationFile = extension == null ? null : this.getConfigurationFile(extension, true);
        if (!clazz.isInstance(this.store)) {
            ReflectiveOperationException exception = null;
            try {
                this.store = clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                exception = e;
            }
            if (exception != null) {
                throw new RuntimeException(exception);
            }
        }
    }

    private void loadDefaultProperties() {
        this.loadDefaultProperties(DEFAULT_PROPS_FILE_NAME);
        this.loadDefaultProperties(DEFAULT_OVERRIDES_PROPS_FILE_NAME);
    }

    private boolean isLaunchedByWebStart() {
        boolean hasJNLP;
        try {
            Class.forName("javax.jnlp.ServiceManager");
            hasJNLP = true;
        }
        catch (ClassNotFoundException ex) {
            hasJNLP = false;
        }
        String jwsVersion = System.getProperty("javawebstart.version");
        if (jwsVersion != null && jwsVersion.length() > 0) {
            hasJNLP = true;
        }
        return hasJNLP;
    }

    private void loadDefaultProperties(String fileName) {
        block9: {
            try {
                InputStream fileStream;
                Properties fileProps = new Properties();
                if (OSUtils.IS_ANDROID) {
                    fileStream = this.getClass().getClassLoader().getResourceAsStream(fileName);
                } else if (this.isLaunchedByWebStart()) {
                    this.logger.info((Object)"WebStart classloader");
                    fileStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
                } else {
                    this.logger.info((Object)"Normal classloader");
                    fileStream = ClassLoader.getSystemResourceAsStream(fileName);
                }
                if (fileStream == null) {
                    this.logger.info((Object)("failed to find " + fileName + " with class loader, will continue without it."));
                    return;
                }
                fileProps.load(fileStream);
                fileStream.close();
                for (Map.Entry<Object, Object> entry : fileProps.entrySet()) {
                    String name = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (name == null || value == null || name.trim().length() == 0) continue;
                    if (name.startsWith("*")) {
                        if ((name = name.substring(1)).trim().length() == 0) continue;
                        this.immutableDefaultProperties.put(name, value);
                        this.defaultProperties.remove(name);
                        continue;
                    }
                    this.defaultProperties.put(name, value);
                    this.immutableDefaultProperties.remove(name);
                }
            }
            catch (Exception ex) {
                this.logger.info((Object)("No defaults property file loaded: " + fileName + ". Not a problem."));
                if (!this.logger.isDebugEnabled()) break block9;
                this.logger.debug((Object)"load exception", (Throwable)ex);
            }
        }
    }
}

