/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.video.vp8;

import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.codec.FFmpeg;
import org.jitsi.impl.neomedia.codec.video.AVFrame;
import org.jitsi.impl.neomedia.codec.video.AVFrameFormat;
import org.jitsi.impl.neomedia.codec.video.VPX;
import org.jitsi.utils.logging.Logger;

public class VPXDecoder
extends AbstractCodec2 {
    private static final int INTERFACE = 0;
    private static final Logger logger = Logger.getLogger(VPXDecoder.class);
    private static final VideoFormat[] SUPPORTED_OUTPUT_FORMATS = new VideoFormat[]{new AVFrameFormat(0)};
    private long cfg = 0L;
    private long context = 0L;
    private int height;
    private long img = 0L;
    private long[] iter = new long[1];
    private boolean leftoverFrames = false;
    private int width;

    public VPXDecoder() {
        super("VP8 VPX Decoder", VideoFormat.class, (Format[])SUPPORTED_OUTPUT_FORMATS);
        this.inputFormat = null;
        this.outputFormat = null;
        this.inputFormats = new VideoFormat[]{new VideoFormat("VP8")};
    }

    @Override
    protected void doClose() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Closing decoder");
        }
        if (this.context != 0L) {
            VPX.codec_destroy(this.context);
            VPX.free(this.context);
        }
        if (this.cfg != 0L) {
            VPX.free(this.cfg);
        }
    }

    @Override
    protected void doOpen() throws ResourceUnavailableException {
        this.context = VPX.codec_ctx_malloc();
        long flags = 0L;
        int ret = VPX.codec_dec_init(this.context, 0, 0L, flags);
        if (ret != 0) {
            throw new RuntimeException("Failed to initialize decoder, libvpx error:\n" + VPX.codec_err_to_string(ret));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"VP8 decoder opened succesfully");
        }
    }

    @Override
    protected int doProcess(Buffer inputBuffer, Buffer outputBuffer) {
        if (this.leftoverFrames) {
            this.updateOutputFormat(VPX.img_get_d_w(this.img), VPX.img_get_d_h(this.img), ((VideoFormat)inputBuffer.getFormat()).getFrameRate());
            outputBuffer.setFormat(this.outputFormat);
            AVFrame avframe = this.makeAVFrame(this.img);
            outputBuffer.setData((Object)avframe);
            outputBuffer.setLength(this.width * this.height * 3 / 2);
            outputBuffer.setTimeStamp(inputBuffer.getTimeStamp());
        } else {
            int buf_size;
            int buf_offset;
            byte[] buf = (byte[])inputBuffer.getData();
            int ret = VPX.codec_decode(this.context, buf, buf_offset = inputBuffer.getOffset(), buf_size = inputBuffer.getLength(), 0L, 0L);
            if (ret != 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Discarding a frame, codec_decode() error: " + VPX.codec_err_to_string(ret)));
                }
                outputBuffer.setDiscard(true);
                return 0;
            }
            this.leftoverFrames = false;
            this.iter[0] = 0L;
            this.img = VPX.codec_get_frame(this.context, this.iter);
            if (this.img == 0L) {
                outputBuffer.setDiscard(true);
                return 0;
            }
            this.updateOutputFormat(VPX.img_get_d_w(this.img), VPX.img_get_d_h(this.img), ((VideoFormat)inputBuffer.getFormat()).getFrameRate());
            outputBuffer.setFormat(this.outputFormat);
            AVFrame avframe = this.makeAVFrame(this.img);
            outputBuffer.setData((Object)avframe);
            outputBuffer.setLength(this.width * this.height * 3 / 2);
            outputBuffer.setTimeStamp(inputBuffer.getTimeStamp());
        }
        this.img = VPX.codec_get_frame(this.context, this.iter);
        if (this.img == 0L) {
            this.leftoverFrames = false;
            return 0;
        }
        this.leftoverFrames = true;
        return 2;
    }

    @Override
    protected Format[] getMatchingOutputFormats(Format inputFormat) {
        VideoFormat inputVideoFormat = (VideoFormat)inputFormat;
        return new Format[]{new AVFrameFormat(inputVideoFormat.getSize(), inputVideoFormat.getFrameRate(), 0)};
    }

    private AVFrame makeAVFrame(long img) {
        AVFrame avframe = new AVFrame();
        long p0 = VPX.img_get_plane0(img);
        long p1 = VPX.img_get_plane1(img);
        long p2 = VPX.img_get_plane2(img);
        FFmpeg.avframe_set_data((long)avframe.getPtr(), (long)p0, (long)(p1 - p0), (long)(p2 - p1));
        FFmpeg.avframe_set_linesize((long)avframe.getPtr(), (int)VPX.img_get_stride0(img), (int)VPX.img_get_stride1(img), (int)VPX.img_get_stride2(img));
        return avframe;
    }

    @Override
    public Format setInputFormat(Format format) {
        Format setFormat = super.setInputFormat(format);
        if (setFormat != null) {
            this.reset();
        }
        return setFormat;
    }

    private void updateOutputFormat(int width, int height, float frameRate) {
        if (width > 0 && height > 0 && (this.width != width || this.height != height)) {
            this.width = width;
            this.height = height;
            this.outputFormat = new AVFrameFormat(new Dimension(width, height), frameRate, 0);
        }
    }
}

