/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import org.jitsi.util.JNIUtils;
import org.jitsi.util.OSUtils;
import org.jitsi.utils.StringUtils;
import org.jitsi.utils.logging.Logger;

public class CoreAudioDevice {
    private static final Logger logger = Logger.getLogger(CoreAudioDevice.class);
    public static boolean isLoaded;
    private static Runnable devicesChangedCallback;

    public static native void freeDevices();

    public static String getDeviceModelIdentifier(String deviceUID) {
        if (deviceUID == null) {
            throw new NullPointerException("deviceUID");
        }
        byte[] deviceModelIdentifierBytes = CoreAudioDevice.getDeviceModelIdentifierBytes(deviceUID);
        String deviceModelIdentifier = StringUtils.newString((byte[])deviceModelIdentifierBytes);
        return deviceModelIdentifier;
    }

    public static native byte[] getDeviceModelIdentifierBytes(String var0);

    public static String getDeviceName(String deviceUID) {
        byte[] deviceNameBytes = CoreAudioDevice.getDeviceNameBytes(deviceUID);
        String deviceName = StringUtils.newString((byte[])deviceNameBytes);
        return deviceName;
    }

    public static native byte[] getDeviceNameBytes(String var0);

    public static native float getInputDeviceVolume(String var0);

    public static native float getOutputDeviceVolume(String var0);

    public static native int initDevices();

    public static native int setInputDeviceVolume(String var0, float var1);

    public static native int setOutputDeviceVolume(String var0, float var1);

    public static void devicesChangedCallback() {
        Runnable devicesChangedCallback = CoreAudioDevice.devicesChangedCallback;
        if (devicesChangedCallback != null) {
            devicesChangedCallback.run();
        }
    }

    public static void setDevicesChangedCallback(Runnable devicesChangedCallback) {
        CoreAudioDevice.devicesChangedCallback = devicesChangedCallback;
    }

    public static void log(byte[] error) {
        String errorString = StringUtils.newString((byte[])error);
        logger.info((Object)errorString);
    }

    static {
        boolean isLoaded = false;
        try {
            String libname = null;
            if (OSUtils.IS_MAC) {
                libname = "jnmaccoreaudio";
            } else if (OSUtils.IS_WINDOWS) {
                libname = "jnwincoreaudio";
            }
            if (libname != null) {
                JNIUtils.loadLibrary(libname, CoreAudioDevice.class.getClassLoader());
                isLoaded = true;
            }
        }
        catch (NullPointerException npe) {
            logger.info((Object)"Failed to load CoreAudioDevice library: ", (Throwable)npe);
        }
        catch (SecurityException se) {
            logger.info((Object)"Failed to load CoreAudioDevice library: ", (Throwable)se);
        }
        catch (UnsatisfiedLinkError ule) {
            logger.info((Object)"Failed to load CoreAudioDevice library: ", (Throwable)ule);
        }
        CoreAudioDevice.isLoaded = isLoaded;
    }
}

