/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import java.io.Closeable;
import java.net.DatagramPacket;
import org.jitsi.impl.neomedia.RTPConnectorInputStream;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.service.neomedia.RawPacket;

public abstract class TransformInputStream<T extends Closeable>
extends RTPConnectorInputStream<T> {
    private PacketTransformer transformer;

    protected TransformInputStream(T socket) {
        super(socket);
    }

    @Override
    protected RawPacket[] createRawPacket(DatagramPacket datagramPacket) {
        RawPacket[] pkts = super.createRawPacket(datagramPacket);
        for (int i = 0; i < pkts.length; ++i) {
            RawPacket pkt = pkts[i];
            if (pkt == null || !pkt.isInvalid()) continue;
            pkts[i] = null;
        }
        PacketTransformer transformer = this.getTransformer();
        return transformer == null ? pkts : transformer.reverseTransform(pkts);
    }

    public PacketTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(PacketTransformer transformer) {
        this.transformer = transformer;
    }
}

