/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.fec;

import java.util.BitSet;

public class FlexFec03BitSet {
    private BitSet bitSet;
    private int numBits = 0;

    public FlexFec03BitSet(int numBits) {
        this.bitSet = new BitSet(numBits);
        this.numBits = numBits;
    }

    public void set(int bitIndex) {
        this.bitSet.set(bitIndex);
    }

    public boolean get(int bitIndex) {
        return this.bitSet.get(bitIndex);
    }

    public void clear(int bitIndex) {
        this.bitSet.clear(bitIndex);
    }

    public void addBit(int bitIndex, boolean bitValue) {
        int newNumBits = this.numBits + 1;
        BitSet newBitSet = new BitSet(newNumBits);
        for (int i = 0; i < this.numBits; ++i) {
            if (i < bitIndex) {
                newBitSet.set(i, this.bitSet.get(i));
                continue;
            }
            newBitSet.set(i + 1, this.bitSet.get(i));
        }
        newBitSet.set(bitIndex, bitValue);
        this.bitSet = newBitSet;
        this.numBits = newNumBits;
    }

    public void removeBit(int bitIndex) {
        int newNumBits = this.numBits - 1;
        BitSet newBitSet = new BitSet(newNumBits);
        for (int i = 0; i < this.numBits; ++i) {
            if (i < bitIndex) {
                newBitSet.set(i, this.bitSet.get(i));
                continue;
            }
            if (i <= bitIndex) continue;
            newBitSet.set(i - 1, this.bitSet.get(i));
        }
        this.bitSet = newBitSet;
        this.numBits = newNumBits;
    }

    public static FlexFec03BitSet valueOf(byte[] bytes) {
        return FlexFec03BitSet.valueOf(bytes, 0, bytes.length);
    }

    public static FlexFec03BitSet valueOf(byte[] bytes, int offset, int length) {
        int numBits = length * 8;
        FlexFec03BitSet b = new FlexFec03BitSet(numBits);
        for (int currBytePos = 0; currBytePos < length; ++currBytePos) {
            byte currByte = bytes[offset + currBytePos];
            for (int currBitPos = 0; currBitPos < 8; ++currBitPos) {
                int absoluteBitPos = currBytePos * 8 + currBitPos;
                if ((currByte & 128 >> currBitPos) <= 0) continue;
                b.set(absoluteBitPos);
            }
        }
        return b;
    }

    public int sizeBytes() {
        int numBytes = this.numBits / 8;
        if (this.numBits % 8 != 0) {
            ++numBytes;
        }
        return numBytes;
    }

    public int sizeBits() {
        return this.numBits;
    }

    public byte[] toByteArray() {
        byte[] bytes = new byte[this.sizeBytes()];
        for (int currBitPos = 0; currBitPos < this.numBits; ++currBitPos) {
            int bytePos = currBitPos / 8;
            int relativeBitPos = currBitPos % 8;
            if (!this.get(currBitPos)) continue;
            int n = bytePos;
            bytes[n] = (byte)(bytes[n] | 128 >> relativeBitPos);
        }
        return bytes;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        int numSpaces = Integer.toString(this.numBits).length() + 1;
        for (i = 0; i < this.numBits; ++i) {
            sb.append(String.format("%-" + numSpaces + "s", i));
        }
        sb.append("\n");
        for (i = 0; i < this.numBits; ++i) {
            if (this.get(i)) {
                sb.append(String.format("%-" + numSpaces + "s", "1"));
                continue;
            }
            sb.append(String.format("%-" + numSpaces + "s", "0"));
        }
        return sb.toString();
    }
}

