/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.fec;

import java.util.ArrayList;
import java.util.List;
import org.jitsi.impl.neomedia.transform.fec.FlexFec03BitSet;
import org.jitsi.util.RTPUtils;

public class FlexFec03Mask {
    private static final int MASK_0_K_BIT = 0;
    private static final int MASK_1_K_BIT = 16;
    private static final int MASK_2_K_BIT = 48;
    private static final int MASK_SIZE_SMALL = 2;
    private static final int MASK_SIZE_MED = 6;
    private static final int MASK_SIZE_LARGE = 14;
    private int sizeBytes;
    private FlexFec03BitSet maskWithKBits;
    private int baseSeqNum;

    private static int getNumBitsExcludingKBits(int maskSizeBytes) {
        int numBits = maskSizeBytes * 8;
        if (maskSizeBytes > 6) {
            return numBits - 3;
        }
        if (maskSizeBytes > 2) {
            return numBits - 2;
        }
        return numBits - 1;
    }

    private static FlexFec03BitSet createMaskWithKBits(int sizeBytes, int baseSeqNum, List<Integer> protectedSeqNums) {
        int numBits = FlexFec03Mask.getNumBitsExcludingKBits(sizeBytes);
        FlexFec03BitSet mask = new FlexFec03BitSet(numBits);
        for (Integer protectedSeqNum : protectedSeqNums) {
            int delta = RTPUtils.getSequenceNumberDelta(protectedSeqNum, baseSeqNum);
            mask.set(delta);
        }
        if (sizeBytes > 6) {
            mask.addBit(0, false);
            mask.addBit(16, false);
            mask.addBit(48, true);
        } else if (sizeBytes > 2) {
            mask.addBit(0, false);
            mask.addBit(16, true);
        } else {
            mask.addBit(0, true);
        }
        return mask;
    }

    private static int getMaskSizeInBytes(byte[] buffer, int maskOffset) throws MalformedMaskException {
        if (buffer.length - maskOffset < 2) {
            throw new MalformedMaskException();
        }
        int maskSizeBytes = 2;
        int kbit0 = (buffer[maskOffset] & 0x80) >> 7;
        if (kbit0 == 0) {
            maskSizeBytes = 6;
            if (buffer.length - maskOffset < 6) {
                throw new MalformedMaskException();
            }
            int kbit1 = (buffer[maskOffset + 2] & 0x80) >> 7;
            if (kbit1 == 0) {
                if (buffer.length - maskOffset < 14) {
                    throw new MalformedMaskException();
                }
                maskSizeBytes = 14;
            }
        }
        return maskSizeBytes;
    }

    private static int getMaskSizeInBytes(int baseSeqNum, List<Integer> sortedProtectedSeqNums) throws MalformedMaskException {
        int largestDelta = -1;
        for (Integer protectedSeqNum : sortedProtectedSeqNums) {
            int delta = RTPUtils.getSequenceNumberDelta(protectedSeqNum, baseSeqNum);
            if (delta <= largestDelta) continue;
            largestDelta = delta;
        }
        if (largestDelta > 108) {
            throw new MalformedMaskException();
        }
        if (largestDelta <= 14) {
            return 2;
        }
        if (largestDelta <= 45) {
            return 6;
        }
        return 14;
    }

    private static FlexFec03BitSet getMaskWithoutKBits(FlexFec03BitSet maskWithKBits) {
        FlexFec03BitSet maskWithoutKBits = FlexFec03BitSet.valueOf(maskWithKBits.toByteArray());
        int maskSizeBytes = maskWithKBits.sizeBytes();
        if (maskSizeBytes > 6) {
            maskWithoutKBits.removeBit(48);
        }
        if (maskSizeBytes > 2) {
            maskWithoutKBits.removeBit(16);
        }
        maskWithoutKBits.removeBit(0);
        return maskWithoutKBits;
    }

    FlexFec03Mask(byte[] buffer, int maskOffset, int baseSeqNum) throws MalformedMaskException {
        this.sizeBytes = FlexFec03Mask.getMaskSizeInBytes(buffer, maskOffset);
        this.maskWithKBits = FlexFec03BitSet.valueOf(buffer, maskOffset, this.sizeBytes);
        this.baseSeqNum = baseSeqNum;
    }

    public FlexFec03Mask(int baseSeqNum, List<Integer> protectedSeqNums) throws MalformedMaskException {
        this.sizeBytes = FlexFec03Mask.getMaskSizeInBytes(baseSeqNum, protectedSeqNums);
        this.baseSeqNum = baseSeqNum;
        this.maskWithKBits = FlexFec03Mask.createMaskWithKBits(this.sizeBytes, this.baseSeqNum, protectedSeqNums);
    }

    public FlexFec03BitSet getMaskWithKBits() {
        return this.maskWithKBits;
    }

    public int lengthBytes() {
        return this.sizeBytes;
    }

    public List<Integer> getProtectedSeqNums() {
        FlexFec03BitSet maskWithoutKBits = FlexFec03Mask.getMaskWithoutKBits(this.maskWithKBits);
        ArrayList<Integer> protectedSeqNums = new ArrayList<Integer>();
        for (int i = 0; i < maskWithoutKBits.sizeBits(); ++i) {
            if (!maskWithoutKBits.get(i)) continue;
            protectedSeqNums.add(RTPUtils.applySequenceNumberDelta(this.baseSeqNum, i));
        }
        return protectedSeqNums;
    }

    public static class MalformedMaskException
    extends Exception {
    }
}

