/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.srtp;

import org.jitsi.impl.neomedia.transform.srtp.OpenSSLWrapperLoader;
import org.jitsi.impl.neomedia.transform.srtp.SRTPCipherCTR;
import org.jitsi.utils.logging.Logger;

public class SRTPCipherCTROpenSSL
extends SRTPCipherCTR {
    private static final Logger logger = Logger.getLogger(SRTPCipherCTROpenSSL.class);
    private long ctx;

    private static native long AES128CTR_CTX_create();

    private static native void AES128CTR_CTX_destroy(long var0);

    private static native boolean AES128CTR_CTX_init(long var0, byte[] var2);

    private static native boolean AES128CTR_CTX_process(long var0, byte[] var2, byte[] var3, int var4, int var5);

    public SRTPCipherCTROpenSSL() {
        if (!OpenSSLWrapperLoader.isLoaded()) {
            throw new RuntimeException("OpenSSL wrapper not loaded");
        }
        this.ctx = SRTPCipherCTROpenSSL.AES128CTR_CTX_create();
        if (this.ctx == 0L) {
            throw new RuntimeException("CIPHER_CTX_create");
        }
    }

    @Override
    public void init(byte[] key) {
        if (key.length != 16) {
            throw new IllegalArgumentException("key.length != BLKLEN");
        }
        if (!SRTPCipherCTROpenSSL.AES128CTR_CTX_init(this.ctx, key)) {
            throw new RuntimeException("AES128CTR_CTX_init");
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.ctx != 0L) {
                SRTPCipherCTROpenSSL.AES128CTR_CTX_destroy(this.ctx);
                this.ctx = 0L;
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void process(byte[] data, int off, int len, byte[] iv) {
        SRTPCipherCTROpenSSL.checkProcessArgs(data, off, len, iv);
        if (!SRTPCipherCTROpenSSL.AES128CTR_CTX_process(this.ctx, iv, data, off, len)) {
            throw new RuntimeException("AES128CTR_CTX_process");
        }
    }
}

