/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sm.packet;

import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.packet.StanzaErrorTextElement;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class StreamManagement {
    public static final String NAMESPACE = "urn:xmpp:sm:3";

    public static final class AckRequest
    implements Nonza {
        public static final String ELEMENT = "r";
        public static final AckRequest INSTANCE = new AckRequest();

        private AckRequest() {
        }

        public CharSequence toXML() {
            return "<r xmlns='urn:xmpp:sm:3'/>";
        }

        public String getNamespace() {
            return StreamManagement.NAMESPACE;
        }

        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class AckAnswer
    implements Nonza {
        public static final String ELEMENT = "a";
        private final long handledCount;

        public AckAnswer(long handledCount) {
            this.handledCount = handledCount;
        }

        public long getHandledCount() {
            return this.handledCount;
        }

        public CharSequence toXML() {
            XmlStringBuilder xml = new XmlStringBuilder((ExtensionElement)this);
            xml.attribute("h", Long.toString(this.handledCount));
            xml.closeEmptyElement();
            return xml;
        }

        public String getNamespace() {
            return StreamManagement.NAMESPACE;
        }

        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class Resumed
    extends AbstractResume {
        public static final String ELEMENT = "resumed";

        public Resumed(long handledCount, String previd) {
            super(handledCount, previd);
        }

        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class Resume
    extends AbstractResume {
        public static final String ELEMENT = "resume";

        public Resume(long handledCount, String previd) {
            super(handledCount, previd);
        }

        public String getElementName() {
            return ELEMENT;
        }
    }

    private static abstract class AbstractResume
    implements Nonza {
        private final long handledCount;
        private final String previd;

        public AbstractResume(long handledCount, String previd) {
            this.handledCount = handledCount;
            this.previd = previd;
        }

        public long getHandledCount() {
            return this.handledCount;
        }

        public String getPrevId() {
            return this.previd;
        }

        public final String getNamespace() {
            return StreamManagement.NAMESPACE;
        }

        public final XmlStringBuilder toXML() {
            XmlStringBuilder xml = new XmlStringBuilder((ExtensionElement)this);
            xml.attribute("h", Long.toString(this.handledCount));
            xml.attribute("previd", this.previd);
            xml.closeEmptyElement();
            return xml;
        }
    }

    public static class Failed
    implements Nonza {
        public static final String ELEMENT = "failed";
        private final XMPPError.Condition condition;
        private final List<StanzaErrorTextElement> textElements;

        public Failed() {
            this(null, null);
        }

        public Failed(XMPPError.Condition condition, List<StanzaErrorTextElement> textElements) {
            this.condition = condition;
            this.textElements = textElements == null ? Collections.emptyList() : Collections.unmodifiableList(textElements);
        }

        public XMPPError.Condition getXMPPErrorCondition() {
            return this.condition;
        }

        public List<StanzaErrorTextElement> getTextElements() {
            return this.textElements;
        }

        public CharSequence toXML() {
            XmlStringBuilder xml = new XmlStringBuilder((ExtensionElement)this);
            if (this.condition == null && this.textElements.isEmpty()) {
                xml.closeEmptyElement();
            } else {
                xml.rightAngleBracket();
                if (this.condition != null) {
                    xml.append((CharSequence)this.condition.toString());
                    xml.xmlnsAttribute("urn:ietf:params:xml:ns:xmpp-stanzas");
                }
                xml.append(this.textElements);
                xml.closeElement(ELEMENT);
            }
            return xml;
        }

        public String getNamespace() {
            return StreamManagement.NAMESPACE;
        }

        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class Enabled
    extends AbstractEnable {
        public static final String ELEMENT = "enabled";
        private final String id;
        private final String location;

        public Enabled(String id, boolean resume) {
            this(id, resume, null, -1);
        }

        public Enabled(String id, boolean resume, String location, int max) {
            this.id = id;
            this.resume = resume;
            this.location = location;
            this.max = max;
        }

        public String getId() {
            return this.id;
        }

        public String getLocation() {
            return this.location;
        }

        public CharSequence toXML() {
            XmlStringBuilder xml = new XmlStringBuilder((ExtensionElement)this);
            xml.optAttribute("id", this.id);
            this.maybeAddResumeAttributeTo(xml);
            xml.optAttribute("location", this.location);
            this.maybeAddMaxAttributeTo(xml);
            xml.closeEmptyElement();
            return xml;
        }

        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class Enable
    extends AbstractEnable {
        public static final String ELEMENT = "enable";
        public static final Enable INSTANCE = new Enable();

        private Enable() {
        }

        public Enable(boolean resume) {
            this.resume = resume;
        }

        public Enable(boolean resume, int max) {
            this(resume);
            this.max = max;
        }

        public CharSequence toXML() {
            XmlStringBuilder xml = new XmlStringBuilder((ExtensionElement)this);
            this.maybeAddResumeAttributeTo(xml);
            this.maybeAddMaxAttributeTo(xml);
            xml.closeEmptyElement();
            return xml;
        }

        public String getElementName() {
            return ELEMENT;
        }
    }

    private static abstract class AbstractEnable
    implements Nonza {
        protected int max = -1;
        protected boolean resume = false;

        private AbstractEnable() {
        }

        protected void maybeAddResumeAttributeTo(XmlStringBuilder xml) {
            if (this.resume) {
                xml.attribute("resume", "true");
            }
        }

        protected void maybeAddMaxAttributeTo(XmlStringBuilder xml) {
            if (this.max > 0) {
                xml.attribute("max", Integer.toString(this.max));
            }
        }

        public boolean isResumeSet() {
            return this.resume;
        }

        public int getMaxResumptionTime() {
            return this.max;
        }

        public final String getNamespace() {
            return StreamManagement.NAMESPACE;
        }
    }

    public static final class StreamManagementFeature
    implements ExtensionElement {
        public static final String ELEMENT = "sm";
        public static final StreamManagementFeature INSTANCE = new StreamManagementFeature();

        private StreamManagementFeature() {
        }

        public String getElementName() {
            return ELEMENT;
        }

        public String getNamespace() {
            return StreamManagement.NAMESPACE;
        }

        public CharSequence toXML() {
            XmlStringBuilder xml = new XmlStringBuilder((ExtensionElement)this);
            xml.closeEmptyElement();
            return xml;
        }
    }
}

