/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.linker;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.linker.Linker;
import org.codehaus.mojo.natives.linker.LinkerConfiguration;
import org.codehaus.mojo.natives.util.CommandLineUtil;
import org.codehaus.mojo.natives.util.EnvUtil;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.cli.Commandline;

public abstract class AbstractLinker
extends AbstractLogEnabled
implements Linker {
    protected abstract Commandline createLinkerCommandLine(List<File> var1, LinkerConfiguration var2) throws NativeBuildException;

    @Override
    public File link(LinkerConfiguration config, List<File> compilerOutputFiles) throws NativeBuildException, IOException {
        if (this.isStaled(config, compilerOutputFiles)) {
            Commandline cl = this.createLinkerCommandLine(compilerOutputFiles, config);
            EnvUtil.setupCommandlineEnv(cl, config.getEnvFactory());
            CommandLineUtil.execute(cl, this.getLogger());
        }
        return config.getOutputFile();
    }

    private boolean isStaled(LinkerConfiguration config, List<File> compilerOutputFiles) {
        if (!config.isCheckStaleLinkage()) {
            return true;
        }
        File previousDestination = config.getOutputFile();
        if (!previousDestination.exists()) {
            return true;
        }
        if (previousDestination.exists()) {
            int i;
            for (i = 0; i < compilerOutputFiles.size(); ++i) {
                if (previousDestination.lastModified() >= compilerOutputFiles.get(i).lastModified()) continue;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Stale relative to compilerOutputFiles: " + compilerOutputFiles.get(i).getAbsolutePath());
                }
                return true;
            }
            for (i = 0; i < config.getExternalLibFileNames().size(); ++i) {
                File extLib = new File(config.getExternalLibDirectory(), config.getExternalLibFileNames().get(i));
                if (previousDestination.lastModified() >= extLib.lastModified()) continue;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Stale relative to extLib: " + extLib.getAbsolutePath());
                }
                return true;
            }
        }
        return false;
    }
}

