/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi_modified.sctp4j;

import cz.adamh.utils.NativeUtils;
import org.jitsi_modified.sctp4j.IncomingSctpDataHandler;
import org.jitsi_modified.sctp4j.OutgoingSctpDataHandler;

public class SctpJni {
    public static IncomingSctpDataHandler incomingSctpDataHandler;
    public static OutgoingSctpDataHandler outgoingSctpDataHandler;

    public static native void on_network_in(long var0, byte[] var2, int var3, int var4);

    public static native boolean usrsctp_accept(long var0);

    public static native void usrsctp_close(long var0);

    public static native boolean usrsctp_connect(long var0, int var2);

    public static native boolean usrsctp_finish();

    public static native boolean usrsctp_init(int var0);

    public static native void usrsctp_listen(long var0);

    public static native int usrsctp_send(long var0, byte[] var2, int var3, int var4, boolean var5, int var6, int var7);

    public static native long usrsctp_socket(int var0, long var1);

    public static void onSctpInboundPacket(long socketAddr, byte[] data, int sid, int ssn, int tsn, long ppid, int context, int flags) {
        if (incomingSctpDataHandler != null) {
            incomingSctpDataHandler.apply(socketAddr, data, sid, ssn, tsn, ppid, context, flags);
        }
    }

    public static int onSctpOutboundPacket(long socketAddr, byte[] data, int tos, int set_df) {
        if (outgoingSctpDataHandler != null) {
            outgoingSctpDataHandler.apply(socketAddr, data, tos, set_df);
            return 0;
        }
        return -1;
    }

    static {
        try {
            String os = System.getProperty("os.name");
            String arch = System.getProperty("os.arch");
            if (os.toLowerCase().contains("mac")) {
                System.out.println("SCTP JNI load: Mac OS detected");
                NativeUtils.loadLibraryFromJar("/lib/darwin/libjnisctp.jnilib");
            } else if (os.toLowerCase().contains("linux")) {
                System.out.println("SCTP JNI load: Linux OS detected");
                NativeUtils.loadLibraryFromJar("/lib/linux-" + arch + "/libjnisctp.so");
            } else if (os.toLowerCase().contains("freebsd")) {
                System.out.println("SCTP JNI load: FreeBSD OS detected");
                NativeUtils.loadLibraryFromJar("/lib/freebsd-" + arch + "/libjnisctp.so");
            } else {
                throw new Exception("Unsupported OS: " + os);
            }
            System.out.println("SCTP lib loaded");
        }
        catch (Exception e) {
            System.out.println("Error loading native library: " + e);
        }
        incomingSctpDataHandler = null;
        outgoingSctpDataHandler = null;
    }
}

