/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.cipher;

import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.TLSRecord;
import io.ktor.network.tls.cipher.CipherUtilsKt;
import io.ktor.network.tls.cipher.GCMCipherKt;
import io.ktor.network.tls.cipher.TLSCipher;
import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.Input;
import io.ktor.utils.io.core.InputPrimitivesKt;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.OutputPrimitivesKt;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/ktor/network/tls/cipher/GCMCipher;", "Lio/ktor/network/tls/cipher/TLSCipher;", "suite", "Lio/ktor/network/tls/CipherSuite;", "keyMaterial", "", "(Lio/ktor/network/tls/CipherSuite;[B)V", "inputCounter", "", "outputCounter", "decrypt", "Lio/ktor/network/tls/TLSRecord;", "record", "encrypt", "ktor-network-tls"})
public final class GCMCipher
implements TLSCipher {
    @NotNull
    private final CipherSuite suite;
    @NotNull
    private final byte[] keyMaterial;
    private long inputCounter;
    private long outputCounter;

    public GCMCipher(@NotNull CipherSuite suite, @NotNull byte[] keyMaterial2) {
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        Intrinsics.checkNotNullParameter((Object)keyMaterial2, (String)"keyMaterial");
        this.suite = suite;
        this.keyMaterial = keyMaterial2;
    }

    @Override
    @NotNull
    public TLSRecord encrypt(@NotNull TLSRecord record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Cipher cipher2 = GCMCipherKt.access$gcmEncryptCipher(this.suite, this.keyMaterial, record.getType(), (int)record.getPacket().getRemaining(), this.outputCounter, this.outputCounter);
        long packetId = this.outputCounter;
        ByteReadPacket packet2 = CipherUtilsKt.cipherLoop(record.getPacket(), cipher2, (Function1<? super BytePacketBuilder, Unit>)((Function1)new Function1<BytePacketBuilder, Unit>(packetId){
            final /* synthetic */ long $packetId;
            {
                this.$packetId = $packetId;
                super(1);
            }

            public final void invoke(@NotNull BytePacketBuilder $this$cipherLoop) {
                Intrinsics.checkNotNullParameter((Object)$this$cipherLoop, (String)"$this$cipherLoop");
                OutputPrimitivesKt.writeLong((Output)((Output)$this$cipherLoop), (long)this.$packetId);
            }
        }));
        long l = this.outputCounter;
        this.outputCounter = l + 1L;
        return new TLSRecord(record.getType(), null, packet2, 2, null);
    }

    @Override
    @NotNull
    public TLSRecord decrypt(@NotNull TLSRecord record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        ByteReadPacket packet2 = record.getPacket();
        long packetSize = packet2.getRemaining();
        long recordIv = InputPrimitivesKt.readLong((Input)((Input)packet2));
        long l = this.inputCounter;
        this.inputCounter = l + 1L;
        Cipher cipher2 = GCMCipherKt.access$gcmDecryptCipher(this.suite, this.keyMaterial, record.getType(), (int)packetSize, recordIv, l);
        return new TLSRecord(record.getType(), record.getVersion(), CipherUtilsKt.cipherLoop$default(packet2, cipher2, null, 2, null));
    }
}

