/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.frame;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.protocol.Protocol;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;

public final class PcapGlobalHeader {
    public static final int SIZE = 24;
    public static final byte[] MAGIC_BIG_ENDIAN = new byte[]{-95, -78, -61, -44};
    public static final byte[] MAGIC_LITTLE_ENDIAN = new byte[]{-44, -61, -78, -95};
    public static final byte[] MAGIC_NGPCAP = new byte[]{10, 13, 13, 10};
    public static final byte[] MAGIC_NSEC = new byte[]{-95, -78, 60, 77};
    public static final byte[] MAGIC_NSEC_SWAPPED = new byte[]{77, 60, -78, -94};
    public static final byte[] MAGIC_MODIFIED = new byte[]{-95, -78, -51, 52};
    public static final byte[] MAGIC_MODIFIED_SWAPPED = new byte[]{52, -51, -78, -95};
    private final ByteOrder byteOrder;
    private final byte[] body;

    public static PcapGlobalHeader createDefaultHeader() {
        return PcapGlobalHeader.createDefaultHeader(Protocol.ETHERNET_II);
    }

    public static PcapGlobalHeader createDefaultHeader(Protocol protocol) {
        Long linkType;
        Buffer body = Buffers.createBuffer((int)20);
        body.setUnsignedByte(0, (short)2);
        body.setUnsignedByte(2, (short)4);
        body.setUnsignedInt(4, 0L);
        body.setUnsignedInt(8, 0L);
        body.setUnsignedInt(12, 65535L);
        if (protocol == null) {
            protocol = Protocol.ETHERNET_II;
        }
        if ((linkType = protocol.getLinkType()) == null) {
            throw new IllegalArgumentException("Unknown protocol \"" + (Object)((Object)protocol) + "\". Not sure how to construct the global header. You probably need to add some code yourself");
        }
        body.setUnsignedInt(16, linkType.longValue());
        return new PcapGlobalHeader(ByteOrder.LITTLE_ENDIAN, body.getRawArray());
    }

    public PcapGlobalHeader(ByteOrder byteOrder, byte[] body) {
        assert (byteOrder != null);
        assert (body != null && body.length == 20);
        this.byteOrder = byteOrder;
        this.body = body;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public int getMajorVersion() {
        return PcapGlobalHeader.getUnsignedShort(0, this.body, this.byteOrder);
    }

    public int getMinorVersion() {
        return PcapGlobalHeader.getUnsignedShort(2, this.body, this.byteOrder);
    }

    public int getTimeAccuracy() {
        return PcapGlobalHeader.getInt(8, this.body, this.byteOrder);
    }

    public long getTimeZoneCorrection() {
        return PcapGlobalHeader.getUnsignedInt(4, this.body, this.byteOrder);
    }

    public long getSnapLength() {
        return PcapGlobalHeader.getUnsignedInt(12, this.body, this.byteOrder);
    }

    public int getDataLinkType() {
        return PcapGlobalHeader.getInt(16, this.body, this.byteOrder);
    }

    public static final int getUnsignedShort(int offset, byte[] buffer, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            return (buffer[offset + 0] & 0xFF) << 8 | buffer[offset + 1] & 0xFF;
        }
        return (buffer[offset + 1] & 0xFF) << 8 | buffer[offset + 0] & 0xFF;
    }

    public static final long getUnsignedInt(int offset, byte[] buffer, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            return (buffer[offset + 0] & 0xFF) << 24 | (buffer[offset + 1] & 0xFF) << 16 | (buffer[offset + 2] & 0xFF) << 8 | buffer[offset + 3] & 0xFF;
        }
        return (buffer[offset + 3] & 0xFF) << 24 | (buffer[offset + 2] & 0xFF) << 16 | (buffer[offset + 1] & 0xFF) << 8 | buffer[offset + 0] & 0xFF;
    }

    public static final int getInt(int offset, byte[] buffer, ByteOrder byteOrder) {
        return (int)PcapGlobalHeader.getUnsignedInt(offset, buffer, byteOrder);
    }

    public static final PcapGlobalHeader parse(Buffer in) throws IOException {
        Buffer h = in.readBytes(4);
        byte[] header = h.getArray();
        ByteOrder byteOrder = null;
        if (header[0] == MAGIC_BIG_ENDIAN[0] && header[1] == MAGIC_BIG_ENDIAN[1] && header[2] == MAGIC_BIG_ENDIAN[2] && header[3] == MAGIC_BIG_ENDIAN[3]) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        } else if (header[0] == MAGIC_LITTLE_ENDIAN[0] && header[1] == MAGIC_LITTLE_ENDIAN[1] && header[2] == MAGIC_LITTLE_ENDIAN[2] && header[3] == MAGIC_LITTLE_ENDIAN[3]) {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else {
            throw new IllegalArgumentException("Unknown header type");
        }
        byte[] body = in.readBytes(20).getArray();
        return new PcapGlobalHeader(byteOrder, body);
    }

    public void write(OutputStream out) throws IOException {
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            out.write(MAGIC_BIG_ENDIAN);
        } else {
            out.write(MAGIC_LITTLE_ENDIAN);
        }
        out.write(this.body);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Version: ").append(this.getMajorVersion()).append(".").append(this.getMinorVersion()).append("\n").append("TimeZone: ").append(this.getTimeZoneCorrection()).append("\n").append("Accuracy: ").append(this.getTimeAccuracy()).append("\n").append("SnapLength: ").append(this.getSnapLength()).append("\n").append("Network: ").append(this.getDataLinkType()).append("\n");
        return sb.toString();
    }

    public static long unsignedInt(byte a, byte b, byte c, byte d) {
        return (a & 0xFF) << 24 | (b & 0xFF) << 16 | (c & 0xFF) << 8 | d & 0xFF;
    }
}

