/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.impl.verify;

import io.mockk.MockKGateway;
import io.mockk.RecordedCall;
import io.mockk.impl.InternalPlatform;
import io.mockk.impl.MultiNotifier;
import io.mockk.impl.Ref;
import io.mockk.impl.stub.Stub;
import io.mockk.impl.stub.StubRepository;
import io.mockk.impl.verify.TimeoutVerifierKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f*\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lio/mockk/impl/verify/TimeoutVerifier;", "Lio/mockk/MockKGateway$CallVerifier;", "stubRepo", "Lio/mockk/impl/stub/StubRepository;", "verifierChain", "(Lio/mockk/impl/stub/StubRepository;Lio/mockk/MockKGateway$CallVerifier;)V", "getStubRepo", "()Lio/mockk/impl/stub/StubRepository;", "getVerifierChain", "()Lio/mockk/MockKGateway$CallVerifier;", "captureArguments", "", "verify", "Lio/mockk/MockKGateway$VerificationResult;", "verificationSequence", "", "Lio/mockk/RecordedCall;", "params", "Lio/mockk/MockKGateway$VerificationParameters;", "allStubs", "Lio/mockk/impl/stub/Stub;", "mockk"})
public final class TimeoutVerifier
implements MockKGateway.CallVerifier {
    @NotNull
    private final StubRepository stubRepo;
    @NotNull
    private final MockKGateway.CallVerifier verifierChain;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public MockKGateway.VerificationResult verify(@NotNull List<RecordedCall> verificationSequence, @NotNull MockKGateway.VerificationParameters params) {
        Intrinsics.checkNotNullParameter(verificationSequence, (String)"verificationSequence");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        List<Stub> stubs = this.allStubs(verificationSequence, this.stubRepo);
        try (MultiNotifier.Session session = this.stubRepo.openRecordCallAwaitSession(stubs, params.getTimeout());){
            while (true) {
                MockKGateway.VerificationResult result2 = this.verifierChain.verify(verificationSequence, params);
                if (params.getInverse() != result2.getMatches()) {
                    MockKGateway.VerificationResult verificationResult = result2;
                    return verificationResult;
                }
                if (session.wait()) continue;
                MockKGateway.VerificationResult lastCheck = this.verifierChain.verify(verificationSequence, params);
                if (params.getInverse() != lastCheck.getMatches()) {
                    MockKGateway.VerificationResult verificationResult = lastCheck;
                    return verificationResult;
                }
                MockKGateway.VerificationResult verificationResult = TimeoutVerifierKt.access$addTimeoutToMessage(lastCheck, params.getTimeout());
                return verificationResult;
            }
        }
    }

    public void captureArguments() {
        this.verifierChain.captureArguments();
    }

    private final List<Stub> allStubs(List<RecordedCall> $this$allStubs, StubRepository stubRepo) {
        Object object;
        Ref it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$allStubs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            RecordedCall recordedCall = (RecordedCall)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = InternalPlatform.INSTANCE.ref(it.getMatcher().getSelf());
            collection.add(object);
        }
        $this$map$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Ref)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = it.getValue();
            collection.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = stubRepo.stubFor(it);
            collection.add(object);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final StubRepository getStubRepo() {
        return this.stubRepo;
    }

    @NotNull
    public final MockKGateway.CallVerifier getVerifierChain() {
        return this.verifierChain;
    }

    public TimeoutVerifier(@NotNull StubRepository stubRepo, @NotNull MockKGateway.CallVerifier verifierChain) {
        Intrinsics.checkNotNullParameter((Object)stubRepo, (String)"stubRepo");
        Intrinsics.checkNotNullParameter((Object)verifierChain, (String)"verifierChain");
        this.stubRepo = stubRepo;
        this.verifierChain = verifierChain;
    }
}

