/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonatype.spice.zapper.IOSourceListable;
import org.sonatype.spice.zapper.Path;
import org.sonatype.spice.zapper.Range;
import org.sonatype.spice.zapper.ZFile;
import org.sonatype.spice.zapper.fs.AbstractDirectory;
import org.sonatype.spice.zapper.fs.CalculateHashStrategy;
import org.sonatype.spice.zapper.fs.HashStrategy;
import org.sonatype.spice.zapper.hash.Hash;
import org.sonatype.spice.zapper.hash.HashAlgorithm;
import org.sonatype.spice.zapper.hash.Sha1HashAlgorithm;
import org.sonatype.spice.zapper.internal.Check;
import org.sonatype.spice.zapper.internal.RangeImpl;
import org.sonatype.spice.zapper.internal.RangeInputStream;
import org.sonatype.spice.zapper.internal.ZFileImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryIOSource
extends AbstractDirectory
implements IOSourceListable {
    private final HashStrategy hashStrategy;

    public DirectoryIOSource(File root) throws IOException, NoSuchAlgorithmException {
        this(root, new Sha1HashAlgorithm());
    }

    public DirectoryIOSource(File root, HashAlgorithm hashAlgorithm) throws IOException {
        this(root, new CalculateHashStrategy(hashAlgorithm));
    }

    public DirectoryIOSource(File root, HashStrategy hashStrategy) throws IOException {
        super(root);
        this.hashStrategy = Check.notNull(hashStrategy, HashStrategy.class);
    }

    @Override
    public ZFile createZFile(Path path) throws IOException {
        File file = this.getFile(Check.notNull(path, Path.class));
        return this.createZFile(path, file);
    }

    @Override
    public InputStream readSegment(Path path, Range range) throws IOException {
        File file = this.getFile(path);
        RangeImpl fileRange = new RangeImpl(0L, file.length());
        if (fileRange.matches(range)) {
            return Channels.newInputStream(new RandomAccessFile(file, "r").getChannel());
        }
        if (fileRange.contains(range)) {
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            raf.seek(range.getOffset());
            return new RangeInputStream(Channels.newInputStream(raf.getChannel()), range, false, true);
        }
        throw new IOException("Range falls out of the supplied ZFile!");
    }

    @Override
    public void close(boolean successful) throws IOException {
    }

    @Override
    public List<ZFile> listFiles() throws IOException {
        ArrayList<ZFile> zfiles = new ArrayList<ZFile>();
        this.scanDirectory(this.getRoot(), zfiles);
        return Collections.unmodifiableList(zfiles);
    }

    public ZFile createZFile(Path path, File file) throws IOException {
        return this.createZFile(path, file, this.hashStrategy.getHashFor(file));
    }

    public ZFile createZFile(Path path, File file, Hash hash) throws IOException {
        Check.notNull(path, Path.class);
        Check.notNull(file, File.class);
        if (file.isFile()) {
            return new ZFileImpl(path, file.length(), file.lastModified(), hash);
        }
        throw new FileNotFoundException(String.format("File on path %s not found!", path));
    }

    protected int scanDirectory(File dir, List<ZFile> zfiles) throws IOException {
        if (dir == null) {
            return 0;
        }
        int i = 0;
        File[] fileArray = dir.listFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                if (file.isDirectory()) {
                    i += this.scanDirectory(file, zfiles);
                    continue;
                }
                if (!file.isFile()) continue;
                String pathString = file.getAbsolutePath().substring(this.getRoot().getAbsolutePath().length() + 1).replace('\\', '/');
                Path path = new Path(pathString);
                ZFile zfile = this.createZFile(path, file);
                zfiles.add(zfile);
                ++i;
            }
        }
        return i;
    }
}

