/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.internal.hawtbuf;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.proto.BaseMessage;
import org.fusesource.hawtbuf.proto.CodedInputStream;
import org.fusesource.hawtbuf.proto.CodedOutputStream;
import org.fusesource.hawtbuf.proto.InvalidProtocolBufferException;
import org.fusesource.hawtbuf.proto.UninitializedMessageException;
import org.sonatype.spice.zapper.internal.hawtbuf.File;
import org.sonatype.spice.zapper.internal.hawtbuf.TransferMessageBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TransferMessage
extends TransferMessageBase<TransferMessage> {
    public ArrayList<String> missingFields() {
        ArrayList missingFields = super.missingFields();
        if (!this.hasMagic()) {
            missingFields.add("magic");
        }
        if (!this.hasTransferId()) {
            missingFields.add("transferId");
        }
        if (!this.hasTransferTotalSize()) {
            missingFields.add("transferTotalSize");
        }
        if (this.hasFiles()) {
            List l = this.getFilesList();
            for (int i = 0; i < l.size(); ++i) {
                try {
                    ((File)((Object)l.get(i))).assertInitialized();
                    continue;
                }
                catch (UninitializedMessageException e) {
                    missingFields.addAll(this.prefix(e.getMissingFields(), "files[" + i + "]"));
                }
            }
        }
        return missingFields;
    }

    public void clear() {
        super.clear();
        this.clearMagic();
        this.clearTransferId();
        this.clearTransferTotalSize();
        this.clearFiles();
    }

    public TransferMessage clone() {
        return new TransferMessage().mergeFrom(this);
    }

    public TransferMessage mergeFrom(TransferMessage other) {
        if (other.hasMagic()) {
            this.setMagic(other.getMagic());
        }
        if (other.hasTransferId()) {
            this.setTransferId(other.getTransferId());
        }
        if (other.hasTransferTotalSize()) {
            this.setTransferTotalSize(other.getTransferTotalSize());
        }
        if (other.hasFiles()) {
            for (File element : other.getFilesList()) {
                this.getFilesList().add(element.clone());
            }
        }
        return this;
    }

    public int serializedSizeUnframed() {
        if (this.memoizedSerializedSize != -1) {
            return this.memoizedSerializedSize;
        }
        int size = 0;
        if (this.hasMagic()) {
            size += CodedOutputStream.computeStringSize((int)1, (String)this.getMagic());
        }
        if (this.hasTransferId()) {
            size += CodedOutputStream.computeStringSize((int)2, (String)this.getTransferId());
        }
        if (this.hasTransferTotalSize()) {
            size += CodedOutputStream.computeInt64Size((int)3, (long)this.getTransferTotalSize());
        }
        if (this.hasFiles()) {
            for (File i : this.getFilesList()) {
                size += TransferMessage.computeMessageSize((int)10, (BaseMessage)i);
            }
        }
        this.memoizedSerializedSize = size;
        return size;
    }

    public TransferMessage mergeUnframed(CodedInputStream input) throws IOException {
        int tag;
        block7: while (((tag = input.readTag()) & 7) != 4) {
            switch (tag) {
                case 0: {
                    return this;
                }
                default: {
                    continue block7;
                }
                case 10: {
                    this.setMagic(input.readString());
                    continue block7;
                }
                case 18: {
                    this.setTransferId(input.readString());
                    continue block7;
                }
                case 24: {
                    this.setTransferTotalSize(input.readInt64());
                    continue block7;
                }
                case 82: 
            }
            this.getFilesList().add(new File().mergeFramed(input));
        }
        return this;
    }

    public void writeUnframed(CodedOutputStream output) throws IOException {
        if (this.hasMagic()) {
            output.writeString(1, this.getMagic());
        }
        if (this.hasTransferId()) {
            output.writeString(2, this.getTransferId());
        }
        if (this.hasTransferTotalSize()) {
            output.writeInt64(3, this.getTransferTotalSize());
        }
        if (this.hasFiles()) {
            for (File i : this.getFilesList()) {
                TransferMessage.writeMessage((CodedOutputStream)output, (int)10, (BaseMessage)i);
            }
        }
    }

    public static TransferMessage parseUnframed(CodedInputStream data) throws InvalidProtocolBufferException, IOException {
        return (TransferMessage)((Object)new TransferMessage().mergeUnframed(data).checktInitialized());
    }

    public static TransferMessage parseUnframed(Buffer data) throws InvalidProtocolBufferException {
        return (TransferMessage)((Object)((TransferMessage)((Object)new TransferMessage().mergeUnframed(data))).checktInitialized());
    }

    public static TransferMessage parseUnframed(byte[] data) throws InvalidProtocolBufferException {
        return (TransferMessage)((Object)((TransferMessage)((Object)new TransferMessage().mergeUnframed(data))).checktInitialized());
    }

    public static TransferMessage parseUnframed(InputStream data) throws InvalidProtocolBufferException, IOException {
        return (TransferMessage)((Object)((TransferMessage)((Object)new TransferMessage().mergeUnframed(data))).checktInitialized());
    }

    public static TransferMessage parseFramed(CodedInputStream data) throws InvalidProtocolBufferException, IOException {
        return (TransferMessage)((Object)((TransferMessage)((Object)new TransferMessage().mergeFramed(data))).checktInitialized());
    }

    public static TransferMessage parseFramed(Buffer data) throws InvalidProtocolBufferException {
        return (TransferMessage)((Object)((TransferMessage)((Object)new TransferMessage().mergeFramed(data))).checktInitialized());
    }

    public static TransferMessage parseFramed(byte[] data) throws InvalidProtocolBufferException {
        return (TransferMessage)((Object)((TransferMessage)((Object)new TransferMessage().mergeFramed(data))).checktInitialized());
    }

    public static TransferMessage parseFramed(InputStream data) throws InvalidProtocolBufferException, IOException {
        return (TransferMessage)((Object)((TransferMessage)((Object)new TransferMessage().mergeFramed(data))).checktInitialized());
    }

    public String toString() {
        return this.toString(new StringBuilder(), "").toString();
    }

    public StringBuilder toString(StringBuilder sb, String prefix) {
        if (this.hasMagic()) {
            sb.append(prefix + "magic: ");
            sb.append(this.getMagic());
            sb.append("\n");
        }
        if (this.hasTransferId()) {
            sb.append(prefix + "transferId: ");
            sb.append(this.getTransferId());
            sb.append("\n");
        }
        if (this.hasTransferTotalSize()) {
            sb.append(prefix + "transferTotalSize: ");
            sb.append(this.getTransferTotalSize());
            sb.append("\n");
        }
        if (this.hasFiles()) {
            List l = this.getFilesList();
            for (int i = 0; i < l.size(); ++i) {
                sb.append(prefix + "files[" + i + "] {\n");
                ((File)((Object)l.get(i))).toString(sb, prefix + "  ");
                sb.append(prefix + "}\n");
            }
        }
        return sb;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != TransferMessage.class) {
            return false;
        }
        return this.equals((TransferMessage)((Object)obj));
    }

    public boolean equals(TransferMessage obj) {
        if (this.hasMagic() ^ obj.hasMagic()) {
            return false;
        }
        if (this.hasMagic() && !this.getMagic().equals(obj.getMagic())) {
            return false;
        }
        if (this.hasTransferId() ^ obj.hasTransferId()) {
            return false;
        }
        if (this.hasTransferId() && !this.getTransferId().equals(obj.getTransferId())) {
            return false;
        }
        if (this.hasTransferTotalSize() ^ obj.hasTransferTotalSize()) {
            return false;
        }
        if (this.hasTransferTotalSize() && this.getTransferTotalSize() != obj.getTransferTotalSize()) {
            return false;
        }
        if (this.hasFiles() ^ obj.hasFiles()) {
            return false;
        }
        return !this.hasFiles() || this.getFilesList().equals(obj.getFilesList());
    }

    public int hashCode() {
        int rc = 1411770748;
        if (this.hasMagic()) {
            rc ^= 0x46AB98D ^ this.getMagic().hashCode();
        }
        if (this.hasTransferId()) {
            rc ^= 0xFDC4E86 ^ this.getTransferId().hashCode();
        }
        if (this.hasTransferTotalSize()) {
            rc ^= 0x15BD4D9A ^ new Long(this.getTransferTotalSize()).hashCode();
        }
        if (this.hasFiles()) {
            rc ^= 0x40BCA57 ^ this.getFilesList().hashCode();
        }
        return rc;
    }
}

