/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.staging.remote;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.staging.client.StagingWorkflowV2Service;
import com.sonatype.nexus.staging.client.StagingWorkflowV3Service;
import com.sonatype.nexus.staging.client.rest.JerseyStagingWorkflowV2SubsystemFactory;
import com.sonatype.nexus.staging.client.rest.JerseyStagingWorkflowV3SubsystemFactory;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.net.MalformedURLException;
import java.util.HashMap;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.maven.mojo.settings.MavenSettings;
import org.sonatype.nexus.client.core.NexusClient;
import org.sonatype.nexus.client.core.NexusStatus;
import org.sonatype.nexus.client.core.spi.SubsystemFactory;
import org.sonatype.nexus.client.rest.AuthenticationInfo;
import org.sonatype.nexus.client.rest.BaseUrl;
import org.sonatype.nexus.client.rest.ConnectionInfo;
import org.sonatype.nexus.client.rest.Protocol;
import org.sonatype.nexus.client.rest.ProxyInfo;
import org.sonatype.nexus.client.rest.UsernamePasswordAuthenticationInfo;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClientFactory;
import org.sonatype.nexus.maven.staging.ProgressMonitorImpl;
import org.sonatype.nexus.maven.staging.remote.Parameters;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.shaded.SecDispatcherException;

public class RemoteNexus {
    private final Logger log = LoggerFactory.getLogger(RemoteNexus.class);
    private final Server server;
    private final Proxy proxy;
    private final NexusClient nexusClient;
    private final StagingWorkflowV2Service stagingWorkflowService;

    public RemoteNexus(MavenSession mavenSession, SecDispatcher secDispatcher, Parameters parameters) {
        Preconditions.checkNotNull((Object)mavenSession);
        Preconditions.checkNotNull((Object)secDispatcher);
        Preconditions.checkNotNull((Object)parameters);
        parameters.validateRemoting();
        String nexusUrl = parameters.getNexusUrl();
        try {
            Server server = MavenSettings.selectServer((Settings)mavenSession.getSettings(), (String)parameters.getServerId());
            if (server == null) {
                throw new IllegalArgumentException("Server credentials with ID \"" + parameters.getServerId() + "\" not found!");
            }
            this.server = MavenSettings.decrypt((SecDispatcher)secDispatcher, (Server)server);
            Proxy proxy = MavenSettings.selectProxy((Settings)mavenSession.getSettings(), (String)nexusUrl, (boolean)true);
            this.proxy = proxy != null ? MavenSettings.decrypt((SecDispatcher)secDispatcher, (Proxy)proxy) : null;
        }
        catch (SecDispatcherException e) {
            throw new IllegalArgumentException("Cannot decipher credentials to be used with Nexus!", e);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed Nexus base URL [" + nexusUrl + "]", e);
        }
        this.nexusClient = this.createNexusClient(parameters);
        this.stagingWorkflowService = this.createStagingWorkflowV2Service(parameters, this.nexusClient);
    }

    public Server getServer() {
        return this.server;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.getNexusClient().getConnectionInfo();
    }

    public NexusClient getNexusClient() {
        return this.nexusClient;
    }

    public NexusStatus getNexusStatus() {
        return this.getNexusClient().getNexusStatus();
    }

    public StagingWorkflowV2Service getStagingWorkflowV2Service() {
        return this.stagingWorkflowService;
    }

    protected NexusClient createNexusClient(Parameters parameters) {
        String nexusUrl = parameters.getNexusUrl();
        try {
            UsernamePasswordAuthenticationInfo authenticationInfo;
            BaseUrl baseUrl = BaseUrl.baseUrlFrom((String)nexusUrl);
            HashMap<Protocol, ProxyInfo> proxyInfos = new HashMap<Protocol, ProxyInfo>(1);
            if (this.server != null && this.server.getUsername() != null) {
                this.log.info(" + Using server credentials \"{}\" from Maven settings.", (Object)this.server.getId());
                authenticationInfo = new UsernamePasswordAuthenticationInfo(this.server.getUsername(), this.server.getPassword());
            } else {
                authenticationInfo = null;
            }
            if (this.proxy != null) {
                UsernamePasswordAuthenticationInfo proxyAuthentication = this.proxy.getUsername() != null ? new UsernamePasswordAuthenticationInfo(this.proxy.getUsername(), this.proxy.getPassword()) : null;
                this.log.info(" + Using \"{}\" {} Proxy from Maven settings.", (Object)this.proxy.getId(), (Object)this.proxy.getProtocol().toUpperCase());
                ProxyInfo zProxy = new ProxyInfo(baseUrl.getProtocol(), this.proxy.getHost(), this.proxy.getPort(), (AuthenticationInfo)proxyAuthentication);
                proxyInfos.put(zProxy.getProxyProtocol(), zProxy);
            }
            ConnectionInfo.ValidationLevel sslCertificateValidationLevel = parameters.isSslInsecure() ? ConnectionInfo.ValidationLevel.LAX : ConnectionInfo.ValidationLevel.STRICT;
            ConnectionInfo.ValidationLevel sslCertificateHostnameValidationLevel = parameters.isSslAllowAll() ? ConnectionInfo.ValidationLevel.NONE : ConnectionInfo.ValidationLevel.LAX;
            ConnectionInfo connectionInfo = new ConnectionInfo(baseUrl, (AuthenticationInfo)authenticationInfo, proxyInfos, sslCertificateValidationLevel, sslCertificateHostnameValidationLevel);
            NexusClient nexusClient = new JerseyNexusClientFactory(new SubsystemFactory[]{new JerseyStagingWorkflowV2SubsystemFactory(), new JerseyStagingWorkflowV3SubsystemFactory()}).createFor(connectionInfo);
            NexusStatus nexusStatus = nexusClient.getNexusStatus();
            this.log.info(" * Connected to Nexus at {}, is version {} and edition \"{}\"", new Object[]{connectionInfo.getBaseUrl(), nexusStatus.getVersion(), nexusStatus.getEditionLong()});
            return nexusClient;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed Nexus base URL [" + nexusUrl + "]", e);
        }
        catch (UniformInterfaceException e) {
            throw new IllegalArgumentException("Nexus base URL [" + nexusUrl + "] does not point to a valid Nexus location: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Nexus connection problem to URL [" + nexusUrl + " ]: " + e.getMessage(), e);
        }
    }

    protected StagingWorkflowV2Service createStagingWorkflowV2Service(Parameters parameters, NexusClient nexusClient) {
        StagingWorkflowV2Service workflowService = null;
        try {
            StagingWorkflowV3Service service = (StagingWorkflowV3Service)nexusClient.getSubsystem(StagingWorkflowV3Service.class);
            this.log.debug("Using staging v3 service");
            service.setProgressMonitor(new ProgressMonitorImpl());
            service.setProgressTimeoutMinutes(parameters.getStagingProgressTimeoutMinutes());
            service.setProgressPauseDurationSeconds(parameters.getStagingProgressPauseDurationSeconds());
            this.log.debug("Using progressTimeoutMinutes={}, progressPauseDurationSeconds={}", (Object)parameters.getStagingProgressTimeoutMinutes(), (Object)parameters.getStagingProgressPauseDurationSeconds());
            workflowService = service;
        }
        catch (Exception e) {
            this.log.debug("Unable to resolve staging v3 service; falling back to v2", (Throwable)e);
        }
        if (workflowService == null) {
            try {
                workflowService = (StagingWorkflowV2Service)nexusClient.getSubsystem(StagingWorkflowV2Service.class);
                this.log.debug("Using staging v2 service");
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Nexus instance at base URL %s does not support staging v2; reported status: %s, reason: %s", nexusClient.getConnectionInfo().getBaseUrl(), nexusClient.getNexusStatus(), e.getMessage()), e);
            }
        }
        return workflowService;
    }
}

