/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository.maven;

import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.client.core.subsystem.repository.Repository;
import org.sonatype.nexus.client.core.subsystem.repository.maven.MavenProxyRepository;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository.JerseyProxyRepositoryFactory;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository.maven.JerseyMavenProxyRepository;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;
import org.sonatype.nexus.rest.model.RepositoryBaseResource;
import org.sonatype.nexus.rest.model.RepositoryProxyResource;

@Named
@Singleton
public class JerseyMavenProxyRepositoryFactory
extends JerseyProxyRepositoryFactory {
    @Override
    public int canAdapt(RepositoryBaseResource resource) {
        int score = super.canAdapt(resource);
        if (score > 0 && "maven2".equals(resource.getProvider())) {
            ++score;
        }
        return score;
    }

    @Override
    public JerseyMavenProxyRepository adapt(JerseyNexusClient nexusClient, RepositoryBaseResource resource) {
        return new JerseyMavenProxyRepository(nexusClient, (RepositoryProxyResource)resource);
    }

    @Override
    public boolean canCreate(Class<? extends Repository> type) {
        return MavenProxyRepository.class.equals(type);
    }

    @Override
    public JerseyMavenProxyRepository create(JerseyNexusClient nexusClient, String id) {
        return new JerseyMavenProxyRepository(nexusClient, id);
    }
}

