/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath;

import com.github.ajalt.colormath.Ansi16;
import com.github.ajalt.colormath.Ansi256;
import com.github.ajalt.colormath.ConvertibleColor;
import com.github.ajalt.colormath.ExtensionsKt;
import com.github.ajalt.colormath.HSL;
import com.github.ajalt.colormath.HSV;
import com.github.ajalt.colormath.LAB;
import com.github.ajalt.colormath.RGB;
import com.github.ajalt.colormath.XYZ;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u0017\u001a\u00020\u0000H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u001c"}, d2={"Lcom/github/ajalt/colormath/CMYK;", "Lcom/github/ajalt/colormath/ConvertibleColor;", "c", "", "m", "y", "k", "(IIII)V", "getC", "()I", "getK", "getM", "getY", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toCMYK", "toRGB", "Lcom/github/ajalt/colormath/RGB;", "toString", "", "colorconversion"})
public final class CMYK
implements ConvertibleColor {
    private final int c;
    private final int m;
    private final int y;
    private final int k;

    @Override
    @NotNull
    public RGB toRGB() {
        double c = (double)this.c / 100.0;
        double m = (double)this.m / 100.0;
        double y = (double)this.y / 100.0;
        double k = (double)this.k / 100.0;
        double r = (double)255 * (1.0 - c) * (1.0 - k);
        double g = (double)255 * (1.0 - m) * (1.0 - k);
        double b = (double)255 * (1.0 - y) * (1.0 - k);
        return new RGB(ExtensionsKt.roundToInt(r), ExtensionsKt.roundToInt(g), ExtensionsKt.roundToInt(b));
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return this;
    }

    public final int getC() {
        return this.c;
    }

    public final int getM() {
        return this.m;
    }

    public final int getY() {
        return this.y;
    }

    public final int getK() {
        return this.k;
    }

    public CMYK(int c, int m, int y, int k) {
        this.c = c;
        this.m = m;
        this.y = y;
        this.k = k;
        int n = this.c;
        int n2 = n = 0 <= n && 100 >= n ? 1 : 0;
        if (n == 0) {
            String string = "c must be in range [0, 100] in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = this.m;
        int n3 = n = 0 <= n && 100 >= n ? 1 : 0;
        if (n == 0) {
            String string = "m must be in range [0, 100] in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = this.y;
        int n4 = n = 0 <= n && 100 >= n ? 1 : 0;
        if (n == 0) {
            String string = "y must be in range [0, 100] in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = this.k;
        int n5 = n = 0 <= n && 100 >= n ? 1 : 0;
        if (n == 0) {
            String string = "k must be in range [0, 100] in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public String toHex(boolean withNumberSign) {
        return ConvertibleColor.DefaultImpls.toHex(this, withNumberSign);
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return ConvertibleColor.DefaultImpls.toHSL(this);
    }

    @Override
    @NotNull
    public HSV toHSV() {
        return ConvertibleColor.DefaultImpls.toHSV(this);
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return ConvertibleColor.DefaultImpls.toAnsi16(this);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return ConvertibleColor.DefaultImpls.toAnsi256(this);
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        return ConvertibleColor.DefaultImpls.toXYZ(this);
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return ConvertibleColor.DefaultImpls.toLAB(this);
    }

    public final int component1() {
        return this.c;
    }

    public final int component2() {
        return this.m;
    }

    public final int component3() {
        return this.y;
    }

    public final int component4() {
        return this.k;
    }

    @NotNull
    public final CMYK copy(int c, int m, int y, int k) {
        return new CMYK(c, m, y, k);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ CMYK copy$default(CMYK cMYK, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = cMYK.c;
        }
        if ((n5 & 2) != 0) {
            n2 = cMYK.m;
        }
        if ((n5 & 4) != 0) {
            n3 = cMYK.y;
        }
        if ((n5 & 8) != 0) {
            n4 = cMYK.k;
        }
        return cMYK.copy(n, n2, n3, n4);
    }

    public String toString() {
        return "CMYK(c=" + this.c + ", m=" + this.m + ", y=" + this.y + ", k=" + this.k + ")";
    }

    public int hashCode() {
        return ((this.c * 31 + this.m) * 31 + this.y) * 31 + this.k;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof CMYK)) break block3;
                CMYK cMYK = (CMYK)object;
                if (!(this.c == cMYK.c) || !(this.m == cMYK.m) || !(this.y == cMYK.y) || !(this.k == cMYK.k)) break block3;
            }
            return true;
        }
        return false;
    }
}

