/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.ProvisionException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Configuration;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.factory.ComponentFactory;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.eclipse.sisu.plexus.annotations.ComponentImpl;
import org.eclipse.sisu.plexus.annotations.RequirementImpl;
import org.eclipse.sisu.plexus.binders.PlexusTypeBinder;
import org.eclipse.sisu.plexus.config.PlexusBeanMetadata;
import org.eclipse.sisu.plexus.config.PlexusBeanModule;
import org.eclipse.sisu.plexus.config.PlexusBeanSource;
import org.eclipse.sisu.plexus.locators.ClassRealmUtils;
import org.eclipse.sisu.reflect.BeanProperty;
import org.eclipse.sisu.reflect.ClassSpace;
import org.eclipse.sisu.reflect.DeferredClass;
import org.eclipse.sisu.reflect.DeferredProvider;
import org.eclipse.sisu.reflect.LoadedClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ComponentDescriptorBeanModule
implements PlexusBeanModule {
    private final ClassSpace space;
    private final Map<Component, DeferredClass<?>> componentMap = new HashMap();
    private final Map<String, PlexusBeanMetadata> metadataMap = new HashMap<String, PlexusBeanMetadata>();

    ComponentDescriptorBeanModule(ClassSpace space, List<ComponentDescriptor<?>> descriptors) {
        this.space = space;
        int size = descriptors.size();
        for (int i = 0; i < size; ++i) {
            ComponentDescriptor<?> cd = descriptors.get(i);
            Component component = ComponentDescriptorBeanModule.newComponent(cd);
            String factory = cd.getComponentFactory();
            if (null == factory || "java".equals(factory)) {
                try {
                    this.componentMap.put(component, (DeferredClass<?>)new LoadedClass(cd.getImplementationClass()));
                }
                catch (TypeNotPresentException e) {
                    this.componentMap.put(component, space.deferLoadClass(cd.getImplementation()));
                }
            } else {
                this.componentMap.put(component, new DeferredFactoryClass(cd, factory));
            }
            List<ComponentRequirement> requirements = cd.getRequirements();
            if (requirements.isEmpty()) continue;
            this.metadataMap.put(cd.getImplementation(), new ComponentMetadata(space, requirements));
        }
    }

    @Override
    public PlexusBeanSource configure(Binder binder) {
        PlexusTypeBinder plexusTypeBinder = new PlexusTypeBinder(binder);
        for (Map.Entry<Component, DeferredClass<?>> entry : this.componentMap.entrySet()) {
            plexusTypeBinder.hear(entry.getKey(), entry.getValue(), (Object)this.space);
        }
        return new PlexusDescriptorBeanSource(this.metadataMap);
    }

    static Component newComponent(ComponentDescriptor<?> cd) {
        return new ComponentImpl(cd.getRoleClass(), cd.getRoleHint(), cd.getInstantiationStrategy(), cd.getDescription());
    }

    static Requirement newRequirement(ClassSpace space, ComponentRequirement cr) {
        return new RequirementImpl(space.deferLoadClass(cr.getRole()), cr.isOptional(), Collections.singletonList(cr.getRoleHint()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PlexusDescriptorBeanSource
    implements PlexusBeanSource {
        private Map<String, PlexusBeanMetadata> metadataMap;

        PlexusDescriptorBeanSource(Map<String, PlexusBeanMetadata> metadataMap) {
            this.metadataMap = metadataMap;
        }

        @Override
        public PlexusBeanMetadata getBeanMetadata(Class<?> implementation) {
            if (null == this.metadataMap) {
                return null;
            }
            PlexusBeanMetadata metadata = this.metadataMap.remove(implementation.getName());
            if (this.metadataMap.isEmpty()) {
                this.metadataMap = null;
            }
            return metadata;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ComponentMetadata
    implements PlexusBeanMetadata {
        private Map<String, Requirement> requirementMap = new HashMap<String, Requirement>();

        ComponentMetadata(ClassSpace space, List<ComponentRequirement> requirements) {
            int size = requirements.size();
            for (int i = 0; i < size; ++i) {
                ComponentRequirement cr = requirements.get(i);
                this.requirementMap.put(cr.getFieldName(), ComponentDescriptorBeanModule.newRequirement(space, cr));
            }
        }

        @Override
        public boolean isEmpty() {
            return this.requirementMap.isEmpty();
        }

        @Override
        public Requirement getRequirement(BeanProperty<?> property) {
            Requirement requirement = this.requirementMap.get(property.getName());
            if (null != requirement && this.requirementMap.isEmpty()) {
                this.requirementMap = Collections.emptyMap();
            }
            return requirement;
        }

        @Override
        public Configuration getConfiguration(BeanProperty<?> property) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DeferredFactoryClass
    implements DeferredClass<Object>,
    DeferredProvider<Object> {
        @Inject
        private PlexusContainer container;
        @Inject
        private Injector injector;
        private final ComponentDescriptor<?> cd;
        private final String hint;

        DeferredFactoryClass(ComponentDescriptor<?> cd, String hint) {
            this.cd = cd;
            this.hint = hint;
        }

        public Class load() throws TypeNotPresentException {
            return this.cd.getImplementationClass();
        }

        public String getName() {
            return this.cd.getImplementation();
        }

        public DeferredProvider<Object> asProvider() {
            return this;
        }

        public Object get() {
            try {
                ComponentFactory factory;
                Object o;
                ClassRealm contextRealm = this.container.getLookupRealm();
                if (null == contextRealm) {
                    contextRealm = ClassRealmUtils.contextRealm();
                }
                if (null == contextRealm) {
                    contextRealm = this.container.getContainerRealm();
                }
                if (null != (o = (factory = this.container.lookup(ComponentFactory.class, this.hint)).newInstance(this.cd, contextRealm, this.container))) {
                    this.injector.injectMembers(o);
                }
                return o;
            }
            catch (Exception e) {
                throw new ProvisionException("Error in ComponentFactory:" + this.hint, (Throwable)e);
            }
        }

        public DeferredClass<Object> getImplementationClass() {
            return this;
        }
    }
}

