/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.jetty;

import io.ktor.server.application.DefaultApplicationEventsKt;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.ApplicationEngineJvmKt;
import io.ktor.server.engine.BaseApplicationEngine;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EngineConnectorConfigJvmKt;
import io.ktor.server.engine.EngineContextCancellationHelperKt;
import io.ktor.server.jetty.JettyApplicationEngineBase;
import io.ktor.server.jetty.ServerInitializerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableJob;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001cB&\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lio/ktor/server/jetty/JettyApplicationEngineBase;", "Lio/ktor/server/engine/BaseApplicationEngine;", "environment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "configure", "Lkotlin/Function1;", "Lio/ktor/server/jetty/JettyApplicationEngineBase$Configuration;", "", "Lkotlin/ExtensionFunctionType;", "(Lio/ktor/server/engine/ApplicationEngineEnvironment;Lkotlin/jvm/functions/Function1;)V", "cancellationDeferred", "Lkotlinx/coroutines/CompletableJob;", "configuration", "getConfiguration", "()Lio/ktor/server/jetty/JettyApplicationEngineBase$Configuration;", "server", "Lorg/eclipse/jetty/server/Server;", "getServer", "()Lorg/eclipse/jetty/server/Server;", "start", "wait", "", "stop", "gracePeriodMillis", "", "timeoutMillis", "toString", "", "Configuration", "ktor-server-jetty"})
public class JettyApplicationEngineBase
extends BaseApplicationEngine {
    @NotNull
    private final Configuration configuration;
    @Nullable
    private CompletableJob cancellationDeferred;
    @NotNull
    private final Server server;

    /*
     * WARNING - void declaration
     */
    public JettyApplicationEngineBase(@NotNull ApplicationEngineEnvironment environment, @NotNull Function1<? super Configuration, Unit> configure) {
        void $this$server_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(configure, (String)"configure");
        super(environment, null, 2, null);
        Configuration configuration = new Configuration();
        configure.invoke((Object)configuration);
        this.configuration = configuration;
        Configuration configuration2 = configuration = new Server();
        JettyApplicationEngineBase jettyApplicationEngineBase = this;
        boolean bl = false;
        this.configuration.getConfigureServer().invoke((Object)$this$server_u24lambda_u2d0);
        ServerInitializerKt.initializeServer((Server)$this$server_u24lambda_u2d0, environment);
        jettyApplicationEngineBase.server = configuration;
    }

    @NotNull
    protected final Configuration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    protected final Server getServer() {
        return this.server;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public JettyApplicationEngineBase start(boolean wait) {
        void $this$mapTo$iv$iv;
        this.getEnvironment().start();
        this.server.start();
        this.cancellationDeferred = EngineContextCancellationHelperKt.stopServerOnCancellation((ApplicationEngine)((ApplicationEngine)this));
        Connector[] connectorArray = this.server.getConnectors();
        Intrinsics.checkNotNullExpressionValue((Object)connectorArray, (String)"server.connectors");
        Iterable $this$map$iv = ArraysKt.zip((Object[])connectorArray, (Iterable)this.getEnvironment().getConnectors());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = it.getFirst();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.eclipse.jetty.server.ServerConnector");
            }
            collection.add(EngineConnectorConfigJvmKt.withPort((EngineConnectorConfig)((EngineConnectorConfig)it.getSecond()), (int)((ServerConnector)object).getLocalPort()));
        }
        List connectors = (List)destination$iv$iv;
        this.getResolvedConnectors().complete((Object)connectors);
        if (wait) {
            this.server.join();
            ApplicationEngineJvmKt.stop((ApplicationEngine)((ApplicationEngine)this), (long)1L, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        }
        return this;
    }

    public void stop(long gracePeriodMillis, long timeoutMillis) {
        CompletableJob completableJob = this.cancellationDeferred;
        if (completableJob != null) {
            completableJob.complete();
        }
        this.getEnvironment().getMonitor().raise(DefaultApplicationEventsKt.getApplicationStopPreparing(), (Object)this.getEnvironment());
        this.server.setStopTimeout(timeoutMillis);
        this.server.stop();
        this.server.destroy();
        this.getEnvironment().stop();
    }

    @NotNull
    public String toString() {
        return "Jetty(" + this.getEnvironment() + ')';
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R+\u0010\u0003\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/ktor/server/jetty/JettyApplicationEngineBase$Configuration;", "Lio/ktor/server/engine/BaseApplicationEngine$Configuration;", "()V", "configureServer", "Lkotlin/Function1;", "Lorg/eclipse/jetty/server/Server;", "", "Lkotlin/ExtensionFunctionType;", "getConfigureServer", "()Lkotlin/jvm/functions/Function1;", "setConfigureServer", "(Lkotlin/jvm/functions/Function1;)V", "ktor-server-jetty"})
    public static final class Configuration
    extends BaseApplicationEngine.Configuration {
        @NotNull
        private Function1<? super Server, Unit> configureServer = configureServer.1.INSTANCE;

        @NotNull
        public final Function1<Server, Unit> getConfigureServer() {
            return this.configureServer;
        }

        public final void setConfigureServer(@NotNull Function1<? super Server, Unit> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
            this.configureServer = function1;
        }
    }
}

