/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.core.subsystem.config;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;

public class SecuritySettings {
    private boolean anonymousAccessEnabled;
    private String anonymousUsername;
    private String anonymousPassword;
    private List<String> realms;

    public boolean isAnonymousAccessEnabled() {
        return this.anonymousAccessEnabled;
    }

    public void setAnonymousAccessEnabled(boolean anonymousAccessEnabled) {
        this.anonymousAccessEnabled = anonymousAccessEnabled;
    }

    public SecuritySettings withAnonymousAccessEnabled(boolean anonymousAccessEnabled) {
        this.setAnonymousAccessEnabled(anonymousAccessEnabled);
        return this;
    }

    public String getAnonymousUsername() {
        return this.anonymousUsername;
    }

    public void setAnonymousUsername(String anonymousUsername) {
        this.anonymousUsername = anonymousUsername;
    }

    public SecuritySettings withAnonymousUsername(String anonymousUsername) {
        this.setAnonymousUsername(anonymousUsername);
        return this;
    }

    public String getAnonymousPassword() {
        return this.anonymousPassword;
    }

    public void setAnonymousPassword(String anonymousPassword) {
        this.anonymousPassword = anonymousPassword;
    }

    public SecuritySettings withAnonymousPassword(String anonymousPassword) {
        this.setAnonymousPassword(anonymousPassword);
        return this;
    }

    public List<String> getRealms() {
        return this.realms;
    }

    public void setRealms(List<String> realms) {
        this.realms = realms == null ? Lists.newArrayList() : Lists.newArrayList(realms);
    }

    public SecuritySettings withRealms(List<String> realms) {
        this.setRealms(realms);
        return this;
    }

    public SecuritySettings withRealms(String ... realms) {
        if (realms == null) {
            this.setRealms(null);
        } else {
            this.setRealms(Arrays.asList(realms));
        }
        return this;
    }

    public SecuritySettings addRealm(String realm) {
        this.removeRealm(realm);
        this.getRealms().add(realm);
        return this;
    }

    public SecuritySettings addRealm(String realm, int position) {
        this.removeRealm(realm);
        this.getRealms().add(position, realm);
        return this;
    }

    public SecuritySettings removeRealm(String realm) {
        this.getRealms().remove(realm);
        return this;
    }
}

