/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.cfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.ImmutableCollection;
import kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.cfa.FirCallsEffectAnalyzer;
import org.jetbrains.kotlin.fir.analysis.cfa.util.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.CfgUtilsKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.EventOccurrencesRangeInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PathAwareControlFlowInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PropertyInitializationInfoCollectorKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.TraverseDirection;
import org.jetbrains.kotlin.fir.analysis.checkers.cfa.FirControlFlowChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.contracts.ContractUtilsKt;
import org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirResolvedContractDescription;
import org.jetbrains.kotlin.fir.contracts.description.ConeCallsEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.description.ConeEffectDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirContractDescriptionOwner;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.references.FirThisReference;
import org.jetbrains.kotlin.fir.resolve.CallableIdUtilsKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitor;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EdgeLabel;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FunctionCallNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FunctionEnterNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FunctionExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.InitBlockEnterNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.InitBlockExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.NormalPath;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.PropertyInitializerEnterNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.PropertyInitializerExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableDeclarationNode;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.InferenceUtilsKt;
import org.jetbrains.kotlin.name.CallableId;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005)*+,-B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J<\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u0012*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u0012*\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u0004\u0018\u00010!*\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u0010\"\u001a\u00020\f*\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%H\u0002J\f\u0010&\u001a\u00020\f*\u00020'H\u0002J\u0010\u0010(\u001a\u0004\u0018\u00010\u0017*\u0004\u0018\u00010\u001bH\u0002\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/cfa/FirControlFlowChecker;", "()V", "analyze", "", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "investigate", "", "info", "Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$LambdaInvocationInfo;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "requiredRange", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirContractDescriptionOwner;", "referenceToSymbol", "reference", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "getArgumentCallsEffect", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "arg", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getParameterCallsEffect", "Lorg/jetbrains/kotlin/fir/contracts/FirContractDescription;", "index", "", "getParameterCallsEffectDeclaration", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeCallsEffectDeclaration;", "isFunctionalTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isInPlaceLambda", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "toQualifiedReference", "CapturedLambdaFinder", "IllegalScopeContext", "InvocationDataCollector", "LambdaInvocationInfo", "PathAwareLambdaInvocationInfo", "checkers"})
public final class FirCallsEffectAnalyzer
extends FirControlFlowChecker {
    @NotNull
    public static final FirCallsEffectAnalyzer INSTANCE = new FirCallsEffectAnalyzer();

    private FirCallsEffectAnalyzer() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void analyze(@NotNull ControlFlowGraph graph2, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2) {
        void destination$iv;
        void $this$filterTo$iv;
        Object symbol2;
        ConeCallsEffectDeclaration effectDeclaration;
        boolean bl;
        int n;
        Intrinsics.checkNotNullParameter((Object)graph2, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FirSession session2 = context2.getSession();
        FirDeclaration firDeclaration = graph2.getDeclaration();
        FirFunction firFunction = firDeclaration instanceof FirFunction ? (FirFunction)firDeclaration : null;
        if (firFunction == null) {
            return;
        }
        FirFunction function2 = firFunction;
        if (!(function2 instanceof FirContractDescriptionOwner)) {
            return;
        }
        List<ConeEffectDeclaration> list2 = ContractUtilsKt.getConeEffects(((FirContractDescriptionOwner)((Object)function2)).getContractDescription());
        if (list2 != null) {
            boolean bl2;
            block18: {
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ConeEffectDeclaration it = (ConeEffectDeclaration)element$iv;
                        n = 0;
                        if (!(it instanceof ConeCallsEffectDeclaration)) continue;
                        bl2 = true;
                        break block18;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        } else {
            bl = false;
        }
        if (!bl) {
            return;
        }
        Map functionalTypeEffects = new LinkedHashMap();
        Iterable $this$forEachIndexed$iv = function2.getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv2 = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            ConeCallsEffectDeclaration effectDeclaration2;
            void parameter;
            if ((n = index$iv2++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FirValueParameter firValueParameter = (FirValueParameter)item$iv;
            int index2 = n;
            boolean bl3 = false;
            if (!INSTANCE.isFunctionalTypeRef(parameter.getReturnTypeRef(), session2) || (effectDeclaration2 = INSTANCE.getParameterCallsEffectDeclaration(((FirContractDescriptionOwner)((Object)function2)).getContractDescription(), index2)) == null) continue;
            functionalTypeEffects.put(parameter.getSymbol(), effectDeclaration2);
        }
        if (this.isFunctionalTypeRef(function2.getReceiverTypeRef(), session2) && (effectDeclaration = this.getParameterCallsEffectDeclaration(((FirContractDescriptionOwner)((Object)function2)).getContractDescription(), -1)) != null) {
            functionalTypeEffects.put(function2.getSymbol(), effectDeclaration);
        }
        if (functionalTypeEffects.isEmpty()) {
            return;
        }
        Map leakedSymbols = new LinkedHashMap();
        CfgTraverserKt.traverse(graph2, TraverseDirection.Forward, new CapturedLambdaFinder(function2), new IllegalScopeContext(functionalTypeEffects.keySet(), leakedSymbols));
        for (Map.Entry index$iv2 : leakedSymbols.entrySet()) {
            symbol2 = (FirBasedSymbol)index$iv2.getKey();
            List leakedPlaces = (List)index$iv2.getValue();
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirContractDescriptionOwner)((Object)function2)).getContractDescription().getSource(), FirErrors.INSTANCE.getLEAKED_IN_PLACE_LAMBDA(), symbol2, (DiagnosticContext)context2, null, 16, null);
            Iterable $this$forEach$iv = leakedPlaces;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtSourceElement it = (KtSourceElement)element$iv;
                boolean bl4 = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getLEAKED_IN_PLACE_LAMBDA(), symbol2, (DiagnosticContext)context2, null, 16, null);
            }
        }
        Iterable index$iv2 = functionalTypeEffects.keySet();
        symbol2 = new LinkedHashSet();
        PathAwareLambdaInvocationInfo pathAwareLambdaInvocationInfo = PathAwareLambdaInvocationInfo.Companion.getEMPTY();
        TraverseDirection traverseDirection = TraverseDirection.Forward;
        ControlFlowGraph controlFlowGraph = graph2;
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            FirBasedSymbol it = (FirBasedSymbol)element$iv;
            boolean bl5 = false;
            boolean bl6 = !leakedSymbols.containsKey(it);
            if (!bl6) continue;
            destination$iv.add(element$iv);
        }
        void var26_39 = destination$iv;
        Set set = (Set)var26_39;
        Map invocationData = CfgTraverserKt.collectDataForNode$default(controlFlowGraph, traverseDirection, pathAwareLambdaInvocationInfo, new InvocationDataCollector(set), false, 8, null);
        for (Map.Entry entry : functionalTypeEffects.entrySet()) {
            FirBasedSymbol symbol3 = (FirBasedSymbol)entry.getKey();
            ConeCallsEffectDeclaration effectDeclaration3 = (ConeCallsEffectDeclaration)entry.getValue();
            Iterable $this$forEach$iv = CfgUtilsKt.getPreviousCfgNodes(graph2.getExitNode());
            boolean $i$f$forEach = false;
            block6: for (Object element$iv : $this$forEach$iv) {
                CFGNode node = (CFGNode)element$iv;
                boolean bl7 = false;
                EventOccurrencesRange requiredRange = effectDeclaration3.getKind();
                PathAwareLambdaInvocationInfo pathAwareInfo = (PathAwareLambdaInvocationInfo)MapsKt.getValue((Map)invocationData, (Object)node);
                for (LambdaInvocationInfo info : (ImmutableCollection)pathAwareInfo.values()) {
                    if (!INSTANCE.investigate(info, symbol3, requiredRange, (FirContractDescriptionOwner)((Object)function2), reporter, context2)) continue;
                    continue block6;
                }
            }
        }
    }

    private final boolean investigate(LambdaInvocationInfo info, FirBasedSymbol<?> symbol2, EventOccurrencesRange requiredRange, FirContractDescriptionOwner function2, DiagnosticReporter reporter, CheckerContext context2) {
        EventOccurrencesRange foundRange;
        EventOccurrencesRange eventOccurrencesRange = (EventOccurrencesRange)((Object)info.get(symbol2));
        if (eventOccurrencesRange == null) {
            eventOccurrencesRange = EventOccurrencesRange.ZERO;
        }
        if (!requiredRange.contains(foundRange = eventOccurrencesRange)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)function2.getContractDescription().getSource(), FirErrors.INSTANCE.getWRONG_INVOCATION_KIND(), symbol2, (Object)requiredRange, (Object)foundRange, (DiagnosticContext)context2, null, 64, null);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFunctionalTypeRef(FirTypeRef $this$isFunctionalTypeRef, FirSession session2) {
        FirTypeRef firTypeRef = $this$isFunctionalTypeRef;
        Object object = firTypeRef;
        if (firTypeRef == null) return false;
        FirTypeRef $this$coneTypeSafe$iv = object;
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeKotlinType)) {
            return false;
        }
        object = coneKotlinType;
        if (coneKotlinType == null) return false;
        if (!InferenceUtilsKt.isBuiltinFunctionalType((ConeKotlinType)object, session2)) return false;
        return true;
    }

    private final ConeCallsEffectDeclaration getParameterCallsEffectDeclaration(FirContractDescription $this$getParameterCallsEffectDeclaration, int index2) {
        ConeEffectDeclaration coneEffectDeclaration;
        List<ConeEffectDeclaration> effects;
        FirContractDescription firContractDescription = $this$getParameterCallsEffectDeclaration;
        List<ConeEffectDeclaration> list2 = effects = firContractDescription != null ? ContractUtilsKt.getConeEffects(firContractDescription) : null;
        if (list2 != null) {
            Object v2;
            block3: {
                Iterable iterable = list2;
                for (Object t : iterable) {
                    ConeEffectDeclaration it = (ConeEffectDeclaration)t;
                    boolean bl = false;
                    if (!(it instanceof ConeCallsEffectDeclaration && ((ConeCallsEffectDeclaration)it).getValueParameterReference().getParameterIndex() == index2)) continue;
                    v2 = t;
                    break block3;
                }
                v2 = null;
            }
            coneEffectDeclaration = v2;
        } else {
            coneEffectDeclaration = null;
        }
        ConeEffectDeclaration callsEffect = coneEffectDeclaration;
        return callsEffect instanceof ConeCallsEffectDeclaration ? (ConeCallsEffectDeclaration)callsEffect : null;
    }

    private final EventOccurrencesRange getArgumentCallsEffect(FirFunctionCall $this$getArgumentCallsEffect, FirExpression arg) {
        EventOccurrencesRange eventOccurrencesRange;
        FirResolvedArgumentList resolvedArguments;
        FirFunctionSymbol functionSymbol;
        FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol($this$getArgumentCallsEffect);
        FirFunctionSymbol firFunctionSymbol = functionSymbol = firCallableSymbol instanceof FirFunctionSymbol ? (FirFunctionSymbol)firCallableSymbol : null;
        FirResolvedContractDescription contractDescription = firFunctionSymbol != null ? firFunctionSymbol.getResolvedContractDescription() : null;
        FirArgumentList firArgumentList = $this$getArgumentCallsEffect.getArgumentList();
        FirResolvedArgumentList firResolvedArgumentList = resolvedArguments = firArgumentList instanceof FirResolvedArgumentList ? (FirResolvedArgumentList)firArgumentList : null;
        if (functionSymbol != null && resolvedArguments != null) {
            FirValueParameter parameter = resolvedArguments.getMapping().get(arg);
            FirValueParameter firValueParameter = parameter;
            eventOccurrencesRange = this.getParameterCallsEffect(contractDescription, CollectionsKt.indexOf(functionSymbol.getValueParameterSymbols(), (Object)(firValueParameter != null ? firValueParameter.getSymbol() : null)));
        } else {
            eventOccurrencesRange = null;
        }
        return eventOccurrencesRange;
    }

    private final EventOccurrencesRange getParameterCallsEffect(FirContractDescription $this$getParameterCallsEffect, int index2) {
        ConeCallsEffectDeclaration coneCallsEffectDeclaration = this.getParameterCallsEffectDeclaration($this$getParameterCallsEffect, index2);
        return coneCallsEffectDeclaration != null ? coneCallsEffectDeclaration.getKind() : null;
    }

    private final boolean isInPlaceLambda(FirFunction $this$isInPlaceLambda) {
        return $this$isInPlaceLambda instanceof FirAnonymousFunction && ((FirAnonymousFunction)$this$isInPlaceLambda).isLambda() && ((FirAnonymousFunction)$this$isInPlaceLambda).getInvocationKind() != null;
    }

    private final FirReference toQualifiedReference(FirExpression $this$toQualifiedReference) {
        FirQualifiedAccess firQualifiedAccess = $this$toQualifiedReference instanceof FirQualifiedAccess ? (FirQualifiedAccess)((Object)$this$toQualifiedReference) : null;
        return firQualifiedAccess != null ? firQualifiedAccess.getCalleeReference() : null;
    }

    private final FirBasedSymbol<?> referenceToSymbol(FirReference reference) {
        FirReference firReference = reference;
        return firReference instanceof FirResolvedNamedReference ? ((FirResolvedNamedReference)reference).getResolvedSymbol() : (firReference instanceof FirThisReference ? ((FirThisReference)reference).getBoundSymbol() : null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\u001c\u0010\u0005\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0002\u0010\tJ2\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\b2\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0018H\u0086\b\u00f8\u0001\u0000J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u000eJ\u0006\u0010\u001b\u001a\u00020\u0013R\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u0005\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$IllegalScopeContext;", "", "functionalTypeSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "leakedSymbols", "", "", "Lorg/jetbrains/kotlin/KtSourceElement;", "(Ljava/util/Set;Ljava/util/Map;)V", "illegalScopeDepth", "", "Ljava/lang/Integer;", "inIllegalScope", "", "getInIllegalScope", "()Z", "scopeDepth", "checkExpressionForLeakedSymbols", "", "fir", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "source", "illegalUsage", "Lkotlin/Function0;", "enterScope", "legal", "exitScope", "checkers"})
    private static final class IllegalScopeContext {
        @NotNull
        private final Set<FirBasedSymbol<?>> functionalTypeSymbols;
        @NotNull
        private final Map<FirBasedSymbol<?>, List<KtSourceElement>> leakedSymbols;
        private int scopeDepth;
        @Nullable
        private Integer illegalScopeDepth;

        public IllegalScopeContext(@NotNull Set<? extends FirBasedSymbol<?>> functionalTypeSymbols, @NotNull Map<FirBasedSymbol<?>, List<KtSourceElement>> leakedSymbols) {
            Intrinsics.checkNotNullParameter(functionalTypeSymbols, (String)"functionalTypeSymbols");
            Intrinsics.checkNotNullParameter(leakedSymbols, (String)"leakedSymbols");
            this.functionalTypeSymbols = functionalTypeSymbols;
            this.leakedSymbols = leakedSymbols;
        }

        public final boolean getInIllegalScope() {
            return this.illegalScopeDepth != null;
        }

        public final void enterScope(boolean legal) {
            int n = this.scopeDepth;
            this.scopeDepth = n + 1;
            if (this.illegalScopeDepth == null && !legal) {
                this.illegalScopeDepth = this.scopeDepth;
            }
        }

        public final void exitScope() {
            Integer n = this.illegalScopeDepth;
            if (n != null && this.scopeDepth == n) {
                this.illegalScopeDepth = null;
            }
            int n2 = this.scopeDepth;
            this.scopeDepth = n2 + -1;
        }

        public final void checkExpressionForLeakedSymbols(@Nullable FirExpression fir, @Nullable KtSourceElement source, @NotNull Function0<Boolean> illegalUsage) {
            Intrinsics.checkNotNullParameter(illegalUsage, (String)"illegalUsage");
            boolean $i$f$checkExpressionForLeakedSymbols = false;
            FirBasedSymbol symbol2 = INSTANCE.referenceToSymbol(INSTANCE.toQualifiedReference(fir));
            if (symbol2 != null && this.functionalTypeSymbols.contains(symbol2) && (this.getInIllegalScope() || ((Boolean)illegalUsage.invoke()).booleanValue())) {
                Object object;
                Map $this$getOrPut$iv = this.leakedSymbols;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(symbol2);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(symbol2, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)object, source);
            }
        }

        public static /* synthetic */ void checkExpressionForLeakedSymbols$default(IllegalScopeContext this_, FirExpression fir, KtSourceElement source, Function0 illegalUsage, int n, Object object) {
            if ((n & 2) != 0) {
                FirExpression firExpression2 = fir;
                KtSourceElement ktSourceElement = source = firExpression2 != null ? firExpression2.getSource() : null;
            }
            if ((n & 4) != 0) {
                illegalUsage = checkExpressionForLeakedSymbols.1.INSTANCE;
            }
            Intrinsics.checkNotNullParameter((Object)illegalUsage, (String)"illegalUsage");
            boolean $i$f$checkExpressionForLeakedSymbols = false;
            FirBasedSymbol symbol2 = INSTANCE.referenceToSymbol(INSTANCE.toQualifiedReference(fir));
            if (symbol2 != null && this_.functionalTypeSymbols.contains(symbol2) && (this_.getInIllegalScope() || ((Boolean)illegalUsage.invoke()).booleanValue())) {
                Object object2;
                Map $this$getOrPut$iv = this_.leakedSymbols;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(symbol2);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(symbol2, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)object2, source);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\r\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\u0011\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u001c\u0010\u0015\u001a\u00020\u00022\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\u0017\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\u0019\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$CapturedLambdaFinder;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitor;", "", "Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$IllegalScopeContext;", "rootFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "(Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)V", "getRootFunction", "()Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "visitFunctionCallNode", "node", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FunctionCallNode;", "data", "visitFunctionEnterNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FunctionEnterNode;", "visitFunctionExitNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FunctionExitNode;", "visitInitBlockEnterNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/InitBlockEnterNode;", "visitInitBlockExitNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/InitBlockExitNode;", "visitNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "visitPropertyInitializerEnterNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/PropertyInitializerEnterNode;", "visitPropertyInitializerExitNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/PropertyInitializerExitNode;", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "visitVariableDeclarationNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "checkers"})
    private static final class CapturedLambdaFinder
    extends ControlFlowGraphVisitor<Unit, IllegalScopeContext> {
        @NotNull
        private final FirFunction rootFunction;

        public CapturedLambdaFinder(@NotNull FirFunction rootFunction) {
            Intrinsics.checkNotNullParameter((Object)rootFunction, (String)"rootFunction");
            this.rootFunction = rootFunction;
        }

        @NotNull
        public final FirFunction getRootFunction() {
            return this.rootFunction;
        }

        @Override
        public void visitNode(@NotNull CFGNode<?> node, @NotNull IllegalScopeContext data) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        }

        @Override
        public void visitFunctionEnterNode(@NotNull FunctionEnterNode node, @NotNull IllegalScopeContext data) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            data.enterScope(node.getFir() == this.rootFunction || INSTANCE.isInPlaceLambda(node.getFir()));
        }

        @Override
        public void visitFunctionExitNode(@NotNull FunctionExitNode node, @NotNull IllegalScopeContext data) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            data.exitScope();
        }

        @Override
        public void visitPropertyInitializerEnterNode(@NotNull PropertyInitializerEnterNode node, @NotNull IllegalScopeContext data) {
            FirExpression fir$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            data.enterScope(false);
            FirExpression firExpression2 = fir$iv = node.getFir().getInitializer();
            KtSourceElement source$iv = firExpression2 != null ? firExpression2.getSource() : null;
            boolean $i$f$checkExpressionForLeakedSymbols = false;
            FirBasedSymbol symbol$iv = INSTANCE.referenceToSymbol(INSTANCE.toQualifiedReference(fir$iv));
            if (symbol$iv != null && data.functionalTypeSymbols.contains(symbol$iv) && (data.getInIllegalScope() || false)) {
                Object object;
                Map $this$getOrPut$iv$iv = data.leakedSymbols;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(symbol$iv);
                if (value$iv$iv == null) {
                    boolean bl = false;
                    List answer$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv.put(symbol$iv, answer$iv$iv);
                    object = answer$iv$iv;
                } else {
                    object = value$iv$iv;
                }
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)object, source$iv);
            }
        }

        @Override
        public void visitPropertyInitializerExitNode(@NotNull PropertyInitializerExitNode node, @NotNull IllegalScopeContext data) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            data.exitScope();
        }

        @Override
        public void visitInitBlockEnterNode(@NotNull InitBlockEnterNode node, @NotNull IllegalScopeContext data) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            data.enterScope(false);
        }

        @Override
        public void visitInitBlockExitNode(@NotNull InitBlockExitNode node, @NotNull IllegalScopeContext data) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            data.exitScope();
        }

        @Override
        public void visitVariableAssignmentNode(@NotNull VariableAssignmentNode node, @NotNull IllegalScopeContext data) {
            block5: {
                Object object;
                FirBasedSymbol symbol$iv;
                KtSourceElement source$iv;
                block6: {
                    FirExpression fir$iv;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    FirExpression firExpression2 = fir$iv = node.getFir().getRValue();
                    source$iv = firExpression2 != null ? firExpression2.getSource() : null;
                    boolean $i$f$checkExpressionForLeakedSymbols = false;
                    symbol$iv = INSTANCE.referenceToSymbol(INSTANCE.toQualifiedReference(fir$iv));
                    if (symbol$iv == null || !data.functionalTypeSymbols.contains(symbol$iv)) break block5;
                    if (data.getInIllegalScope()) break block6;
                    boolean bl = false;
                    if (!true) break block5;
                }
                Map $this$getOrPut$iv$iv = data.leakedSymbols;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(symbol$iv);
                if (value$iv$iv == null) {
                    boolean bl = false;
                    List answer$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv.put(symbol$iv, answer$iv$iv);
                    object = answer$iv$iv;
                } else {
                    object = value$iv$iv;
                }
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)object, source$iv);
            }
        }

        @Override
        public void visitVariableDeclarationNode(@NotNull VariableDeclarationNode node, @NotNull IllegalScopeContext data) {
            block5: {
                Object object;
                FirBasedSymbol symbol$iv;
                KtSourceElement source$iv;
                block6: {
                    FirExpression fir$iv;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    FirExpression firExpression2 = fir$iv = node.getFir().getInitializer();
                    source$iv = firExpression2 != null ? firExpression2.getSource() : null;
                    boolean $i$f$checkExpressionForLeakedSymbols = false;
                    symbol$iv = INSTANCE.referenceToSymbol(INSTANCE.toQualifiedReference(fir$iv));
                    if (symbol$iv == null || !data.functionalTypeSymbols.contains(symbol$iv)) break block5;
                    if (data.getInIllegalScope()) break block6;
                    boolean bl = false;
                    if (!true) break block5;
                }
                Map $this$getOrPut$iv$iv = data.leakedSymbols;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(symbol$iv);
                if (value$iv$iv == null) {
                    boolean bl = false;
                    List answer$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv.put(symbol$iv, answer$iv$iv);
                    object = answer$iv$iv;
                } else {
                    object = value$iv$iv;
                }
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)object, source$iv);
            }
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public void visitFunctionCallNode(@NotNull FunctionCallNode node, @NotNull IllegalScopeContext data) {
            block12: {
                block13: {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    var4_3 = FirExpressionUtilKt.toResolvedCallableSymbol(node.getFir());
                    v0 = functionSymbol = var4_3 instanceof FirFunctionSymbol != false ? (FirFunctionSymbol)var4_3 : null;
                    contractDescription = v0 != null ? v0.getResolvedContractDescription() : null;
                    v1 = node.getFir().getExplicitReceiver();
                    if (v1 == null || (v1 = v1.getSource()) == null) {
                        v1 = node.getFir().getSource();
                    }
                    callSource = v1;
                    var6_6 = data;
                    fir$iv = node.getFir().getExplicitReceiver();
                    $i$f$checkExpressionForLeakedSymbols = false;
                    symbol$iv = FirCallsEffectAnalyzer.access$referenceToSymbol(FirCallsEffectAnalyzer.INSTANCE, FirCallsEffectAnalyzer.access$toQualifiedReference(FirCallsEffectAnalyzer.INSTANCE, fir$iv));
                    if (symbol$iv == null || !IllegalScopeContext.access$getFunctionalTypeSymbols$p((IllegalScopeContext)this_$iv).contains(symbol$iv)) break block12;
                    if (this_$iv.getInIllegalScope()) break block13;
                    $i$a$-checkExpressionForLeakedSymbols-FirCallsEffectAnalyzer$CapturedLambdaFinder$visitFunctionCallNode$1 = false;
                    v2 = functionSymbol;
                    if (v2 != null && (v2 = v2.getCallableId()) != null ? CallableIdUtilsKt.isInvoke((CallableId)v2) : false) ** GOTO lbl-1000
                    v3 = contractDescription;
                    if ((v3 != null ? FirCallsEffectAnalyzer.access$getParameterCallsEffect(FirCallsEffectAnalyzer.INSTANCE, v3, -1) : null) == null) {
                        v4 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v4 = false;
                    }
                    if (!v4) break block12;
                }
                $this$getOrPut$iv$iv = IllegalScopeContext.access$getLeakedSymbols$p((IllegalScopeContext)this_$iv);
                $i$f$getOrPut = false;
                value$iv$iv = $this$getOrPut$iv$iv.get(symbol$iv);
                if (value$iv$iv == null) {
                    $i$a$-getOrPut-FirCallsEffectAnalyzer$IllegalScopeContext$checkExpressionForLeakedSymbols$2$iv = false;
                    answer$iv$iv = new ArrayList<E>();
                    $this$getOrPut$iv$iv.put(symbol$iv, answer$iv$iv);
                    v5 /* !! */  = answer$iv$iv;
                } else {
                    v5 /* !! */  = value$iv$iv;
                }
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)v5 /* !! */ , callSource);
            }
            for (FirExpression arg : node.getFir().getArgumentList().getArguments()) {
                v6 = arg;
                source$iv = v6 != null ? v6.getSource() : null;
                $i$f$checkExpressionForLeakedSymbols = false;
                symbol$iv = FirCallsEffectAnalyzer.access$referenceToSymbol(FirCallsEffectAnalyzer.INSTANCE, FirCallsEffectAnalyzer.access$toQualifiedReference(FirCallsEffectAnalyzer.INSTANCE, arg));
                if (symbol$iv == null || !IllegalScopeContext.access$getFunctionalTypeSymbols$p(data).contains(symbol$iv)) continue;
                if (!data.getInIllegalScope()) {
                    $i$a$-checkExpressionForLeakedSymbols$default-FirCallsEffectAnalyzer$CapturedLambdaFinder$visitFunctionCallNode$2 = false;
                    if (!(FirCallsEffectAnalyzer.access$getArgumentCallsEffect(FirCallsEffectAnalyzer.INSTANCE, node.getFir(), arg) == null)) continue;
                }
                $this$getOrPut$iv$iv = IllegalScopeContext.access$getLeakedSymbols$p(data);
                $i$f$getOrPut = false;
                value$iv$iv = $this$getOrPut$iv$iv.get(symbol$iv);
                if (value$iv$iv == null) {
                    $i$a$-getOrPut-FirCallsEffectAnalyzer$IllegalScopeContext$checkExpressionForLeakedSymbols$2$iv = false;
                    answer$iv$iv = new ArrayList<E>();
                    $this$getOrPut$iv$iv.put(symbol$iv, answer$iv$iv);
                    v7 /* !! */  = answer$iv$iv;
                } else {
                    v7 /* !! */  = value$iv$iv;
                }
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)v7 /* !! */ , source$iv);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000f2\u0012\u0012\u0004\u0012\u00020\u0000\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001:\u0001\u000fB\u001f\u0012\u0018\b\u0002\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006R0\u0010\u0007\u001a\u001e\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00000\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00000\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$LambdaInvocationInfo;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/EventOccurrencesRangeInfo;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "map", "Lkotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "(Lkotlinx/collections/immutable/PersistentMap;)V", "constructor", "Lkotlin/Function1;", "getConstructor", "()Lkotlin/jvm/functions/Function1;", "empty", "Lkotlin/Function0;", "getEmpty", "()Lkotlin/jvm/functions/Function0;", "Companion", "checkers"})
    public static final class LambdaInvocationInfo
    extends EventOccurrencesRangeInfo<LambdaInvocationInfo, FirBasedSymbol<?>> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Function1<PersistentMap<FirBasedSymbol<?>, ? extends EventOccurrencesRange>, LambdaInvocationInfo> constructor;
        @NotNull
        private final Function0<LambdaInvocationInfo> empty;
        @NotNull
        private static final LambdaInvocationInfo EMPTY = new LambdaInvocationInfo(null, 1, null);

        public LambdaInvocationInfo(@NotNull PersistentMap<FirBasedSymbol<?>, ? extends EventOccurrencesRange> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            super(map);
            this.constructor = constructor.1.INSTANCE;
            this.empty = (Function0)new PropertyReference0(Companion){

                @NotNull
                public String getName() {
                    return "EMPTY";
                }

                @NotNull
                public KDeclarationContainer getOwner() {
                    return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class);
                }

                @NotNull
                public String getSignature() {
                    return "getEMPTY()Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$LambdaInvocationInfo;";
                }

                @Nullable
                public Object get() {
                    return ((Companion)this.receiver).getEMPTY();
                }
            };
        }

        public /* synthetic */ LambdaInvocationInfo(PersistentMap persistentMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                persistentMap = ExtensionsKt.persistentMapOf(new Pair[0]);
            }
            this(persistentMap);
        }

        @Override
        @NotNull
        protected Function1<PersistentMap<FirBasedSymbol<?>, ? extends EventOccurrencesRange>, LambdaInvocationInfo> getConstructor() {
            return this.constructor;
        }

        @Override
        @NotNull
        protected Function0<LambdaInvocationInfo> getEmpty() {
            return this.empty;
        }

        public LambdaInvocationInfo() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$LambdaInvocationInfo$Companion;", "", "()V", "EMPTY", "Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$LambdaInvocationInfo;", "getEMPTY", "()Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$LambdaInvocationInfo;", "checkers"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final LambdaInvocationInfo getEMPTY() {
                return EMPTY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000f2\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u001b\u0012\u0014\b\u0002\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\u0010\u0006R,\u0010\u0007\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0004\u0012\u00020\u00000\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00000\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$PathAwareLambdaInvocationInfo;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwareControlFlowInfo;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$LambdaInvocationInfo;", "map", "Lkotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeLabel;", "(Lkotlinx/collections/immutable/PersistentMap;)V", "constructor", "Lkotlin/Function1;", "getConstructor", "()Lkotlin/jvm/functions/Function1;", "empty", "Lkotlin/Function0;", "getEmpty", "()Lkotlin/jvm/functions/Function0;", "Companion", "checkers"})
    public static final class PathAwareLambdaInvocationInfo
    extends PathAwareControlFlowInfo<PathAwareLambdaInvocationInfo, LambdaInvocationInfo> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Function1<PersistentMap<EdgeLabel, LambdaInvocationInfo>, PathAwareLambdaInvocationInfo> constructor;
        @NotNull
        private final Function0<PathAwareLambdaInvocationInfo> empty;
        @NotNull
        private static final PathAwareLambdaInvocationInfo EMPTY;

        public PathAwareLambdaInvocationInfo(@NotNull PersistentMap<EdgeLabel, LambdaInvocationInfo> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            super(map);
            this.constructor = constructor.1.INSTANCE;
            this.empty = (Function0)new PropertyReference0(Companion){

                @NotNull
                public String getName() {
                    return "EMPTY";
                }

                @NotNull
                public KDeclarationContainer getOwner() {
                    return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class);
                }

                @NotNull
                public String getSignature() {
                    return "getEMPTY()Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$PathAwareLambdaInvocationInfo;";
                }

                @Nullable
                public Object get() {
                    return ((Companion)this.receiver).getEMPTY();
                }
            };
        }

        public /* synthetic */ PathAwareLambdaInvocationInfo(PersistentMap persistentMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                persistentMap = ExtensionsKt.persistentMapOf(new Pair[0]);
            }
            this(persistentMap);
        }

        @Override
        @NotNull
        protected Function1<PersistentMap<EdgeLabel, LambdaInvocationInfo>, PathAwareLambdaInvocationInfo> getConstructor() {
            return this.constructor;
        }

        @Override
        @NotNull
        protected Function0<PathAwareLambdaInvocationInfo> getEmpty() {
            return this.empty;
        }

        public PathAwareLambdaInvocationInfo() {
            this(null, 1, null);
        }

        static {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)NormalPath.INSTANCE, (Object)LambdaInvocationInfo.Companion.getEMPTY())};
            EMPTY = new PathAwareLambdaInvocationInfo(ExtensionsKt.persistentMapOf(pairArray));
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$PathAwareLambdaInvocationInfo$Companion;", "", "()V", "EMPTY", "Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$PathAwareLambdaInvocationInfo;", "getEMPTY", "()Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$PathAwareLambdaInvocationInfo;", "checkers"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final PathAwareLambdaInvocationInfo getEMPTY() {
                return EMPTY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u00040\u00030\u0001B\u0017\u0012\u0010\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\u00a2\u0006\u0002\u0010\tJ#\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\b\u0003\u0010\u0001J*\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0018\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u00040\u0003H\u0016J.\u0010\u0014\u001a\u00020\u00022\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00152\u0018\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u00040\u0003H\u0016J\u001c\u0010\u0016\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J%\u0010\u0019\u001a\u00020\u0002*\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u001bH\u0082\bR\u001b\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$InvocationDataCollector;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitor;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$PathAwareLambdaInvocationInfo;", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeLabel;", "functionalTypeSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "(Ljava/util/Set;)V", "getFunctionalTypeSymbols", "()Ljava/util/Set;", "collectDataForReference", "", "reference", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "visitFunctionCallNode", "node", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FunctionCallNode;", "data", "visitNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "addInvocationInfo", "range", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "checkReference", "rangeGetter", "Lkotlin/Function0;", "checkers"})
    private static final class InvocationDataCollector
    extends ControlFlowGraphVisitor<PathAwareLambdaInvocationInfo, Collection<? extends Pair<? extends EdgeLabel, ? extends PathAwareLambdaInvocationInfo>>> {
        @NotNull
        private final Set<FirBasedSymbol<?>> functionalTypeSymbols;

        public InvocationDataCollector(@NotNull Set<? extends FirBasedSymbol<?>> functionalTypeSymbols) {
            Intrinsics.checkNotNullParameter(functionalTypeSymbols, (String)"functionalTypeSymbols");
            this.functionalTypeSymbols = functionalTypeSymbols;
        }

        @NotNull
        public final Set<FirBasedSymbol<?>> getFunctionalTypeSymbols() {
            return this.functionalTypeSymbols;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public PathAwareLambdaInvocationInfo visitNode(@NotNull CFGNode<?> node, @NotNull Collection<? extends Pair<? extends EdgeLabel, PathAwareLambdaInvocationInfo>> data) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(node, (String)"node");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            if (data.isEmpty()) {
                return PathAwareLambdaInvocationInfo.Companion.getEMPTY();
            }
            Iterable $this$map$iv = data;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                EdgeLabel label = (EdgeLabel)pair.component1();
                PathAwareLambdaInvocationInfo info = (PathAwareLambdaInvocationInfo)pair.component2();
                collection.add((PathAwareLambdaInvocationInfo)info.applyLabel(node, label));
            }
            Iterable $this$reduce$iv = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void p1;
                PathAwareLambdaInvocationInfo $i$f$mapTo2 = (PathAwareLambdaInvocationInfo)iterator$iv.next();
                PathAwareLambdaInvocationInfo p0 = (PathAwareLambdaInvocationInfo)accumulator$iv;
                boolean bl = false;
                accumulator$iv = (PathAwareLambdaInvocationInfo)p0.merge((PathAwareControlFlowInfo)p1);
            }
            return (PathAwareLambdaInvocationInfo)accumulator$iv;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public PathAwareLambdaInvocationInfo visitFunctionCallNode(@NotNull FunctionCallNode node, @NotNull Collection<? extends Pair<? extends EdgeLabel, PathAwareLambdaInvocationInfo>> data) {
            PathAwareLambdaInvocationInfo pathAwareLambdaInvocationInfo;
            EventOccurrencesRange eventOccurrencesRange;
            void var13_13;
            void var14_12;
            void $this$checkReference$iv;
            FirReference firReference;
            void this_$iv;
            FirFunctionSymbol functionSymbol;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            PathAwareLambdaInvocationInfo dataForNode = this.visitNode((CFGNode)node, data);
            FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(node.getFir());
            FirFunctionSymbol firFunctionSymbol = functionSymbol = firCallableSymbol instanceof FirFunctionSymbol ? (FirFunctionSymbol)firCallableSymbol : null;
            FirResolvedContractDescription contractDescription = firFunctionSymbol != null ? firFunctionSymbol.getResolvedContractDescription() : null;
            InvocationDataCollector invocationDataCollector = this;
            PathAwareLambdaInvocationInfo pathAwareLambdaInvocationInfo2 = dataForNode;
            Object reference$iv = INSTANCE.toQualifiedReference(node.getFir().getExplicitReceiver());
            boolean $i$f$checkReference2 = false;
            if (super.collectDataForReference((FirReference)reference$iv)) {
                EventOccurrencesRange eventOccurrencesRange2;
                firReference = reference$iv;
                var14_12 = $this$checkReference$iv;
                var13_13 = this_$iv;
                boolean bl = false;
                Object object = functionSymbol;
                boolean bl2 = object != null && (object = ((FirFunctionSymbol)object).getCallableId()) != null ? CallableIdUtilsKt.isInvoke((CallableId)object) : false;
                if (bl2) {
                    eventOccurrencesRange2 = EventOccurrencesRange.EXACTLY_ONCE;
                } else {
                    eventOccurrencesRange2 = INSTANCE.getParameterCallsEffect(contractDescription, -1);
                    if (eventOccurrencesRange2 == null) {
                        eventOccurrencesRange2 = EventOccurrencesRange.UNKNOWN;
                    }
                }
                eventOccurrencesRange = eventOccurrencesRange2;
                pathAwareLambdaInvocationInfo = super.addInvocationInfo((PathAwareLambdaInvocationInfo)var14_12, firReference, eventOccurrencesRange);
            } else {
                pathAwareLambdaInvocationInfo = $this$checkReference$iv;
            }
            dataForNode = pathAwareLambdaInvocationInfo;
            for (FirExpression arg : node.getFir().getArgumentList().getArguments()) {
                PathAwareLambdaInvocationInfo pathAwareLambdaInvocationInfo3;
                void $this$checkReference$iv2;
                void this_$iv2;
                reference$iv = this;
                PathAwareLambdaInvocationInfo $i$f$checkReference2 = dataForNode;
                FirReference reference$iv2 = INSTANCE.toQualifiedReference(arg);
                boolean $i$f$checkReference3 = false;
                if (super.collectDataForReference(reference$iv2)) {
                    firReference = reference$iv2;
                    var14_12 = $this$checkReference$iv2;
                    var13_13 = this_$iv2;
                    boolean bl = false;
                    EventOccurrencesRange eventOccurrencesRange3 = INSTANCE.getArgumentCallsEffect(node.getFir(), arg);
                    if (eventOccurrencesRange3 == null) {
                        eventOccurrencesRange3 = EventOccurrencesRange.ZERO;
                    }
                    eventOccurrencesRange = eventOccurrencesRange3;
                    pathAwareLambdaInvocationInfo3 = super.addInvocationInfo((PathAwareLambdaInvocationInfo)var14_12, firReference, eventOccurrencesRange);
                } else {
                    pathAwareLambdaInvocationInfo3 = $this$checkReference$iv2;
                }
                dataForNode = pathAwareLambdaInvocationInfo3;
            }
            return dataForNode;
        }

        private final boolean collectDataForReference(FirReference reference) {
            return reference != null && CollectionsKt.contains((Iterable)this.functionalTypeSymbols, (Object)INSTANCE.referenceToSymbol(reference));
        }

        private final PathAwareLambdaInvocationInfo addInvocationInfo(PathAwareLambdaInvocationInfo $this$addInvocationInfo, FirReference reference, EventOccurrencesRange range) {
            FirBasedSymbol symbol2 = INSTANCE.referenceToSymbol(reference);
            return symbol2 != null ? (PathAwareLambdaInvocationInfo)PropertyInitializationInfoCollectorKt.addRange((PathAwareControlFlowInfo)$this$addInvocationInfo, symbol2, range, addInvocationInfo.1.INSTANCE) : $this$addInvocationInfo;
        }
    }
}

