/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.graph.internal;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.internal.DefaultDependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=DependencyGraphBuilder.class, hint="maven2")
public class Maven2DependencyGraphBuilder
implements DependencyGraphBuilder {
    @Requirement
    private DependencyTreeBuilder treeBuilder;

    public DependencyNode buildDependencyGraph(MavenProject project, ArtifactFilter filter) throws DependencyGraphBuilderException {
        try {
            return this.buildDependencyNode(null, this.treeBuilder.buildDependencyTree(project), filter);
        }
        catch (DependencyTreeBuilderException e) {
            throw new DependencyGraphBuilderException(e.getMessage(), e);
        }
    }

    private DependencyNode buildDependencyNode(DependencyNode parent, org.apache.maven.shared.dependency.tree.DependencyNode node, ArtifactFilter filter) {
        String versionSelectedFromRange = null;
        if (node.getVersionSelectedFromRange() != null) {
            versionSelectedFromRange = node.getVersionSelectedFromRange().toString();
        }
        DefaultDependencyNode current = new DefaultDependencyNode(parent, node.getArtifact(), node.getPremanagedVersion(), node.getPremanagedScope(), versionSelectedFromRange);
        ArrayList<DependencyNode> nodes = new ArrayList<DependencyNode>(node.getChildren().size());
        for (org.apache.maven.shared.dependency.tree.DependencyNode child : node.getChildren()) {
            if (child.getState() != 0 || filter != null && !filter.include(child.getArtifact())) continue;
            nodes.add(this.buildDependencyNode(current, child, filter));
        }
        current.setChildren(Collections.unmodifiableList(nodes));
        return current;
    }
}

