/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.repositories;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.AbstractReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;
import org.sonatype.nexus.rest.model.RepositoryBaseResource;
import org.sonatype.nexus.rest.model.RepositoryGroupResource;
import org.sonatype.nexus.rest.model.RepositoryProxyResource;
import org.sonatype.nexus.rest.model.RepositoryResource;
import org.sonatype.nexus.rest.model.RepositoryShadowResource;
import org.sonatype.plexus.rest.xstream.LookAheadStreamReader;

public class RepositoryBaseResourceConverter
extends AbstractReflectionConverter {
    public static final String REPO_TYPE_HOSTED = "hosted";
    public static final String REPO_TYPE_PROXIED = "proxy";
    public static final String REPO_TYPE_VIRTUAL = "virtual";
    public static final String REPO_TYPE_GROUP = "group";

    public RepositoryBaseResourceConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        super(mapper, reflectionProvider);
    }

    public boolean canConvert(Class type) {
        return RepositoryBaseResource.class.equals((Object)type);
    }

    protected Object instantiateNewInstance(HierarchicalStreamReader reader, UnmarshallingContext context) {
        if (LookAheadStreamReader.class.isAssignableFrom(reader.getClass()) || LookAheadStreamReader.class.isAssignableFrom(reader.underlyingReader().getClass())) {
            String repoType = null;
            repoType = LookAheadStreamReader.class.isAssignableFrom(reader.getClass()) ? ((LookAheadStreamReader)reader).getFieldValue("repoType") : ((LookAheadStreamReader)reader.underlyingReader()).getFieldValue("repoType");
            if (REPO_TYPE_VIRTUAL.equals(repoType)) {
                return new RepositoryShadowResource();
            }
            if (REPO_TYPE_PROXIED.equals(repoType)) {
                return new RepositoryProxyResource();
            }
            if (REPO_TYPE_HOSTED.equals(repoType)) {
                return new RepositoryResource();
            }
            if (REPO_TYPE_GROUP.equals(repoType)) {
                return new RepositoryGroupResource();
            }
            return super.instantiateNewInstance(reader, context);
        }
        return super.instantiateNewInstance(reader, context);
    }
}

