/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.srtp;

public class SrtpPolicy {
    public static final int NULL_ENCRYPTION = 0;
    public static final int AESCM_ENCRYPTION = 1;
    public static final int AESGCM_ENCRYPTION = 5;
    public static final int TWOFISH_ENCRYPTION = 3;
    public static final int AESF8_ENCRYPTION = 2;
    public static final int TWOFISHF8_ENCRYPTION = 4;
    public static final int NULL_AUTHENTICATION = 0;
    public static final int HMACSHA1_AUTHENTICATION = 1;
    public static final int SKEIN_AUTHENTICATION = 2;
    private int encType;
    private int encKeyLength;
    private int authType;
    private int authKeyLength;
    private int authTagLength;
    private int saltKeyLength;
    private boolean sendReplayEnabled = true;
    private boolean receiveReplayEnabled = true;

    public SrtpPolicy(int encType, int encKeyLength, int authType, int authKeyLength, int authTagLength, int saltKeyLength) {
        this.encType = encType;
        this.encKeyLength = encKeyLength;
        this.authType = authType;
        this.authKeyLength = authKeyLength;
        this.authTagLength = authTagLength;
        this.saltKeyLength = saltKeyLength;
    }

    public int getAuthKeyLength() {
        return this.authKeyLength;
    }

    public void setAuthKeyLength(int authKeyLength) {
        this.authKeyLength = authKeyLength;
    }

    public int getAuthTagLength() {
        return this.authTagLength;
    }

    public void setAuthTagLength(int authTagLength) {
        this.authTagLength = authTagLength;
    }

    public int getAuthType() {
        return this.authType;
    }

    public void setAuthType(int authType) {
        this.authType = authType;
    }

    public int getEncKeyLength() {
        return this.encKeyLength;
    }

    public void setEncKeyLength(int encKeyLength) {
        this.encKeyLength = encKeyLength;
    }

    public int getEncType() {
        return this.encType;
    }

    public void setEncType(int encType) {
        this.encType = encType;
    }

    public int getSaltKeyLength() {
        return this.saltKeyLength;
    }

    public void setSaltKeyLength(int keyLength) {
        this.saltKeyLength = keyLength;
    }

    public void setSendReplayEnabled(boolean enabled) {
        this.sendReplayEnabled = enabled;
    }

    public boolean isSendReplayEnabled() {
        return this.sendReplayEnabled;
    }

    public boolean isSendReplayDisabled() {
        return !this.sendReplayEnabled;
    }

    public void setReceiveReplayEnabled(boolean enabled) {
        this.receiveReplayEnabled = enabled;
    }

    public boolean isReceiveReplayEnabled() {
        return this.receiveReplayEnabled;
    }

    public boolean isReceiveReplayDisabled() {
        return !this.receiveReplayEnabled;
    }
}

