/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.core.JavaPsiBundle;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.TypeAnnotationProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;

public class TypeCompatibilityConstraint
implements ConstraintFormula {
    private PsiType myT;
    private PsiType myS;

    public TypeCompatibilityConstraint(@NotNull PsiType t, @NotNull PsiType s) {
        if (t == null) {
            TypeCompatibilityConstraint.$$$reportNull$$$0(0);
        }
        if (s == null) {
            TypeCompatibilityConstraint.$$$reportNull$$$0(1);
        }
        this.myT = t.annotate(TypeAnnotationProvider.EMPTY);
        this.myS = s.annotate(TypeAnnotationProvider.EMPTY);
    }

    @Override
    public boolean reduce(InferenceSession session2, List<? super ConstraintFormula> constraints) {
        PsiClassType boxedType;
        if (session2.isProperType(this.myT) && session2.isProperType(this.myS)) {
            boolean assignable = TypeConversionUtil.isAssignable(this.myT, this.myS);
            if (!assignable) {
                session2.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.not.convertible", session2.getPresentableText(this.myS), session2.getPresentableText(this.myT)));
            }
            return assignable;
        }
        if (this.myS instanceof PsiPrimitiveType && !PsiType.VOID.equals(this.myS) && (boxedType = ((PsiPrimitiveType)this.myS).getBoxedType(session2.getManager(), session2.getScope())) != null) {
            constraints.add(new TypeCompatibilityConstraint(this.myT, boxedType));
            return true;
        }
        if (this.myT instanceof PsiPrimitiveType && !PsiType.VOID.equals(this.myT) && (boxedType = ((PsiPrimitiveType)this.myT).getBoxedType(session2.getManager(), session2.getScope())) != null) {
            constraints.add(new TypeEqualityConstraint(boxedType, this.myS));
            return true;
        }
        if (TypeCompatibilityConstraint.isUncheckedConversion(this.myT, this.myS, session2)) {
            session2.setErased();
            return true;
        }
        constraints.add(new StrictSubtypingConstraint(this.myT, this.myS));
        return true;
    }

    public static boolean isUncheckedConversion(PsiType t, PsiType s, InferenceSession session2) {
        if (t instanceof PsiClassType && !((PsiClassType)t).isRaw()) {
            PsiClassType.ClassResolveResult tResult = ((PsiClassType)t).resolveGenerics();
            PsiClass tClass = tResult.getElement();
            if (s instanceof PsiClassType && TypeCompatibilityConstraint.isUncheckedConversion(tClass, (PsiClassType)s, session2)) {
                return true;
            }
            if (s instanceof PsiIntersectionType) {
                for (PsiType conjunct : ((PsiIntersectionType)s).getConjuncts()) {
                    if (!(conjunct instanceof PsiClassType) || !TypeCompatibilityConstraint.isUncheckedConversion(tClass, (PsiClassType)conjunct, session2)) continue;
                    return true;
                }
            }
        } else if (t instanceof PsiArrayType && s != null && t.getArrayDimensions() == s.getArrayDimensions()) {
            return TypeCompatibilityConstraint.isUncheckedConversion(t.getDeepComponentType(), s.getDeepComponentType(), session2);
        }
        return false;
    }

    private static boolean isUncheckedConversion(PsiClass tClass, PsiClassType s, InferenceSession session2) {
        PsiClassType.ClassResolveResult sResult = s.resolveGenerics();
        PsiClass sClass = sResult.getElement();
        if (tClass != null && sClass != null && !(sClass instanceof InferenceVariable)) {
            PsiSubstitutor sSubstitutor = TypeConversionUtil.getClassSubstitutor(tClass, sClass, sResult.getSubstitutor());
            if (sSubstitutor != null) {
                if (PsiUtil.isRawSubstitutor(tClass, sSubstitutor)) {
                    return true;
                }
            } else if (tClass instanceof InferenceVariable && s.isRaw()) {
                for (PsiType bound : ((InferenceVariable)tClass).getBounds(InferenceBound.UPPER)) {
                    PsiClass boundClass;
                    if (session2.isProperType(bound) || !InheritanceUtil.isInheritorOrSelf(boundClass = PsiUtil.resolveClassInClassTypeOnly(bound), sClass, true)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void apply(PsiSubstitutor substitutor2, boolean cache2) {
        this.myT = substitutor2.substitute(this.myT);
        this.myS = substitutor2.substitute(this.myS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeCompatibilityConstraint that = (TypeCompatibilityConstraint)o;
        if (!this.myS.equals(that.myS)) {
            return false;
        }
        return this.myT.equals(that.myT);
    }

    public int hashCode() {
        int result2 = this.myT.hashCode();
        result2 = 31 * result2 + this.myS.hashCode();
        return result2;
    }

    public String toString() {
        return this.myS.getPresentableText() + " -> " + this.myT.getPresentableText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "t";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "s";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/constraints/TypeCompatibilityConstraint";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

