/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.classpathDiff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.classpathDiff.ChangeSet;
import org.jetbrains.kotlin.incremental.classpathDiff.ClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathChangesComputerKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J4\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u000eJ(\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/incremental/classpathDiff/ImpactAnalysis;", "", "()V", "computeImpactedSet", "Lorg/jetbrains/kotlin/incremental/classpathDiff/ChangeSet;", "changes", "previousClassSnapshots", "", "Lorg/jetbrains/kotlin/incremental/classpathDiff/ClassSnapshot;", "findImpactedClassesInclusive", "", "Lorg/jetbrains/kotlin/name/ClassId;", "classIds", "impactedClassesResolver", "Lkotlin/Function1;", "getClassIdToSubclassesMap", "", "classSnapshots", "incremental-compilation-impl"})
public final class ImpactAnalysis {
    @NotNull
    public static final ImpactAnalysis INSTANCE = new ImpactAnalysis();

    private ImpactAnalysis() {
    }

    @NotNull
    public final ChangeSet computeImpactedSet(@NotNull ChangeSet changes, @NotNull List<? extends ClassSnapshot> previousClassSnapshots) {
        Set<String> changedClassMembers;
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        Intrinsics.checkNotNullParameter(previousClassSnapshots, (String)"previousClassSnapshots");
        Map<ClassId, Set<ClassId>> classIdToSubclasses = this.getClassIdToSubclassesMap(previousClassSnapshots);
        Function1 impactedClassesResolver2 = (Function1)new Function1<ClassId, Set<? extends ClassId>>(classIdToSubclasses){
            final /* synthetic */ Map<ClassId, Set<ClassId>> $classIdToSubclasses;
            {
                this.$classIdToSubclasses = $classIdToSubclasses;
                super(1);
            }

            @NotNull
            public final Set<ClassId> invoke(@NotNull ClassId classId) {
                Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
                Set set = this.$classIdToSubclasses.get(classId);
                if (set == null) {
                    set = SetsKt.emptySet();
                }
                return set;
            }
        };
        ChangeSet.Collector $this$computeImpactedSet_u24lambda_u2d1 = new ChangeSet.Collector();
        boolean bl = false;
        $this$computeImpactedSet_u24lambda_u2d1.addChangedClasses((Collection<ClassId>)INSTANCE.findImpactedClassesInclusive(changes.getChangedClasses(), (Function1<? super ClassId, ? extends Set<ClassId>>)impactedClassesResolver2));
        for (Map.Entry<ClassId, Set<String>> entry : changes.getChangedClassMembers().entrySet()) {
            ClassId changedClass = entry.getKey();
            changedClassMembers = entry.getValue();
            Iterable $this$forEach$iv = INSTANCE.findImpactedClassesInclusive(SetsKt.setOf((Object)changedClass), (Function1<? super ClassId, ? extends Set<ClassId>>)impactedClassesResolver2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ClassId it = (ClassId)element$iv;
                boolean bl2 = false;
                $this$computeImpactedSet_u24lambda_u2d1.addChangedClassMembers(it, (Collection<String>)changedClassMembers);
            }
        }
        for (Map.Entry<Object, Set<String>> entry : changes.getChangedTopLevelMembers().entrySet()) {
            FqName changedPackage = (FqName)entry.getKey();
            changedClassMembers = entry.getValue();
            $this$computeImpactedSet_u24lambda_u2d1.addChangedTopLevelMembers(changedPackage, (Collection<String>)changedClassMembers);
        }
        return $this$computeImpactedSet_u24lambda_u2d1.getChanges();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<ClassId, Set<ClassId>> getClassIdToSubclassesMap(List<? extends ClassSnapshot> classSnapshots) {
        void $this$associateByTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = classSnapshots;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Iterator it;
            ClassSnapshot classSnapshot = (ClassSnapshot)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(ClasspathChangesComputerKt.getClassId((ClassSnapshot)((Object)it)));
        }
        Set classIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$associateBy$iv = classIds;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable $i$f$mapTo22 = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            ClassId classId = (ClassId)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.put(JvmClassName.byClassId((ClassId)it), element$iv$iv);
        }
        Map classNameToClassId = destination$iv$iv2;
        Function1 classNameToClassIdResolver2 = (Function1)new Function1<JvmClassName, ClassId>((Map<JvmClassName, ClassId>)classNameToClassId){
            final /* synthetic */ Map<JvmClassName, ClassId> $classNameToClassId;
            {
                this.$classNameToClassId = $classNameToClassId;
                super(1);
            }

            @Nullable
            public final ClassId invoke(@NotNull JvmClassName className2) {
                Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
                return this.$classNameToClassId.get(className2);
            }
        };
        Map classIdToSubclasses = new LinkedHashMap();
        Iterable $this$forEach$iv = classSnapshots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClassSnapshot classSnapshot = (ClassSnapshot)element$iv;
            boolean bl = false;
            ClassId classId = ClasspathChangesComputerKt.getClassId(classSnapshot);
            Iterable $this$forEach$iv2 = ClasspathChangesComputerKt.getSupertypes(classSnapshot, (Function1<? super JvmClassName, ClassId>)classNameToClassIdResolver2);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ClassId supertype2 = (ClassId)element$iv2;
                boolean bl2 = false;
                if (!classIds.contains(supertype2)) continue;
                classIdToSubclasses.computeIfAbsent(supertype2, ImpactAnalysis::getClassIdToSubclassesMap$lambda-6$lambda-5$lambda-4).add(classId);
            }
        }
        return classIdToSubclasses;
    }

    @NotNull
    public final Set<ClassId> findImpactedClassesInclusive(@NotNull Set<ClassId> classIds, @NotNull Function1<? super ClassId, ? extends Set<ClassId>> impactedClassesResolver2) {
        Intrinsics.checkNotNullParameter(classIds, (String)"classIds");
        Intrinsics.checkNotNullParameter(impactedClassesResolver2, (String)"impactedClassesResolver");
        Set visitedClasses = new LinkedHashSet();
        Set toVisitClasses = CollectionsKt.toMutableSet((Iterable)classIds);
        while (!((Collection)toVisitClasses).isEmpty()) {
            Set nextToVisit = new LinkedHashSet();
            Iterable $this$forEach$iv = toVisitClasses;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ClassId it = (ClassId)element$iv;
                boolean bl = false;
                nextToVisit.addAll((Collection)impactedClassesResolver2.invoke((Object)it));
            }
            visitedClasses.addAll(toVisitClasses);
            toVisitClasses.clear();
            toVisitClasses.addAll(SetsKt.minus((Set)nextToVisit, (Iterable)visitedClasses));
        }
        return visitedClasses;
    }

    private static final Set getClassIdToSubclassesMap$lambda-6$lambda-5$lambda-4(ClassId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }
}

