/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IcmpIdentifiablePacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

public final class IcmpV4InformationRequestPacket
extends IcmpIdentifiablePacket {
    private static final long serialVersionUID = 840757374756962085L;
    private final IcmpV4InformationRequestHeader header;

    public static IcmpV4InformationRequestPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IcmpV4InformationRequestPacket(rawData, offset, length);
    }

    private IcmpV4InformationRequestPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new IcmpV4InformationRequestHeader(rawData, offset, length);
    }

    private IcmpV4InformationRequestPacket(Builder builder) {
        super(builder);
        this.header = new IcmpV4InformationRequestHeader(builder);
    }

    @Override
    public IcmpV4InformationRequestHeader getHeader() {
        return this.header;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class IcmpV4InformationRequestHeader
    extends IcmpIdentifiablePacket.IcmpIdentifiableHeader {
        private static final long serialVersionUID = 5499456155277110739L;

        private IcmpV4InformationRequestHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            super(rawData, offset, length);
        }

        private IcmpV4InformationRequestHeader(Builder builder) {
            super(builder);
        }

        @Override
        protected String getHeaderName() {
            return "ICMPv4 Information Request Header";
        }
    }

    public static final class Builder
    extends IcmpIdentifiablePacket.Builder {
        public Builder() {
        }

        private Builder(IcmpV4InformationRequestPacket packet) {
            super(packet);
        }

        @Override
        public Builder identifier(short identifier) {
            super.identifier(identifier);
            return this;
        }

        @Override
        public Builder sequenceNumber(short sequenceNumber) {
            super.sequenceNumber(sequenceNumber);
            return this;
        }

        @Override
        public IcmpV4InformationRequestPacket build() {
            return new IcmpV4InformationRequestPacket(this);
        }
    }
}

