/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesLoader {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesLoader.class);
    private final String resourceName;
    private final boolean systemPropertiesOverPropertiesFile;
    private final boolean caching;
    private final Properties prop = new Properties();
    private final Map<String, Object> cache = new HashMap<String, Object>();

    public PropertiesLoader(String resourceName, boolean systemPropertiesOverPropertiesFile, boolean caching) {
        this.resourceName = resourceName;
        this.systemPropertiesOverPropertiesFile = systemPropertiesOverPropertiesFile;
        this.caching = caching;
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(resourceName);
        if (in == null) {
            logger.warn("{} not found.", (Object)resourceName);
            return;
        }
        try {
            this.prop.load(in);
        }
        catch (IOException e) {
            logger.error("Exception follows", (Throwable)e);
        }
    }

    public final String getResourceName() {
        return this.resourceName;
    }

    public final Properties getProp() {
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)this.prop);
        return copy;
    }

    public final boolean isSystemPropertiesOverPropertiesFile() {
        return this.systemPropertiesOverPropertiesFile;
    }

    public final boolean isCaching() {
        return this.caching;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String key, String defaultValue) {
        Map<String, Object> map = this.cache;
        synchronized (map) {
            if (this.caching && this.cache.containsKey(key)) {
                String cacheValue = (String)this.cache.get(key);
                logger.debug("[{}] Got {} from cache by {}", new Object[]{this.resourceName, cacheValue, key});
                return cacheValue;
            }
            String value = null;
            if (this.systemPropertiesOverPropertiesFile) {
                value = System.getProperty(key);
            }
            if (value != null) {
                logger.info("[System properties] Got {} by {}", (Object)value, (Object)key);
            } else {
                value = this.prop.getProperty(key);
                if (value != null) {
                    logger.info("[{}] Got {} by {}", new Object[]{this.resourceName, value, key});
                } else {
                    logger.info("[{}] Could not get value by {}, use default value: {}", new Object[]{this.resourceName, key, defaultValue});
                    value = defaultValue;
                }
            }
            if (this.caching) {
                this.cache.put(key, value);
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getInteger(String key, Integer defaultValue) {
        Map<String, Object> map = this.cache;
        synchronized (map) {
            if (this.caching && this.cache.containsKey(key)) {
                Integer cacheValue = (Integer)this.cache.get(key);
                logger.debug("[{}] Got {} from cache by {}", new Object[]{this.resourceName, cacheValue, key});
                return cacheValue;
            }
            Integer value = null;
            if (this.systemPropertiesOverPropertiesFile) {
                value = Integer.getInteger(key);
            }
            if (value != null) {
                logger.info("[System properties] Got {} by {}", (Object)value, (Object)key);
            } else {
                String strValue = this.prop.getProperty(key);
                if (strValue != null) {
                    try {
                        value = Integer.decode(strValue);
                        logger.info("[{}] Got {} by {}", new Object[]{this.resourceName, value, key});
                    }
                    catch (NumberFormatException e) {
                        logger.warn("[{}] {} is invalid for {}, use default value: {}", new Object[]{this.resourceName, strValue, key, defaultValue});
                        value = defaultValue;
                    }
                } else {
                    logger.info("[{}] Could not get value by {}, use default value: {}", new Object[]{this.resourceName, key, defaultValue});
                    value = defaultValue;
                }
            }
            if (this.caching) {
                this.cache.put(key, value);
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getBoolean(String key, Boolean defaultValue) {
        Map<String, Object> map = this.cache;
        synchronized (map) {
            String strValue;
            if (this.caching && this.cache.containsKey(key)) {
                Boolean cacheValue = (Boolean)this.cache.get(key);
                logger.debug("[{}] Got {} from cache by {}", new Object[]{this.resourceName, cacheValue, key});
                return cacheValue;
            }
            Boolean value = null;
            if (this.systemPropertiesOverPropertiesFile && (strValue = System.getProperty(key)) != null) {
                value = Boolean.valueOf(strValue);
                logger.info("[System properties] Got \"{}\" which means {} by {}", new Object[]{strValue, value, key});
            }
            if (value == null) {
                strValue = this.prop.getProperty(key);
                if (strValue != null) {
                    value = Boolean.valueOf(strValue);
                    logger.info("[{}] Got\"{}\" which means {} by {}", new Object[]{this.resourceName, strValue, value, key});
                } else {
                    logger.info("[{}] Could not get value by {}, use default value: {}", new Object[]{this.resourceName, key, defaultValue});
                    value = defaultValue;
                }
            }
            if (this.caching) {
                this.cache.put(key, value);
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Class<? extends T> getClass(String key, Class<? extends T> defaultValue) {
        Map<String, Object> map = this.cache;
        synchronized (map) {
            Class<?> clazz;
            String strValue;
            if (this.caching && this.cache.containsKey(key)) {
                Class cacheValue = (Class)this.cache.get(key);
                logger.debug("[{}] Got {} from cache by {}", new Object[]{this.resourceName, cacheValue, key});
                return cacheValue;
            }
            Class<Object> value = null;
            if (this.systemPropertiesOverPropertiesFile && (strValue = System.getProperty(key)) != null) {
                try {
                    value = clazz = Class.forName(strValue);
                    logger.info("[System properties] Got {} by {}", (Object)strValue, (Object)key);
                }
                catch (ClassNotFoundException e) {
                    logger.error("[System properties] Got Invalid value: {} by {}, ignore it.", (Object)strValue, (Object)key);
                }
                catch (ClassCastException e) {
                    logger.error("[System properties] Got Invalid value: {} by {}, ignore it.", (Object)strValue, (Object)key);
                }
            }
            if (value == null) {
                strValue = this.prop.getProperty(key);
                if (strValue != null) {
                    try {
                        value = clazz = Class.forName(strValue);
                        logger.info("[{}] Got {} by {}", new Object[]{this.resourceName, strValue, key});
                    }
                    catch (ClassNotFoundException e) {
                        logger.warn("[{}] {} is invalid for {}, use default value: {}", new Object[]{this.resourceName, strValue, key, defaultValue});
                        value = defaultValue;
                    }
                    catch (ClassCastException e) {
                        logger.warn("[{}] {} is invalid for {}, use default value: {}", new Object[]{this.resourceName, strValue, key, defaultValue});
                        value = defaultValue;
                    }
                } else {
                    logger.info("[{}] Could not get value by {}, use default value: {}", new Object[]{this.resourceName, key, defaultValue});
                    value = defaultValue;
                }
            }
            if (this.caching) {
                this.cache.put(key, value);
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getInetAddress(String key, InetAddress defaultValue) {
        Map<String, Object> map = this.cache;
        synchronized (map) {
            String strValue;
            if (this.caching && this.cache.containsKey(key)) {
                InetAddress cacheValue = (InetAddress)this.cache.get(key);
                logger.debug("[{}] Got {} from cache by {}", new Object[]{this.resourceName, cacheValue, key});
                return cacheValue;
            }
            InetAddress value = null;
            if (this.systemPropertiesOverPropertiesFile && (strValue = System.getProperty(key)) != null) {
                try {
                    value = InetAddress.getByName(strValue);
                    logger.info("[System properties] Got \"{}\" which means {} by {}", new Object[]{strValue, value, key});
                }
                catch (UnknownHostException e) {
                    logger.error("[System properties] Got Invalid value: {} by {}, ignore it.", (Object)strValue, (Object)key);
                }
            }
            if (value == null) {
                strValue = this.prop.getProperty(key);
                if (strValue != null) {
                    try {
                        value = InetAddress.getByName(strValue);
                        logger.info("[{}] Got\"{}\" which means {} by {}", new Object[]{this.resourceName, strValue, value, key});
                    }
                    catch (UnknownHostException e) {
                        logger.warn("[{}] {} is invalid for {}, use default value: {}", new Object[]{this.resourceName, strValue, key, defaultValue});
                        value = defaultValue;
                    }
                } else {
                    logger.info("[{}] Could not get value by {}, use default value: {}", new Object[]{this.resourceName, key, defaultValue});
                    value = defaultValue;
                }
            }
            if (this.caching) {
                this.cache.put(key, value);
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getIntArray(String key, int[] defaultValue) {
        Map<String, Object> map = this.cache;
        synchronized (map) {
            int i;
            String[] strInts;
            String csv;
            if (this.caching && this.cache.containsKey(key)) {
                int[] cacheValue = (int[])this.cache.get(key);
                logger.debug("[{}] Got {} from cache by {}", new Object[]{this.resourceName, Arrays.toString(cacheValue), key});
                return (int[])cacheValue.clone();
            }
            int[] value = null;
            if (this.systemPropertiesOverPropertiesFile && (csv = System.getProperty(key)) != null) {
                try {
                    strInts = csv.split(",");
                    value = new int[strInts.length];
                    for (i = 0; i < strInts.length; ++i) {
                        value[i] = Integer.parseInt(strInts[i]);
                    }
                    logger.info("[System properties] Got \"{}\" which means {} by {}", new Object[]{csv, Arrays.toString(value), key});
                }
                catch (NumberFormatException e) {
                    logger.error("[System properties] Got Invalid value: {} by {}, ignore it.", (Object)csv, (Object)key);
                }
            }
            if (value == null) {
                csv = this.prop.getProperty(key);
                if (csv != null) {
                    try {
                        strInts = csv.split(",");
                        value = new int[strInts.length];
                        for (i = 0; i < strInts.length; ++i) {
                            value[i] = Integer.parseInt(strInts[i]);
                        }
                        logger.info("[{}] Got\"{}\" which means {} by {}", new Object[]{this.resourceName, csv, Arrays.toString(value), key});
                    }
                    catch (NumberFormatException e) {
                        logger.warn("[{}] {} is invalid for {}, use default value: {}", new Object[]{this.resourceName, csv, key, Arrays.toString(defaultValue)});
                        value = defaultValue;
                    }
                } else {
                    logger.info("[{}] Could not get value by {}, use default value: {}", new Object[]{this.resourceName, key, Arrays.toString(defaultValue)});
                    value = defaultValue;
                }
            }
            if (this.caching) {
                this.cache.put(key, value);
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearCache() {
        Map<String, Object> map = this.cache;
        synchronized (map) {
            this.cache.clear();
        }
    }
}

