/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.frame.PcapRecordHeader;
import io.pkts.packet.IPv4Packet;
import io.pkts.packet.PacketFactory;
import io.pkts.packet.TransportPacket;
import io.pkts.packet.TransportPacketFactory;
import io.pkts.packet.UDPPacket;
import io.pkts.packet.impl.IPv4PacketImpl;
import io.pkts.packet.impl.MACPacketImpl;
import io.pkts.packet.impl.PCapPacketImpl;
import io.pkts.packet.impl.UdpPacketImpl;
import io.pkts.protocol.IllegalProtocolException;
import io.pkts.protocol.Protocol;

public final class TransportPacketFactoryImpl
implements TransportPacketFactory {
    private static final byte[] ehternetII = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0};
    private static final byte[] ipv4 = new byte[]{69, 0, 1, -19, 0, 0, 0, 0, 64, 17, 58, -2, 127, 0, 0, 1, 127, 0, 0, 1};
    private static final byte[] udp = new byte[]{19, -30, 19, -60, 0, 0, -1, -20};
    private static final int udpLength = ehternetII.length + ipv4.length + udp.length;
    private final PacketFactory packetFactory;

    public TransportPacketFactoryImpl(PacketFactory factory) {
        this.packetFactory = factory;
    }

    @Override
    public TransportPacket create(Protocol protocol, String srcAddress, int srcPort, String destAddress, int destPort, Buffer payload) throws IllegalArgumentException, IllegalProtocolException {
        UDPPacket pkt = this.createUdpInternal(payload);
        IPv4Packet ipPkt = (IPv4Packet)pkt.getParentPacket();
        ipPkt.setDestinationIP(destAddress);
        ipPkt.setSourceIP(srcAddress);
        pkt.setDestinationPort(destPort);
        pkt.setSourcePort(srcPort);
        ipPkt.reCalculateChecksum();
        return pkt;
    }

    private UDPPacket createUdpInternal(long ts, Buffer payload) {
        int payloadSize = payload != null ? payload.getReadableBytes() : 0;
        Buffer ethernet = Buffers.wrapAndClone((byte[])ehternetII);
        Buffer ipv4 = Buffers.wrapAndClone((byte[])TransportPacketFactoryImpl.ipv4);
        PcapRecordHeader pcapRecordHeader = PcapRecordHeader.createDefaultHeader(ts);
        pcapRecordHeader.setCapturedLength(udpLength + payloadSize);
        pcapRecordHeader.setTotalLength(udpLength + payloadSize);
        PCapPacketImpl pkt = new PCapPacketImpl(pcapRecordHeader, null);
        MACPacketImpl mac = MACPacketImpl.create(pkt, ethernet);
        IPv4PacketImpl ipPacket = new IPv4PacketImpl(mac, ipv4, 0, null);
        ipPacket.setTotalLength(TransportPacketFactoryImpl.ipv4.length + udp.length + payloadSize);
        UdpPacketImpl udp = new UdpPacketImpl(ipPacket, Buffers.wrap((byte[])new byte[8]), payload);
        udp.setLength(8 + payloadSize);
        return udp;
    }

    private UDPPacket createUdpInternal(Buffer payload) {
        long ts = System.currentTimeMillis();
        return this.createUdpInternal(ts, payload);
    }

    @Override
    public TransportPacket create(Protocol protocol, byte[] srcAddress, int srcPort, byte[] destAddress, int destPort, Buffer payload) throws IllegalArgumentException, IllegalProtocolException {
        UDPPacket pkt = this.createUdpInternal(payload);
        IPv4Packet ipPkt = (IPv4Packet)pkt.getParentPacket();
        ipPkt.setSourceIP(srcAddress[0], srcAddress[1], srcAddress[2], srcAddress[3]);
        ipPkt.setDestinationIP(destAddress[0], destAddress[1], destAddress[2], destAddress[3]);
        pkt.setDestinationPort(destPort);
        pkt.setSourcePort(srcPort);
        ipPkt.reCalculateChecksum();
        return pkt;
    }

    @Override
    public UDPPacket createUDP(long ts, Buffer payload) throws IllegalArgumentException, IllegalProtocolException {
        return this.createUdpInternal(ts, payload);
    }

    @Override
    public UDPPacket createUDP(Buffer payload) throws IllegalArgumentException, IllegalProtocolException {
        return this.createUdpInternal(payload);
    }
}

