/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildhelper;

import java.io.File;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractAddResourceMojo
extends AbstractMojo {
    @Parameter(required=true)
    private Resource[] resources;
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;

    public void execute() {
        if (this.isSkip()) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)"Skipping plugin execution!");
            }
            return;
        }
        for (Resource resource : this.resources) {
            File resourceDir = new File(resource.getDirectory());
            if (!resourceDir.isAbsolute()) {
                resourceDir = new File(this.project.getBasedir(), resource.getDirectory());
                resource.setDirectory(resourceDir.getAbsolutePath());
            }
            if (this.isSkipIfMissing() && !resourceDir.exists()) {
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Skipping directory: " + resourceDir + ", because it does not exist."));
                continue;
            }
            this.addResource(resource);
        }
    }

    protected abstract boolean isSkipIfMissing();

    protected abstract boolean isSkip();

    public abstract void addResource(Resource var1);

    public MavenProject getProject() {
        return this.project;
    }
}

