/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules.files;

import java.io.File;
import java.io.IOException;
import javax.inject.Named;
import org.apache.maven.enforcer.rules.files.AbstractRequireFiles;

@Named(value="requireFilesExist")
public final class RequireFilesExist
extends AbstractRequireFiles {
    @Override
    boolean checkFile(File file) {
        return file == null ? true : file.exists() && this.osIndependentNameMatch(file, true);
    }

    @Override
    String getErrorMsg() {
        return "Some required files are missing:" + System.lineSeparator();
    }

    private boolean osIndependentNameMatch(File file, boolean defaultValue) {
        try {
            File absFile = !file.isAbsolute() ? new File(new File(".").getCanonicalFile(), file.getPath()) : file;
            return absFile.toURI().equals(absFile.getCanonicalFile().toURI());
        }
        catch (IOException e) {
            return defaultValue;
        }
    }
}

