/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules.utils;

import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.enforcer.rules.utils.ExpressionEvaluator;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

@Named
public class EnforcerRuleUtils {
    private final ExpressionEvaluator evaluator;

    @Inject
    public EnforcerRuleUtils(ExpressionEvaluator evaluator) {
        this.evaluator = Objects.requireNonNull(evaluator);
    }

    private void resolve(Plugin plugin) {
        try {
            plugin.setGroupId((String)this.evaluator.evaluate(plugin.getGroupId()));
            plugin.setArtifactId((String)this.evaluator.evaluate(plugin.getArtifactId()));
            plugin.setVersion((String)this.evaluator.evaluate(plugin.getVersion()));
        }
        catch (ExpressionEvaluationException expressionEvaluationException) {
            // empty catch block
        }
    }

    private void resolve(ReportPlugin plugin) {
        try {
            plugin.setGroupId((String)this.evaluator.evaluate(plugin.getGroupId()));
            plugin.setArtifactId((String)this.evaluator.evaluate(plugin.getArtifactId()));
            plugin.setVersion((String)this.evaluator.evaluate(plugin.getVersion()));
        }
        catch (ExpressionEvaluationException expressionEvaluationException) {
            // empty catch block
        }
    }

    public List<Plugin> resolvePlugins(List<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            this.resolve(plugin);
        }
        return plugins;
    }

    public List<ReportPlugin> resolveReportPlugins(List<ReportPlugin> reportPlugins) {
        for (ReportPlugin plugin : reportPlugins) {
            this.resolve(plugin);
        }
        return reportPlugins;
    }
}

