/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.filter;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import org.apache.commons.io.input.XmlStreamReader;
import org.apache.commons.io.output.XmlStreamWriter;
import org.apache.maven.plugins.assembly.filter.ContainerDescriptorHandler;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.ResourceIterator;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Named(value="plexus")
public class ComponentsXmlArchiverFileFilter
implements ContainerDescriptorHandler {
    public static final String COMPONENTS_XML_PATH = "META-INF/plexus/components.xml";
    Map<String, Xpp3Dom> components;
    private boolean excludeOverride = false;

    void addComponentsXml(Reader componentsReader) throws XmlPullParserException, IOException {
        Xpp3Dom newDom = Xpp3DomBuilder.build((Reader)componentsReader);
        if (newDom != null) {
            newDom = newDom.getChild("components");
        }
        if (newDom != null) {
            Xpp3Dom[] children;
            for (Xpp3Dom component : children = newDom.getChildren()) {
                if (this.components == null) {
                    this.components = new LinkedHashMap<String, Xpp3Dom>();
                }
                String role = component.getChild("role").getValue();
                Xpp3Dom child = component.getChild("role-hint");
                String roleHint = child != null ? child.getValue() : "";
                String key = role + roleHint;
                if (this.components.containsKey(key)) continue;
                this.components.put(key, component);
            }
        }
    }

    private void addToArchive(Archiver archiver) throws IOException {
        if (this.components != null) {
            File f = Files.createTempFile("maven-assembly-plugin", "tmp", new FileAttribute[0]).toFile();
            f.deleteOnExit();
            try (XmlStreamWriter fileWriter = ((XmlStreamWriter.Builder)XmlStreamWriter.builder().setOutputStream(Files.newOutputStream(f.toPath(), new OpenOption[0]))).get();){
                Xpp3Dom dom = new Xpp3Dom("component-set");
                Xpp3Dom componentDom = new Xpp3Dom("components");
                dom.addChild(componentDom);
                for (Xpp3Dom component : this.components.values()) {
                    componentDom.addChild(component);
                }
                Xpp3DomWriter.write((Writer)fileWriter, (Xpp3Dom)dom);
            }
            this.excludeOverride = true;
            archiver.addFile(f, COMPONENTS_XML_PATH);
            this.excludeOverride = false;
        }
    }

    public void finalizeArchiveCreation(Archiver archiver) {
        ResourceIterator it = archiver.getResources();
        while (it.hasNext()) {
            it.next();
        }
        try {
            this.addToArchive(archiver);
        }
        catch (IOException e) {
            throw new ArchiverException("Error finalizing component-set for archive. Reason: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<String> getVirtualFiles() {
        if (this.components != null && !this.components.isEmpty()) {
            return Collections.singletonList(COMPONENTS_XML_PATH);
        }
        return null;
    }

    public boolean isSelected(FileInfo fileInfo) throws IOException {
        if (fileInfo.isFile()) {
            if (this.excludeOverride) {
                return true;
            }
            String entry = fileInfo.getName().replace('\\', '/');
            if (entry.startsWith("/")) {
                entry = entry.substring(1);
            }
            if (COMPONENTS_XML_PATH.equals(entry)) {
                try (BufferedReader reader = new BufferedReader((Reader)((XmlStreamReader.Builder)XmlStreamReader.builder().setInputStream(fileInfo.getContents())).get());){
                    this.addComponentsXml(reader);
                }
                catch (XmlPullParserException e) {
                    throw new IOException("Error finalizing component-set for archive. Reason: " + e.getMessage(), e);
                }
                return false;
            }
            return true;
        }
        return true;
    }

    public void finalizeArchiveExtraction(UnArchiver unarchiver) {
    }
}

