/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.impl.recording;

import io.mockk.EqMatcher;
import io.mockk.EquivalentMatcher;
import io.mockk.InvocationMatcher;
import io.mockk.Matcher;
import io.mockk.RecordedCall;
import io.mockk.impl.InternalPlatform;
import io.mockk.impl.log.Logger;
import io.mockk.impl.log.SafeToString;
import io.mockk.impl.stub.StubRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010#\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u001aH\u0002J2\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\t2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00180\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0 H\u0002J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\tH\u0002J\u0010\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\tH\u0002J\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\t0\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u0017J\u0010\u0010%\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\tH\u0002R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006&"}, d2={"Lio/mockk/impl/recording/PermanentMocker;", "", "stubRepo", "Lio/mockk/impl/stub/StubRepository;", "safeToString", "Lio/mockk/impl/log/SafeToString;", "(Lio/mockk/impl/stub/StubRepository;Lio/mockk/impl/log/SafeToString;)V", "callRef", "", "Lio/mockk/RecordedCall;", "getCallRef", "()Ljava/util/Map;", "log", "Lio/mockk/impl/log/Logger;", "getLog", "()Lio/mockk/impl/log/Logger;", "permanentMocks", "getPermanentMocks", "getSafeToString", "()Lio/mockk/impl/log/SafeToString;", "getStubRepo", "()Lio/mockk/impl/stub/StubRepository;", "describeCallTree", "", "", "calls", "", "formatCall", "call", "tree", "", "usedCalls", "", "makeCallPermanent", "makeEquivalent", "newCall", "mock", "permamentize", "mockk"})
@SourceDebugExtension(value={"SMAP\nPermanentMocker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PermanentMocker.kt\nio/mockk/impl/recording/PermanentMocker\n+ 2 Logger.kt\nio/mockk/impl/log/Logger$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n19#2:150\n1549#3:151\n1620#3,3:152\n1549#3:155\n1620#3,3:156\n1549#3:159\n1620#3,3:160\n766#3:163\n857#3,2:164\n1549#3:166\n1620#3,3:167\n1549#3:170\n1620#3,3:171\n*S KotlinDebug\n*F\n+ 1 PermanentMocker.kt\nio/mockk/impl/recording/PermanentMocker\n*L\n16#1:150\n62#1:151\n62#1:152,3\n76#1:155\n76#1:156,3\n84#1:159\n84#1:160,3\n105#1:163\n105#1:164,2\n107#1:166\n107#1:167,3\n118#1:170\n118#1:171,3\n*E\n"})
public final class PermanentMocker {
    @NotNull
    private final StubRepository stubRepo;
    @NotNull
    private final SafeToString safeToString;
    @NotNull
    private final Logger log;
    @NotNull
    private final Map<Object, Object> permanentMocks;
    @NotNull
    private final Map<Object, RecordedCall> callRef;

    public PermanentMocker(@NotNull StubRepository stubRepo, @NotNull SafeToString safeToString2) {
        Intrinsics.checkNotNullParameter((Object)stubRepo, (String)"stubRepo");
        Intrinsics.checkNotNullParameter((Object)safeToString2, (String)"safeToString");
        this.stubRepo = stubRepo;
        this.safeToString = safeToString2;
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$invoke = false;
        this.log = this.safeToString.invoke((Logger)this_$iv.getLoggerFactory().invoke((Object)Reflection.getOrCreateKotlinClass(PermanentMocker.class)));
        this.permanentMocks = InternalPlatform.INSTANCE.identityMap();
        this.callRef = InternalPlatform.INSTANCE.weakMap();
    }

    @NotNull
    public final StubRepository getStubRepo() {
        return this.stubRepo;
    }

    @NotNull
    public final SafeToString getSafeToString() {
        return this.safeToString;
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    @NotNull
    public final Map<Object, Object> getPermanentMocks() {
        return this.permanentMocks;
    }

    @NotNull
    public final Map<Object, RecordedCall> getCallRef() {
        return this.callRef;
    }

    @NotNull
    public final List<RecordedCall> mock(@NotNull List<RecordedCall> calls2) {
        Intrinsics.checkNotNullParameter(calls2, (String)"calls");
        List result2 = new ArrayList();
        for (RecordedCall call2 : calls2) {
            RecordedCall permanentCall = this.permamentize(call2);
            result2.add(permanentCall);
        }
        List callTree2 = (List)this.safeToString.exec((Function0)new Function0<List<? extends String>>(this, (List<RecordedCall>)result2){
            final /* synthetic */ PermanentMocker this$0;
            final /* synthetic */ List<RecordedCall> $result;
            {
                this.this$0 = $receiver;
                this.$result = $result;
                super(0);
            }

            @NotNull
            public final List<String> invoke() {
                return PermanentMocker.access$describeCallTree(this.this$0, this.$result);
            }
        });
        if (callTree2.size() == 1) {
            this.log.trace((Function0<String>)((Function0)new Function0<String>((List<String>)callTree2){
                final /* synthetic */ List<String> $callTree;
                {
                    this.$callTree = $callTree;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Mocked permanently: " + this.$callTree.get(0);
                }
            }));
        } else {
            this.log.trace((Function0<String>)((Function0)new Function0<String>((List<String>)callTree2){
                final /* synthetic */ List<String> $callTree;
                {
                    this.$callTree = $callTree;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Mocked permanently:\n" + CollectionsKt.joinToString$default((Iterable)this.$callTree, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                }
            }));
        }
        return result2;
    }

    private final RecordedCall permamentize(RecordedCall call2) {
        RecordedCall newCall = this.makeCallPermanent(call2);
        Object retValue = call2.getRetValue();
        if (call2.isRetValueMock() && retValue != null) {
            RecordedCall equivalentCall = this.makeEquivalent(newCall);
            this.log.trace((Function0<String>)((Function0)new Function0<String>(equivalentCall){
                final /* synthetic */ RecordedCall $equivalentCall;
                {
                    this.$equivalentCall = $equivalentCall;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Child search key: " + this.$equivalentCall.getMatcher();
                }
            }));
            Object childMock = this.stubRepo.stubFor(newCall.getMatcher().getSelf()).childMockK(equivalentCall.getMatcher(), equivalentCall.getRetType());
            RecordedCall newNewCall = RecordedCall.copy$default((RecordedCall)newCall, (Object)childMock, (boolean)false, null, null, null, null, (int)62, null);
            this.permanentMocks.put(retValue, childMock);
            this.callRef.put(retValue, newNewCall);
            return newNewCall;
        }
        return newCall;
    }

    /*
     * WARNING - void declaration
     */
    private final RecordedCall makeEquivalent(RecordedCall newCall) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = newCall.getMatcher().getArgs();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Matcher matcher = (Matcher)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it instanceof EquivalentMatcher ? ((EquivalentMatcher)it).equivalent() : it);
        }
        List equivalentArgs = (List)destination$iv$iv;
        InvocationMatcher equivalentIM = InvocationMatcher.copy$default((InvocationMatcher)newCall.getMatcher(), null, null, (List)equivalentArgs, (boolean)false, (int)11, null);
        return RecordedCall.copy$default((RecordedCall)newCall, null, (boolean)false, null, (InvocationMatcher)equivalentIM, null, null, (int)55, null);
    }

    /*
     * WARNING - void declaration
     */
    private final RecordedCall makeCallPermanent(RecordedCall call2) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        RecordedCall selfChain = this.callRef.get(call2.getMatcher().getSelf());
        Iterable iterable = call2.getMatcher().getArgs();
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            RecordedCall recordedCall;
            void it;
            Matcher matcher = (Matcher)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            if (it instanceof EqMatcher) {
                recordedCall = this.callRef.get(((EqMatcher)it).getValue());
                if (recordedCall == null) {
                    recordedCall = it;
                }
            } else {
                recordedCall = it;
            }
            collection.add(recordedCall);
        }
        List argChains = (List)destination$iv$iv;
        Object object = this.permanentMocks.get(call2.getMatcher().getSelf());
        if (object == null) {
            object = call2.getMatcher().getSelf();
        }
        Object newSelf = object;
        Iterable $this$map$iv2 = call2.getMatcher().getArgs();
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Matcher matcher = (Matcher)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.substitute(this.permanentMocks));
        }
        List newArgs = (List)destination$iv$iv2;
        InvocationMatcher newMatcher = InvocationMatcher.copy$default((InvocationMatcher)call2.getMatcher(), (Object)newSelf, null, (List)newArgs, (boolean)false, (int)10, null);
        return RecordedCall.copy$default((RecordedCall)call2, null, (boolean)false, null, (InvocationMatcher)newMatcher, (RecordedCall)selfChain, (List)argChains, (int)7, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> describeCallTree(List<RecordedCall> calls2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        RecordedCall it;
        void $this$filterTo$iv$iv;
        LinkedHashMap callTree2 = new LinkedHashMap();
        HashSet usedCalls = new HashSet();
        for (RecordedCall call2 : calls2) {
            ((Map)callTree2).put(call2, this.formatCall(call2, callTree2, usedCalls));
        }
        Iterable $this$filter$iv = calls2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (RecordedCall)element$iv$iv;
            boolean bl = false;
            if (!(!usedCalls.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (RecordedCall)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = (String)callTree2.get(it);
            if (string == null) {
                string = "<bad call>";
            }
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final String formatCall(RecordedCall call2, Map<RecordedCall, String> tree, Set<RecordedCall> usedCalls) {
        String prefix;
        String string;
        void $this$mapTo$iv$iv;
        String methodName = call2.getMatcher().getMethod().getName();
        List list = call2.getArgChains();
        Intrinsics.checkNotNull((Object)list);
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string2;
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (it instanceof RecordedCall) {
                usedCalls.add((RecordedCall)it);
                string2 = tree.get(it);
                if (string2 == null) {
                    string2 = "<bad link>";
                }
            } else {
                string2 = it.toString();
            }
            collection.add(string2);
        }
        List args = (List)destination$iv$iv;
        RecordedCall selfChain = call2.getSelfChain();
        if (selfChain != null) {
            usedCalls.add(selfChain);
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = tree.get(selfChain);
            if (string3 == null) {
                string3 = "<bad link>";
            }
            string = stringBuilder.append(string3).append('.').toString();
        } else {
            string = prefix = "" + call2.getMatcher().getSelf() + '.';
        }
        if (StringsKt.startsWith$default((String)methodName, (String)"get", (boolean)false, (int)2, null) && methodName.length() > 3 && args.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder().append(prefix).append(Character.toLowerCase(methodName.charAt(3)));
            String string4 = methodName.substring(4);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
            return stringBuilder.append(string4).toString();
        }
        return prefix + methodName + '(' + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ')';
    }

    public static final /* synthetic */ List access$describeCallTree(PermanentMocker $this, List calls2) {
        return $this.describeCallTree(calls2);
    }
}

