/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.property.classifications;

import io.kotest.common.ExperimentalKotest;
import io.kotest.property.PropertyResult;
import io.kotest.property.classifications.LabelsReporter;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J(\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0002\u00a8\u0006\u000e"}, d2={"Lio/kotest/property/classifications/StandardLabelsReporter;", "Lio/kotest/property/classifications/LabelsReporter;", "()V", "output", "", "result", "Lio/kotest/property/PropertyResult;", "row", "label", "", "count", "", "attempts", "countPad", "kotest-property"})
@ExperimentalKotest
@SourceDebugExtension(value={"SMAP\nLabelsReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LabelsReporter.kt\nio/kotest/property/classifications/StandardLabelsReporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,39:1\n1855#2:40\n1856#2:43\n215#3,2:41\n*S KotlinDebug\n*F\n+ 1 LabelsReporter.kt\nio/kotest/property/classifications/StandardLabelsReporter\n*L\n26#1:40\n26#1:43\n28#1:41,2\n*E\n"})
public final class StandardLabelsReporter
implements LabelsReporter {
    @NotNull
    public static final StandardLabelsReporter INSTANCE = new StandardLabelsReporter();

    private StandardLabelsReporter() {
    }

    private final void row(String label, int count, int attempts, int countPad) {
        int percentage = Math.max(MathKt.roundToInt((double)((double)count / (double)attempts * 100.0)), 1);
        System.out.println((Object)(StringsKt.padEnd((String)label, (int)60, (char)' ') + ' ' + StringsKt.padStart((String)String.valueOf(count), (int)countPad, (char)' ') + " (" + percentage + "%)"));
    }

    @Override
    public void output(@NotNull PropertyResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        int countPad = String.valueOf(result.getAttempts()).length();
        Iterable $this$forEach$iv = result.getInputs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            int other;
            String arg = (String)element$iv;
            boolean bl = false;
            System.out.println((Object)("Label statistics for arg " + arg + " (" + result.getAttempts() + " inputs):"));
            if (result.getLabels().get(arg) != null) {
                Map<String, Integer> $this$forEach$iv2;
                boolean $i$f$forEach2 = false;
                Iterator<Map.Entry<String, Integer>> iterator = $this$forEach$iv2.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Integer> element$iv2;
                    Map.Entry<String, Integer> entry = element$iv2 = iterator.next();
                    boolean bl2 = false;
                    String label = entry.getKey();
                    int count = ((Number)entry.getValue()).intValue();
                    INSTANCE.row(label, count, result.getAttempts(), countPad);
                }
            }
            if ((other = result.getAttempts() - ((object = result.getLabels().get(arg)) != null && (object = object.values()) != null ? CollectionsKt.sumOfInt((Iterable)((Iterable)object)) : 0)) > 0) {
                INSTANCE.row("OTHER", other, result.getAttempts(), countPad);
            }
            System.out.println();
        }
    }
}

