/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.filtering;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;

public class AbstractMavenFilteringRequest {
    private MavenProject mavenProject;
    private List<String> filters;
    private boolean escapeWindowsPaths = true;
    private MavenSession mavenSession;
    private List<String> projectStartExpressions = new ArrayList<String>();
    private String escapeString;
    private Properties additionalProperties;
    private boolean injectProjectBuildFilters = false;
    private LinkedHashSet<String> delimiters = new LinkedHashSet();
    private boolean supportMultiLineFiltering;

    protected AbstractMavenFilteringRequest() {
        this.initDefaults();
    }

    protected AbstractMavenFilteringRequest(MavenProject mavenProject, List<String> filters, MavenSession mavenSession) {
        this.initDefaults();
        this.mavenProject = mavenProject;
        this.filters = filters;
        this.mavenSession = mavenSession;
    }

    private void initDefaults() {
        this.projectStartExpressions.add("pom");
        this.projectStartExpressions.add("project");
        this.delimiters.add("${*}");
        this.delimiters.add("@");
    }

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    public List<String> getFilters() {
        return this.filters;
    }

    public void setFilters(List<String> filters) {
        this.filters = filters;
    }

    public List<String> getFileFilters() {
        return this.getFilters();
    }

    public void setFileFilters(List<String> paramfilters) {
        this.setFilters(paramfilters);
    }

    public boolean isEscapeWindowsPaths() {
        return this.escapeWindowsPaths;
    }

    public void setEscapeWindowsPaths(boolean escapedBackslashesInFilePath) {
        this.escapeWindowsPaths = escapedBackslashesInFilePath;
    }

    public boolean isEscapedBackslashesInFilePath() {
        return this.isEscapeWindowsPaths();
    }

    public void setEscapedBackslashesInFilePath(boolean escape) {
        this.setEscapeWindowsPaths(escape);
    }

    public MavenSession getMavenSession() {
        return this.mavenSession;
    }

    public void setMavenSession(MavenSession mavenSession) {
        this.mavenSession = mavenSession;
    }

    public Properties getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Properties additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public boolean isInjectProjectBuildFilters() {
        return this.injectProjectBuildFilters;
    }

    public void setInjectProjectBuildFilters(boolean injectProjectBuildFilters) {
        this.injectProjectBuildFilters = injectProjectBuildFilters;
    }

    public String getEscapeString() {
        return this.escapeString;
    }

    public void setEscapeString(String escapeString) {
        this.escapeString = escapeString;
    }

    public List<String> getProjectStartExpressions() {
        return this.projectStartExpressions;
    }

    public void setProjectStartExpressions(List<String> projectStartExpressions) {
        this.projectStartExpressions = projectStartExpressions;
    }

    public LinkedHashSet<String> getDelimiters() {
        return this.delimiters;
    }

    public void setDelimiters(LinkedHashSet<String> delimiters) {
        if (delimiters == null || delimiters.isEmpty()) {
            this.delimiters.clear();
            this.delimiters.add("${*}");
        } else {
            this.delimiters = delimiters;
        }
    }

    public void setDelimiters(LinkedHashSet<String> delimiters, boolean useDefaultDelimiters) {
        if (delimiters != null && !delimiters.isEmpty()) {
            LinkedHashSet<String> delims = new LinkedHashSet<String>();
            if (useDefaultDelimiters) {
                delims.addAll(this.getDelimiters());
            }
            for (String delim : delimiters) {
                if (delim == null) {
                    delims.add("${*}");
                    continue;
                }
                delims.add(delim);
            }
            this.setDelimiters(delims);
        }
    }

    public boolean isSupportMultiLineFiltering() {
        return this.supportMultiLineFiltering;
    }

    public void setSupportMultiLineFiltering(boolean supportMultiLineFiltering) {
        this.supportMultiLineFiltering = supportMultiLineFiltering;
    }
}

