/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.IMetricsAggregator;
import io.sentry.ISentryExecutorService;
import io.sentry.MeasurementUnit;
import io.sentry.NoOpSentryExecutorService;
import io.sentry.SentryDateProvider;
import io.sentry.SentryExecutorService;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.metrics.CounterMetric;
import io.sentry.metrics.DistributionMetric;
import io.sentry.metrics.EncodedMetrics;
import io.sentry.metrics.GaugeMetric;
import io.sentry.metrics.IMetricsClient;
import io.sentry.metrics.LocalMetricsAggregator;
import io.sentry.metrics.Metric;
import io.sentry.metrics.MetricType;
import io.sentry.metrics.MetricsHelper;
import io.sentry.metrics.SetMetric;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.CRC32;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class MetricsAggregator
implements IMetricsAggregator,
Runnable,
Closeable {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    @NotNull
    private final ILogger logger;
    @NotNull
    private final IMetricsClient client;
    @NotNull
    private final SentryDateProvider dateProvider;
    @Nullable
    private final SentryOptions.BeforeEmitMetricCallback beforeEmitCallback;
    @NotNull
    private volatile ISentryExecutorService executorService;
    private volatile boolean isClosed = false;
    private volatile boolean flushScheduled = false;
    @NotNull
    private final NavigableMap<Long, Map<String, Metric>> buckets = new ConcurrentSkipListMap<Long, Map<String, Metric>>();
    @NotNull
    private final AtomicInteger totalBucketsWeight = new AtomicInteger();
    private final int maxWeight;

    public MetricsAggregator(@NotNull SentryOptions options, @NotNull IMetricsClient client) {
        this(client, options.getLogger(), options.getDateProvider(), 100000, options.getBeforeEmitMetricCallback(), NoOpSentryExecutorService.getInstance());
    }

    @TestOnly
    public MetricsAggregator(@NotNull IMetricsClient client, @NotNull ILogger logger, @NotNull SentryDateProvider dateProvider, int maxWeight, @Nullable SentryOptions.BeforeEmitMetricCallback beforeEmitCallback, @NotNull ISentryExecutorService executorService) {
        this.client = client;
        this.logger = logger;
        this.dateProvider = dateProvider;
        this.maxWeight = maxWeight;
        this.beforeEmitCallback = beforeEmitCallback;
        this.executorService = executorService;
    }

    @Override
    public void increment(@NotNull String key, double value, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags, long timestampMs, @Nullable LocalMetricsAggregator localMetricsAggregator) {
        this.add(MetricType.Counter, key, value, unit, tags, timestampMs, localMetricsAggregator);
    }

    @Override
    public void gauge(@NotNull String key, double value, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags, long timestampMs, @Nullable LocalMetricsAggregator localMetricsAggregator) {
        this.add(MetricType.Gauge, key, value, unit, tags, timestampMs, localMetricsAggregator);
    }

    @Override
    public void distribution(@NotNull String key, double value, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags, long timestampMs, @Nullable LocalMetricsAggregator localMetricsAggregator) {
        this.add(MetricType.Distribution, key, value, unit, tags, timestampMs, localMetricsAggregator);
    }

    @Override
    public void set(@NotNull String key, int value, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags, long timestampMs, @Nullable LocalMetricsAggregator localMetricsAggregator) {
        this.add(MetricType.Set, key, value, unit, tags, timestampMs, localMetricsAggregator);
    }

    @Override
    public void set(@NotNull String key, @NotNull String value, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags, long timestampMs, @Nullable LocalMetricsAggregator localMetricsAggregator) {
        byte[] bytes = value.getBytes(UTF8);
        CRC32 crc = new CRC32();
        crc.update(bytes, 0, bytes.length);
        int intValue = (int)crc.getValue();
        this.add(MetricType.Set, key, intValue, unit, tags, timestampMs, localMetricsAggregator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(@NotNull MetricType type, @NotNull String key, double value, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags, long timestampMs, @Nullable LocalMetricsAggregator localMetricsAggregator) {
        int addedWeight;
        if (this.isClosed) {
            return;
        }
        if (this.beforeEmitCallback != null) {
            try {
                if (!this.beforeEmitCallback.execute(key, tags)) {
                    return;
                }
            }
            catch (Throwable e) {
                this.logger.log(SentryLevel.ERROR, "The beforeEmit callback threw an exception.", e);
            }
        }
        long timeBucketKey = MetricsHelper.getTimeBucketKey(timestampMs);
        @NotNull Map<String, Metric> timeBucket = this.getOrAddTimeBucket(timeBucketKey);
        @NotNull String metricKey = MetricsHelper.getMetricBucketKey(type, key, unit, tags);
        Map<String, Metric> map = timeBucket;
        synchronized (map) {
            @Nullable Metric existingMetric = timeBucket.get(metricKey);
            if (existingMetric != null) {
                int oldWeight = existingMetric.getWeight();
                existingMetric.add(value);
                addedWeight = existingMetric.getWeight() - oldWeight;
            } else {
                Metric metric;
                switch (type) {
                    case Counter: {
                        metric = new CounterMetric(key, value, unit, tags);
                        break;
                    }
                    case Gauge: {
                        metric = new GaugeMetric(key, value, unit, tags);
                        break;
                    }
                    case Distribution: {
                        metric = new DistributionMetric(key, value, unit, tags);
                        break;
                    }
                    case Set: {
                        metric = new SetMetric(key, unit, tags);
                        metric.add((int)value);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown MetricType: " + type.name());
                    }
                }
                addedWeight = metric.getWeight();
                timeBucket.put(metricKey, metric);
            }
            this.totalBucketsWeight.addAndGet(addedWeight);
        }
        if (localMetricsAggregator != null) {
            double localValue = type == MetricType.Set ? (double)addedWeight : value;
            localMetricsAggregator.add(metricKey, type, key, localValue, unit, tags);
        }
        boolean isOverWeight = this.isOverWeight();
        if (!(this.isClosed || !isOverWeight && this.flushScheduled)) {
            MetricsAggregator metricsAggregator = this;
            synchronized (metricsAggregator) {
                if (!this.isClosed) {
                    if (this.executorService instanceof NoOpSentryExecutorService) {
                        this.executorService = new SentryExecutorService();
                    }
                    this.flushScheduled = true;
                    long delayMs = isOverWeight ? 0L : 5000L;
                    this.executorService.schedule(this, delayMs);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(boolean force) {
        if (!force && this.isOverWeight()) {
            this.logger.log(SentryLevel.INFO, "Metrics: total weight exceeded, flushing all buckets", new Object[0]);
            force = true;
        }
        this.flushScheduled = false;
        @NotNull Set<Long> flushableBuckets = this.getFlushableBuckets(force);
        if (flushableBuckets.isEmpty()) {
            this.logger.log(SentryLevel.DEBUG, "Metrics: nothing to flush", new Object[0]);
            return;
        }
        this.logger.log(SentryLevel.DEBUG, "Metrics: flushing " + flushableBuckets.size() + " buckets", new Object[0]);
        HashMap<Long, Map<String, Metric>> snapshot = new HashMap<Long, Map<String, Metric>>();
        int numMetrics = 0;
        for (long bucketKey : flushableBuckets) {
            @Nullable Map bucket = (Map)this.buckets.remove(bucketKey);
            if (bucket == null) continue;
            Map map = bucket;
            synchronized (map) {
                int weight = MetricsAggregator.getBucketWeight(bucket);
                this.totalBucketsWeight.addAndGet(-weight);
                numMetrics += bucket.size();
                snapshot.put(bucketKey, bucket);
            }
        }
        if (numMetrics == 0) {
            this.logger.log(SentryLevel.DEBUG, "Metrics: only empty buckets found", new Object[0]);
            return;
        }
        this.logger.log(SentryLevel.DEBUG, "Metrics: capturing metrics", new Object[0]);
        this.client.captureMetrics(new EncodedMetrics(snapshot));
    }

    private boolean isOverWeight() {
        int totalWeight = this.buckets.size() + this.totalBucketsWeight.get();
        return totalWeight >= this.maxWeight;
    }

    private static int getBucketWeight(@NotNull Map<String, Metric> bucket) {
        int weight = 0;
        for (Metric value : bucket.values()) {
            weight += value.getWeight();
        }
        return weight;
    }

    @NotNull
    private Set<Long> getFlushableBuckets(boolean force) {
        if (force) {
            return this.buckets.keySet();
        }
        long cutoffTimestampMs = MetricsHelper.getCutoffTimestampMs(this.nowMillis());
        long cutoffKey = MetricsHelper.getTimeBucketKey(cutoffTimestampMs);
        return this.buckets.headMap(cutoffKey, true).keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<String, Metric> getOrAddTimeBucket(long bucketKey) {
        @Nullable HashMap<K, V> bucket = (HashMap)this.buckets.get(bucketKey);
        if (bucket == null) {
            NavigableMap<Long, Map<String, Metric>> navigableMap = this.buckets;
            synchronized (navigableMap) {
                bucket = (Map)this.buckets.get(bucketKey);
                if (bucket == null) {
                    bucket = new HashMap();
                    this.buckets.put(bucketKey, bucket);
                }
            }
        }
        return bucket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        MetricsAggregator metricsAggregator = this;
        synchronized (metricsAggregator) {
            this.isClosed = true;
            this.executorService.close(0L);
        }
        this.flush(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.flush(false);
        MetricsAggregator metricsAggregator = this;
        synchronized (metricsAggregator) {
            if (!this.isClosed && !this.buckets.isEmpty()) {
                this.executorService.schedule(this, 5000L);
            }
        }
    }

    private long nowMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.dateProvider.now().nanoTimestamp());
    }
}

