/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.util.Objects;
import io.sentry.util.StringUtils;
import java.io.IOException;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class SpanId
implements JsonSerializable {
    public static final SpanId EMPTY_ID = new SpanId(new UUID(0L, 0L));
    @NotNull
    private final String value;

    public SpanId(@NotNull String value) {
        this.value = Objects.requireNonNull(value, "value is required");
    }

    public SpanId() {
        this(UUID.randomUUID());
    }

    private SpanId(@NotNull UUID uuid) {
        this(StringUtils.normalizeUUID(uuid.toString()).replace("-", "").substring(0, 16));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpanId spanId = (SpanId)o;
        return this.value.equals(spanId.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer, @NotNull ILogger logger) throws IOException {
        writer.value(this.value);
    }

    public static final class Deserializer
    implements JsonDeserializer<SpanId> {
        @Override
        @NotNull
        public SpanId deserialize(@NotNull ObjectReader reader, @NotNull ILogger logger) throws Exception {
            return new SpanId(reader.nextString());
        }
    }
}

