/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.metrics;

import io.sentry.MeasurementUnit;
import io.sentry.metrics.Metric;
import io.sentry.metrics.MetricType;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CounterMetric
extends Metric {
    private double value;

    public CounterMetric(@NotNull String key, double value, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags) {
        super(MetricType.Counter, key, unit, tags);
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public void add(double value) {
        this.value += value;
    }

    @Override
    public int getWeight() {
        return 1;
    }

    @Override
    @NotNull
    public Iterable<?> serialize() {
        return Collections.singletonList(this.value);
    }
}

