/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.util;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class LazyEvaluator<T> {
    @Nullable
    private volatile T value = null;
    @NotNull
    private final Evaluator<T> evaluator;

    public LazyEvaluator(@NotNull Evaluator<T> evaluator) {
        this.evaluator = evaluator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public T getValue() {
        if (this.value == null) {
            LazyEvaluator lazyEvaluator = this;
            synchronized (lazyEvaluator) {
                if (this.value == null) {
                    this.value = this.evaluator.evaluate();
                }
            }
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(@Nullable T value) {
        LazyEvaluator lazyEvaluator = this;
        synchronized (lazyEvaluator) {
            this.value = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetValue() {
        LazyEvaluator lazyEvaluator = this;
        synchronized (lazyEvaluator) {
            this.value = null;
        }
    }

    public static interface Evaluator<T> {
        @NotNull
        public T evaluate();
    }
}

