/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.util.thread;

import io.sentry.protocol.SentryThread;
import io.sentry.util.thread.IMainThreadChecker;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class MainThreadChecker
implements IMainThreadChecker {
    private static final long mainThreadId = Thread.currentThread().getId();
    private static final MainThreadChecker instance = new MainThreadChecker();

    public static MainThreadChecker getInstance() {
        return instance;
    }

    private MainThreadChecker() {
    }

    @Override
    public boolean isMainThread(long threadId) {
        return mainThreadId == threadId;
    }

    @Override
    public boolean isMainThread(@NotNull Thread thread) {
        return this.isMainThread(thread.getId());
    }

    @Override
    public boolean isMainThread() {
        return this.isMainThread(Thread.currentThread());
    }

    @Override
    public boolean isMainThread(@NotNull SentryThread sentryThread) {
        Long threadId = sentryThread.getId();
        return threadId != null && this.isMainThread(threadId);
    }
}

